/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.data;

import com.techempower.data.DatabaseConnectionListener;
import com.techempower.data.jdbc.JdbcConnector;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.notification.BasicNotification;
import com.techempower.gemini.admin.notification.Notification;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import com.techempower.util.StringList;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BasicConnectorListener
implements DatabaseConnectionListener {
    public static final String COMPONENT_CODE = "dbcl";
    public static final String DEFAULT_PROPERTY_PREFIX = "ConnectorListener.";
    public static final int DEFAULT_MAX_ALERTS_PER = 10;
    private final GeminiApplication application;
    private final ComponentLog log;
    private final List<String> currentAlerts;
    private final String propertyPrefix;
    private String alertLogFile = "";
    private long notificationFrequency = 3600000L;
    private int maximumAlertsPerNotification = 10;
    private long lastNotification = 0L;
    private int currentOverflow;
    private int retriesOnDisconnect = 1;

    public BasicConnectorListener(GeminiApplication application, String propertyPrefix) {
        this.application = application;
        this.log = application.getLog(COMPONENT_CODE);
        this.currentAlerts = new ArrayList<String>();
        this.propertyPrefix = StringHelper.isNonEmpty(propertyPrefix) ? propertyPrefix : DEFAULT_PROPERTY_PREFIX;
    }

    public BasicConnectorListener(GeminiApplication application) {
        this(application, DEFAULT_PROPERTY_PREFIX);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.notificationFrequency = 1000L * (long)props.getIntegerProperty(String.valueOf(this.propertyPrefix) + "EmailFrequency", (int)(this.notificationFrequency / 1000L));
        this.notificationFrequency = 1000L * (long)props.getIntegerProperty(String.valueOf(this.propertyPrefix) + "NotificationFrequency", (int)(this.notificationFrequency / 1000L));
        this.maximumAlertsPerNotification = props.getIntegerProperty(String.valueOf(this.propertyPrefix) + "MaximumAlertsPerMail", this.maximumAlertsPerNotification);
        this.maximumAlertsPerNotification = props.getIntegerProperty(String.valueOf(this.propertyPrefix) + "MaximumAlertsPerNotification", this.maximumAlertsPerNotification);
        this.alertLogFile = props.getProperty(String.valueOf(this.propertyPrefix) + "AlertLogFile", this.alertLogFile);
        this.retriesOnDisconnect = props.getIntegerProperty(String.valueOf(this.propertyPrefix) + "RetriesOnDisconnect", this.retriesOnDisconnect);
        if (StringHelper.isNonEmpty(this.alertLogFile)) {
            this.log.log("Alert file: " + this.alertLogFile);
        } else {
            this.log.log("No dbconn listener alert log file specified.");
        }
    }

    protected synchronized void processAlert(String alert) {
        this.log.log("Processing: " + alert, 10);
        this.logAlert(alert);
        if (this.currentAlerts.size() < this.maximumAlertsPerNotification) {
            this.currentAlerts.add(alert);
        } else {
            ++this.currentOverflow;
        }
        if (System.currentTimeMillis() > this.lastNotification + this.notificationFrequency) {
            this.processNotification();
            this.currentAlerts.clear();
        }
    }

    protected void logAlert(String alert) {
        if (StringHelper.isNonEmpty(this.alertLogFile)) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileWriter writer = new FileWriter(this.alertLogFile, true);){
                    writer.write(String.valueOf(alert) + "\r\n");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioexc) {
                this.log.log("IOException while writing alert: " + ioexc);
            }
        }
    }

    protected void processNotification() {
        StringList alerts = new StringList("\n\n");
        for (String alert : this.currentAlerts) {
            alerts.add(alert);
        }
        String synopsis = String.valueOf(this.currentAlerts.size()) + " database connectivity alert" + StringHelper.pluralize(this.currentAlerts.size());
        StringBuilder details = new StringBuilder();
        details.append(String.valueOf(this.currentAlerts.size()) + " database connectivity alert" + StringHelper.pluralize(this.currentAlerts.size()));
        details.append(" (" + this.currentOverflow + " overflow; " + this.notificationFrequency + " minute frequency)\n\n");
        details.append(alerts.toString());
        BasicNotification notification = new BasicNotification("db", synopsis, details.toString(), Notification.Severity.HIGH);
        this.application.getNotifier().addNotification(notification);
        this.lastNotification = System.currentTimeMillis();
    }

    protected boolean shouldProcess(SQLException sqlexc, JdbcConnector conn) {
        return true;
    }

    @Override
    public int exceptionInRunQuery(SQLException exc, JdbcConnector conn) {
        if (this.shouldProcess(exc, conn)) {
            String alert = "Exception in runQuery\r\nTime: " + DateHelper.format(new Date()) + "\r\n" + "Query: " + conn.getQuery() + "\r\n" + "Exception: " + exc.toString() + "\r\n" + "SQLState: " + exc.getSQLState() + "\r\n" + "Error code: " + exc.getErrorCode() + "\r\n";
            this.processAlert(alert);
            if (this.retriesOnDisconnect >= conn.getTryCount() && this.isConnectionException(exc)) {
                return 5000;
            }
        }
        return 0;
    }

    @Override
    public int exceptionInRunUpdateQuery(SQLException exc, JdbcConnector conn) {
        if (this.shouldProcess(exc, conn)) {
            String alert = "Exception in runUpdateQuery\r\nTime: " + DateHelper.format(new Date()) + "\r\n" + "Query: " + conn.getQuery() + "\r\n" + "Exception: " + exc.toString() + "\r\n" + "SQLState: " + exc.getSQLState() + "\r\n" + "Error code: " + exc.getErrorCode() + "\r\n";
            this.processAlert(alert);
            if (this.retriesOnDisconnect >= conn.getTryCount() && this.isConnectionException(exc)) {
                return 5000;
            }
        }
        return 0;
    }

    @Override
    public int exceptionInExecuteBatch(SQLException exc, JdbcConnector conn) {
        if (this.shouldProcess(exc, conn)) {
            String alert = "Exception in executeBatch\r\nTime: " + DateHelper.format(new Date()) + "\r\n" + "Query: " + conn.getQuery() + "\r\n" + "Exception: " + exc.toString() + "\r\n" + "SQLState: " + exc.getSQLState() + "\r\n" + "Error code: " + exc.getErrorCode() + "\r\n";
            this.processAlert(alert);
            if (this.retriesOnDisconnect >= conn.getTryCount() && this.isConnectionException(exc)) {
                return 5000;
            }
        }
        return 0;
    }

    @Override
    public void queryStarting() {
    }

    @Override
    public void queryCompleting() {
    }

    public boolean isConnectionException(SQLException sqlexc) {
        return sqlexc.getSQLState().startsWith("08");
    }
}

