/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.data;

import com.techempower.asynchronous.Asynchronous;
import com.techempower.data.ConnectorFactory;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.data.SqlQueueEvent;
import com.techempower.gemini.data.SqlRunner;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.ArrayList;
import java.util.Collection;

public class SqlQueue
implements Configurable,
Asynchronous {
    public static final int DEFAULT_MAXIMUM_SIZE = 100;
    private final GeminiApplication application;
    private final ConnectorFactory connectorFactory;
    private final ComponentLog log;
    private Collection<String> queue = new ArrayList<String>();
    private int maxSize = 100;
    private int eventInterval = 0;

    public SqlQueue(GeminiApplication application) {
        this(application, application.getConnectorFactory());
    }

    public SqlQueue(GeminiApplication application, ConnectorFactory connectorFactory) {
        this.application = application;
        this.connectorFactory = connectorFactory;
        this.log = application.getLog("sqlq");
        application.getConfigurator().addConfigurable(this);
        application.addAsynchronous(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.maxSize = props.getIntegerProperty("SqlQueue.MaxSize", this.maxSize);
        this.eventInterval = props.getIntegerProperty("SqlQueue.EventInterval", this.eventInterval);
        this.log.log("SqlQueue:: Initialized. [maxSize=" + this.maxSize + ", eventInterval=" + this.eventInterval + "min]");
    }

    @Override
    public void begin() {
        if (this.eventInterval > 0) {
            this.application.getScheduler().scheduleEvent(new SqlQueueEvent(this, this.eventInterval));
        }
    }

    @Override
    public void end() {
        this.flush();
    }

    public synchronized void flush() {
        if (this.queue.isEmpty()) {
            return;
        }
        new SqlRunner(this.application, this.connectorFactory, this.queue).start();
        this.queue = new ArrayList<String>();
    }

    public synchronized void add(String sqlCommand) {
        if (sqlCommand == null) {
            return;
        }
        this.log.log("SqlQueue:: Adding command (" + (this.queue.size() + 1) + "/" + this.maxSize + "): " + sqlCommand);
        this.queue.add(sqlCommand);
        if (this.queue.size() >= this.maxSize) {
            this.flush();
        }
    }
}

