/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.data;

import com.techempower.data.ConnectorFactory;
import com.techempower.data.DatabaseConnector;
import com.techempower.gemini.GeminiApplication;
import com.techempower.log.ComponentLog;
import java.util.Collection;

public class SqlRunner
extends Thread {
    private final Collection<String> sqlCommands;
    private final ConnectorFactory connectorFactory;
    private final ComponentLog log;

    public SqlRunner(GeminiApplication application, Collection<String> sqlCommands) {
        this(application, application.getConnectorFactory(), sqlCommands);
    }

    public SqlRunner(GeminiApplication application, ConnectorFactory connectorFactory, Collection<String> sqlCommands) {
        this.connectorFactory = connectorFactory;
        this.sqlCommands = sqlCommands;
        this.log = application.getLog("sqlr");
    }

    @Override
    public void run() {
        if (this.sqlCommands == null || this.sqlCommands.isEmpty()) {
            return;
        }
        this.log.log("SqlRunner:: Executing batch. [size=" + this.sqlCommands.size() + "]");
        DatabaseConnector connector = null;
        try {
            connector = this.connectorFactory.getConnector();
            connector.executeBatch(this.sqlCommands);
        }
        catch (Exception e) {
            this.log.log("SqlRunner:: Exception caught: ", e);
        }
    }
}

