/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.email;

import com.techempower.gemini.email.EmailAuthenticator;
import com.techempower.helper.StringHelper;
import com.techempower.util.EnhancedProperties;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;

public class EmailServerDescriptor {
    public static final String ROLE_OUTBOUND = "Outbound";
    public static final String ROLE_INBOUND = "Inbound";
    public static final String ROLE_BOTH = "Both";
    private final String serverAddress;
    private final int smtpPort;
    private final int popPort;
    private final int timeoutProtoInit;
    private final int timeoutSocket;
    private final Properties serverProps;
    private final Authenticator authenticator;
    private final boolean outbound;
    private final boolean inbound;

    protected EmailServerDescriptor(EnhancedProperties.Focus props) {
        this.serverAddress = props.getProperty("ServerAddress", "mail");
        String role = props.getProperty("ServerRole", ROLE_OUTBOUND);
        if (ROLE_INBOUND.equalsIgnoreCase(role)) {
            this.outbound = false;
            this.inbound = true;
        } else if (ROLE_BOTH.equalsIgnoreCase(role)) {
            this.outbound = true;
            this.inbound = true;
        } else {
            this.outbound = true;
            this.inbound = false;
        }
        int newSmtpPort = props.getIntegerProperty("ServerPort", 25);
        this.smtpPort = props.getIntegerProperty("SmtpPort", newSmtpPort);
        this.popPort = props.getIntegerProperty("PopPort", 110);
        this.timeoutProtoInit = props.getIntegerProperty("MailProtocolInitTimeout", 100);
        this.timeoutSocket = props.getIntegerProperty("MailSocketIOTimeout", 100);
        String username = props.getProperty("SmtpUsername", "");
        String password = props.getProperty("SmtpPassword", "");
        username = props.getProperty("Username", username);
        password = props.getProperty("Password", password);
        String recipientSource = props.getProperty("RecipientSource", "");
        this.authenticator = StringHelper.isNonEmpty(username) ? new EmailAuthenticator(username, password) : null;
        this.serverProps = new Properties();
        if (this.isOutbound()) {
            this.serverProps.put("mail.smtp.host", this.serverAddress);
            this.serverProps.put("mail.smtp.port", "" + this.smtpPort);
            this.serverProps.put("mail.smtp.connectiontimeout", "" + 1000L * (long)this.timeoutProtoInit);
            this.serverProps.put("mail.smtp.timeout", "" + 1000L * (long)this.timeoutSocket);
            if (this.authenticator != null) {
                this.serverProps.put("mail.smtp.auth", "true");
            }
            this.serverProps.put("mail.smtp.recipientsource", recipientSource);
        }
        if (this.isInbound()) {
            this.serverProps.put("mail.pop3.host", this.serverAddress);
            this.serverProps.put("mail.pop3.port", "" + this.popPort);
            this.serverProps.put("mail.pop3.connectiontimeout", "" + 1000L * (long)this.timeoutProtoInit);
            this.serverProps.put("mail.pop3.timeout", "" + 1000L * (long)this.timeoutSocket);
        }
    }

    protected Session getSession() {
        return Session.getInstance((Properties)this.getProperties(), (Authenticator)this.authenticator);
    }

    protected Properties getProperties() {
        return this.serverProps;
    }

    public boolean isOutbound() {
        return this.outbound;
    }

    public boolean isInbound() {
        return this.inbound;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String toString() {
        return "MailServer [" + this.serverAddress + (this.isInbound() ? "; Inbound (port " + this.popPort + ")" : "") + (this.isOutbound() ? "; Outbound (port " + this.smtpPort + ")" : "") + "]";
    }
}

