/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.email.inbound;

import com.techempower.gemini.email.EmailAttachment;
import com.techempower.gemini.email.EmailHandler;
import com.techempower.gemini.email.EmailPackage;
import com.techempower.log.ComponentLog;

public class DisplayEmailHandler
implements EmailHandler {
    private final ComponentLog log;

    public DisplayEmailHandler(ComponentLog log) {
        this.log = log;
    }

    @Override
    public boolean handleEmail(EmailPackage email) {
        this.log.log("From: " + email.getAuthor());
        this.log.log("To  : " + email.getRecipient());
        this.log.log("Subj: " + email.getSubject());
        if (email.getAttachments() != null) {
            for (EmailAttachment attach : email.getAttachments()) {
                this.log.log("Attc: " + attach.getName());
            }
        }
        this.log.log("Body: " + email.getTextBody());
        this.log.log("Html: " + email.getHtmlBody());
        return false;
    }

    public String toString() {
        return "DisplayEmailHandler - displays inbound emails to the debug log";
    }
}

