/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.email.inbound;

import com.techempower.asynchronous.Asynchronous;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.email.EmailHandler;
import com.techempower.gemini.email.EmailPackage;
import com.techempower.gemini.email.EmailServerDescriptor;
import com.techempower.gemini.email.inbound.EmailDispatcherThread;
import com.techempower.log.ComponentLog;
import com.techempower.thread.EndableThread;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.ArrayList;
import java.util.List;

public class EmailDispatcher
implements Asynchronous,
Configurable,
EmailHandler {
    public static final String COMPONENT_CODE = "edsp";
    public static final String DEFAULT_PROPERTY_PREFIX = "InboundMail.";
    public static final String PROPERTY_MAXIMUM_SLEEP = "MaximumSleepMs";
    public static final String PROPERTY_MINIMUM_SLEEP = "MinimumSleepMs";
    public static final int DEFAULT_MAXIMUM_SLEEP = 30000;
    public static final int DEFAULT_MINIMUM_SLEEP = 15000;
    private final GeminiApplication application;
    private final ComponentLog log;
    private final String propertyPrefix;
    private final List<EmailHandler> handlers;
    private final EmailDispatcherThread thread;
    private int totalProcessed = 0;
    private int maximumSleep = 30000;
    private int minimumSleep = 15000;

    public EmailDispatcher(GeminiApplication application, String propertyPrefix) {
        this.application = application;
        this.log = application.getLog(COMPONENT_CODE);
        this.propertyPrefix = propertyPrefix;
        this.handlers = new ArrayList<EmailHandler>(8);
        this.thread = new EmailDispatcherThread(this);
        application.addAsynchronous(this);
        application.getConfigurator().addConfigurable(this);
    }

    public EmailDispatcher(GeminiApplication application) {
        this(application, DEFAULT_PROPERTY_PREFIX);
    }

    @Override
    public void configure(EnhancedProperties props) {
        EnhancedProperties.Focus focus = props.focus(this.propertyPrefix);
        this.maximumSleep = focus.getIntegerProperty(PROPERTY_MAXIMUM_SLEEP, 30000);
        this.minimumSleep = focus.getIntegerProperty(PROPERTY_MINIMUM_SLEEP, 15000);
        this.log.log("EmailDispatcher configured.");
    }

    protected EmailServerDescriptor[] getInboundMailServers() {
        return this.application.getEmailTransport().getInboundServers();
    }

    public synchronized int checkForMail(EndableThread executionThread) {
        EmailServerDescriptor[] servers = this.getInboundMailServers();
        int processed = 0;
        int i = 0;
        while (i < servers.length) {
            EmailServerDescriptor server = servers[i];
            if (executionThread == null || executionThread.checkPause()) {
                processed += this.checkForMail(server);
            }
            ++i;
        }
        return processed;
    }

    public int checkForMail(EmailServerDescriptor server) {
        int processed = this.application.getEmailTransport().checkForMail(server, this);
        this.totalProcessed += processed;
        return processed;
    }

    @Override
    public boolean handleEmail(EmailPackage email) {
        boolean toReturn = false;
        if (this.handlers != null) {
            for (EmailHandler handler : this.handlers) {
                toReturn |= handler.handleEmail(email);
            }
        }
        return toReturn;
    }

    public void addHandler(EmailHandler handler) {
        this.handlers.add(handler);
    }

    public void removeHandler(EmailHandler handler) {
        if (this.handlers != null) {
            this.handlers.remove(handler);
        }
    }

    public List<EmailHandler> getHandlers() {
        return this.handlers;
    }

    public int getTotalProcessed() {
        return this.totalProcessed;
    }

    public ComponentLog getLog() {
        return this.log;
    }

    public EmailDispatcherThread getThread() {
        return this.thread;
    }

    protected int getMaximumSleep() {
        return this.maximumSleep;
    }

    protected int getMinimumSleep() {
        return this.minimumSleep;
    }

    public void pause() {
        if (this.thread != null) {
            this.thread.setEmailPause(true);
        }
    }

    public void resume() {
        if (this.thread != null) {
            this.thread.setEmailPause(false);
        }
    }

    public boolean isPaused() {
        if (this.thread != null) {
            return this.thread.isEmailPaused();
        }
        return false;
    }

    public void requestImmediateCheck() {
        if (this.thread != null) {
            this.thread.requestImmediateCheck();
        }
    }

    @Override
    public void begin() {
        this.log.log("EmailDispatcher starting.");
        this.thread.setName("Email Dispatcher Thread (" + this.application.getVersion().getAbbreviatedProductName() + ")");
        this.thread.start();
    }

    @Override
    public void end() {
        this.log.log("EmailDispatcher ending.");
        this.thread.setKeepRunning(false);
    }
}

