/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.email.inbound;

import com.techempower.gemini.email.inbound.EmailDispatcher;
import com.techempower.helper.StringHelper;
import com.techempower.thread.EndableThread;

public class EmailDispatcherThread
extends EndableThread {
    private final EmailDispatcher dispatcher;
    private boolean pause = false;
    private boolean onDemandCheck = false;

    public EmailDispatcherThread(EmailDispatcher dispatcher) {
        super("Email Dispatcher Thread", dispatcher.getMaximumSleep(), dispatcher.getMaximumSleep(), dispatcher.getMaximumSleep(), 1000);
        this.dispatcher = dispatcher;
    }

    @Override
    public void run() {
        this.setStartTime();
        this.simpleSleep(5000);
        try {
            while (this.checkPause()) {
                block10: {
                    if (!this.isEmailPaused()) {
                        try {
                            int processed;
                            if (this.onDemandCheck) {
                                this.dispatcher.getLog().log("Processing on-demand email check.");
                                this.onDemandCheck = false;
                            }
                            if ((processed = this.dispatcher.checkForMail(this)) > 0) {
                                this.dispatcher.getLog().log(String.valueOf(processed) + " inbound email" + StringHelper.pluralize(processed) + " processed.");
                                this.setMinimumSleep();
                                break block10;
                            }
                            this.incrementSleep();
                        }
                        catch (Exception exc) {
                            this.dispatcher.getLog().log("Exception while checking inbound email: " + exc);
                        }
                    } else {
                        this.incrementSleep();
                    }
                }
                this.simpleSleep();
            }
        }
        finally {
            this.dispatcher.getLog().log("EmailDispatcherThread ending.");
        }
    }

    public void requestImmediateCheck() {
        this.onDemandCheck = true;
        if (this.isAsleep()) {
            this.interrupt();
        }
    }

    public boolean isEmailPaused() {
        return this.pause;
    }

    public void setEmailPause(boolean pause) {
        this.pause = pause;
        this.interrupt();
    }
}

