/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.email.outbound;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.email.EmailPackage;
import com.techempower.gemini.email.outbound.EmailTemplater;
import com.techempower.util.EnhancedProperties;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;

public class MustacheEmailTemplater
extends EmailTemplater {
    public static final String PROPS_PREFIX = "Mustache.Email.";
    private MustacheFactory mustacheFactory;
    private String templatePath;
    private String plainSuffix = ".txt";
    private String htmlSuffix = ".html";
    private String subjectSuffix = ".subject";

    public MustacheEmailTemplater(GeminiApplication application) {
        super(application);
    }

    @Override
    public void configure(EnhancedProperties props) {
        super.configure(props);
        String aTemplatePath = String.valueOf(props.getProperty("Servlet.WebInf")) + "/emails/";
        this.templatePath = props.getProperty("Mustache.Email.TemplatePath", aTemplatePath);
        this.mustacheFactory = new DefaultMustacheFactory(new File(this.templatePath));
        this.plainSuffix = props.getProperty("Mustache.Email.PlaintextSuffix", this.plainSuffix);
        this.htmlSuffix = props.getProperty("Mustache.Email.HtmlSuffix", this.htmlSuffix);
        this.subjectSuffix = props.getProperty("Mustache.Email.SubjectSuffix", this.subjectSuffix);
    }

    protected String renderTemplateFile(String templateFilename, Map<String, Object> data, String defaultValue) {
        if (!Files.exists(Paths.get(this.templatePath, templateFilename), new LinkOption[0])) {
            return defaultValue;
        }
        StringWriter writer = new StringWriter();
        Mustache mustache = this.getMustacheFactory().compile(templateFilename);
        mustache.execute((Writer)writer, data);
        return ((Object)writer).toString();
    }

    protected String renderTemplateString(String templateString, Map<String, Object> data) {
        StringWriter writer = new StringWriter();
        StringReader reader = new StringReader(templateString);
        Mustache mustache = this.getMustacheFactory().compile((Reader)reader, "");
        mustache.execute((Writer)writer, data);
        return ((Object)writer).toString();
    }

    protected MustacheFactory getMustacheFactory() {
        return this.getApplication().getVersion().isDevelopment() ? new DefaultMustacheFactory(new File(this.templatePath)) : this.mustacheFactory;
    }

    protected String getPlainSuffix() {
        return this.plainSuffix;
    }

    protected String getHtmlSuffix() {
        return this.htmlSuffix;
    }

    protected String getSubjectSuffix() {
        return this.subjectSuffix;
    }

    @Override
    public void addTemplateToLoad(String templateID) {
    }

    @Override
    public EmailPackage process(String templateID, Map<String, Object> data, String authorAddress, String recipientAddress) {
        String plainBody = this.renderTemplateFile(String.valueOf(templateID) + this.getPlainSuffix(), data, null);
        String htmlBody = this.renderTemplateFile(String.valueOf(templateID) + this.getHtmlSuffix(), data, null);
        String subject = this.renderTemplateFile(String.valueOf(templateID) + this.getSubjectSuffix(), data, "No subject");
        if (htmlBody != null) {
            return new EmailPackage(subject, plainBody, htmlBody, recipientAddress, authorAddress);
        }
        return new EmailPackage(subject, plainBody, recipientAddress, authorAddress);
    }

    @Override
    public EmailPackage process(String plainBody, String htmlBody, String subject, Map<String, Object> data, String authorAddress, String recipientAddress) {
        String processedPlainBody = this.renderTemplateString(plainBody, data);
        String processedSubject = this.renderTemplateString(subject, data);
        if (htmlBody != null) {
            String processedHtmlBody = this.renderTemplateString(htmlBody, data);
            return new EmailPackage(processedSubject, processedPlainBody, processedHtmlBody, recipientAddress, authorAddress);
        }
        return new EmailPackage(processedSubject, processedPlainBody, recipientAddress, authorAddress);
    }

    @Override
    public EmailPackage process(String body, String subject, Map<String, Object> data, String authorAddress, String recipientAddress) {
        return this.process(body, null, subject, data, authorAddress, recipientAddress);
    }
}

