/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.event;

import com.techempower.data.DatabaseConnector;
import com.techempower.gemini.GeminiApplication;
import com.techempower.helper.DateHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.scheduler.ScheduledEvent;
import com.techempower.scheduler.Scheduler;
import com.techempower.text.SynchronizedSimpleDateFormat;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;

public class MySqlBackupEvent
extends ScheduledEvent
implements Configurable {
    public static final String LOCAL_COMPONENT_CODE = "eMyS";
    public static final String CONFIGURATION_PREFIX = "MySqlBackupEvent";
    public static final int DEFAULT_MAXIMUM_BACKUPS = 10;
    private final GeminiApplication app;
    private final ComponentLog log;
    private long intervalMillis = 3600000L;
    private String backupPath = "c:\\backups\\mysql\\";
    private String filenamePrefix = "mysqlbackup-";
    private String filenameDateformat = "yyyy-MM-dd-HH-mm-ss-SSS";
    private String filenameSuffix = ".bak";
    private String backupStatement = "BACKUP DATABASE * TO '$BFN';";
    private int maximumBackups = 10;
    private SynchronizedSimpleDateFormat dateFormat;
    private Scheduler scheduler;
    private static final ModificationDateFileComparator MODIFICATION_DATE_FILE_COMPARATOR = new ModificationDateFileComparator();

    public MySqlBackupEvent(GeminiApplication application) {
        this.app = application;
        this.log = this.app.getLog(LOCAL_COMPONENT_CODE);
        this.dateFormat = new SynchronizedSimpleDateFormat(this.filenameDateformat);
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.setBackupPath(props.getProperty("MySqlBackupEvent.Backuppath", this.getBackupPath()));
        this.setFilenamePrefix(props.getProperty("MySqlBackupEvent.FilenamePrefix", this.getFilenamePrefix()));
        this.setFilenameSuffix(props.getProperty("MySqlBackupEvent.FilenameSuffx", this.getFilenameSuffix()));
        this.setFilenameDateFormat(props.getProperty("MySqlBackupEvent.FilenameDateFormat", this.getFilenameDateFormat()));
        this.dateFormat = new SynchronizedSimpleDateFormat(this.filenameDateformat);
        this.setBackupStatement(props.getProperty("MySqlBackupEvent.BackupStatement", this.getBackupStatement()));
        this.setMaximumBackups(props.getIntegerProperty("MySqlBackupEvent.MaximumBackups", this.getMaximumBackups()));
        long newInterval = props.getLongProperty("MySqlBackupEvent.IntervalMillis", this.getIntervalMillis());
        if (newInterval != this.getIntervalMillis()) {
            this.setIntervalMillis(newInterval);
            this.scheduler = this.app.getScheduler();
            this.scheduler.removeEvent(this);
            this.scheduleSelf(this.scheduler);
        }
    }

    @Override
    public long getDefaultScheduledTime() {
        Calendar schedule = DateHelper.getCalendarInstance();
        schedule.add(13, (int)(this.intervalMillis / 1000L));
        return schedule.getTimeInMillis();
    }

    public void scheduleSelf(Scheduler applicationScheduler) {
        Calendar schedule = DateHelper.getCalendarInstance();
        schedule.add(13, (int)(this.intervalMillis / 1000L));
        applicationScheduler.scheduleEvent((ScheduledEvent)this, schedule.getTimeInMillis());
    }

    @Override
    public boolean requiresOwnThread() {
        return true;
    }

    @Override
    public void execute(Scheduler applicationScheduler) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DatabaseConnector dbconn = this.app.getConnectorFactory().getConnector();){
                String backupFilename = String.valueOf(this.getFilenamePrefix()) + this.dateFormat.format(new Date()) + this.getFilenameSuffix();
                HashMap<String, String> macros = new HashMap<String, String>(1);
                macros.put("$BFN", backupFilename);
                dbconn.setQuery(StringHelper.macroExpand(macros, this.getBackupStatement()));
                this.log.log("Executing backup of MySQL to " + backupFilename);
                dbconn.runQuery();
                this.log.log("Backup of MySQL to " + backupFilename + " complete.");
                this.cleanOldFiles();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exc) {
            this.log.log("Exception during database backup: " + exc);
        }
        this.log.log(this + " complete.");
        this.scheduleSelf(applicationScheduler);
    }

    public void cleanOldFiles() {
        if (this.getMaximumBackups() > 0) {
            try {
                File directory = new File(this.getBackupPath());
                File[] files = directory.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(MySqlBackupEvent.this.getFilenamePrefix());
                    }
                });
                if (files.length > this.getMaximumBackups()) {
                    Arrays.sort(files, MODIFICATION_DATE_FILE_COMPARATOR);
                    int i = 0;
                    while (i < files.length - this.getMaximumBackups()) {
                        this.log.log("Removing old backup file: " + files[i]);
                        if (!files[i].delete()) {
                            this.log.log("Could not delete " + files[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception exc) {
                this.log.log("Exception while cleaning up old backup files: " + exc);
            }
        }
    }

    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    public void setIntervalMillis(long intervalMillis) {
        long interval;
        this.intervalMillis = interval = NumberHelper.boundLong(intervalMillis, 60000L, Long.MAX_VALUE);
    }

    public String getFilenamePrefix() {
        return this.filenamePrefix;
    }

    public void setFilenamePrefix(String filenamePrefix) {
        this.filenamePrefix = filenamePrefix;
    }

    public String getFilenameDateFormat() {
        return this.filenameDateformat;
    }

    public void setFilenameDateFormat(String filenameDateFormat) {
        this.filenameDateformat = filenameDateFormat;
        this.dateFormat = new SynchronizedSimpleDateFormat(filenameDateFormat);
    }

    public String getFilenameSuffix() {
        return this.filenameSuffix;
    }

    public void setFilenameSuffix(String filenameSuffix) {
        this.filenameSuffix = filenameSuffix;
    }

    public String getBackupStatement() {
        return this.backupStatement;
    }

    public void setBackupStatement(String backupStatement) {
        this.backupStatement = backupStatement;
    }

    public String getBackupPath() {
        return this.backupPath;
    }

    public void setBackupPath(String backupPath) {
        this.backupPath = backupPath;
    }

    public int getMaximumBackups() {
        return this.maximumBackups;
    }

    public void setMaximumBackups(int maximumBackups) {
        this.maximumBackups = maximumBackups;
    }

    static class ModificationDateFileComparator
    implements Comparator<File> {
        ModificationDateFileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            if (o1.lastModified() < o2.lastModified()) {
                return -1;
            }
            return 1;
        }
    }
}

