/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.exceptionhandler;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.email.EmailPackage;
import com.techempower.gemini.email.outbound.EmailServicer;
import com.techempower.gemini.exceptionhandler.ExceptionHandler;
import com.techempower.gemini.exceptionhandler.ExceptionHandlerHelper;
import com.techempower.gemini.feature.Feature;
import com.techempower.gemini.feature.FeatureManager;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.concurrent.atomic.AtomicInteger;

public class EmailExceptionHandler
implements ExceptionHandler,
Feature,
Configurable {
    public static final String COMPONENT_CODE = "emEH";
    public static final String CRLF = "\r\n";
    private final GeminiApplication application;
    private final FeatureManager fm;
    private final ComponentLog log;
    private String fromMailAddress;
    private String toMailAddress;
    private long minimumInterval;
    private AtomicInteger skipped;
    private long nextDelivery;
    private EmailServicer emailServicer;

    public EmailExceptionHandler(GeminiApplication app) {
        this.toMailAddress = this.fromMailAddress = "exceptions@techempower.com";
        this.minimumInterval = 600000L;
        this.skipped = new AtomicInteger(0);
        this.nextDelivery = 0L;
        this.application = app;
        this.log = this.application.getLog(COMPONENT_CODE);
        app.getConfigurator().addConfigurable(this);
        this.fm = this.application.getFeatureManager();
        this.fm.add("exc-email", "Email Exception Handler");
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.toMailAddress = props.getProperty("EmailExceptionHandler.ToEmailAddress", this.toMailAddress);
        this.fromMailAddress = props.getProperty("EmailExceptionHandler.FromEmailAddress", this.toMailAddress);
        this.minimumInterval = (long)props.getIntegerProperty("EmailExceptionHandler.MinimumInterval", 600) * 1000L;
        if (props.getProperty("EmailExceptionHandler.Enabled") != null) {
            this.log.log("EmailExceptionHandler.Enabled is deprecated.  Use Feature.exc-email instead.");
            this.fm.set("exc-email", props.getYesNoProperty("EmailExceptionHandler.Enabled", true));
        }
        this.emailServicer = this.application.getEmailServicer();
        if (!this.isEnabled() || StringHelper.isEmpty(this.fromMailAddress) || StringHelper.isEmpty(this.toMailAddress)) {
            this.log.log("EmailExceptionHandler disabled.");
        }
    }

    public boolean isEnabled() {
        return this.fm.on("exc-email");
    }

    @Override
    public void handleException(Context context, Throwable exc) {
        this.handleException(context, exc, null);
    }

    @Override
    public void handleException(Context context, Throwable exception, String description) {
        if (this.isEnabled() && StringHelper.isNonEmpty(this.fromMailAddress) && StringHelper.isNonEmpty(this.toMailAddress)) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.nextDelivery) {
                this.skipped.incrementAndGet();
            } else {
                String message = ExceptionHandlerHelper.renderExceptionAsReport(context, this.application, exception, description, this.skipped.get());
                this.skipped.set(0);
                this.log.log("Sending exception report to " + this.toMailAddress);
                EmailPackage email = new EmailPackage("<auto> Exception Report - " + this.application.getVersion().getNameAndDeployment(), message, this.toMailAddress, this.fromMailAddress);
                this.emailServicer.sendMail(email);
                this.nextDelivery = currentTime + this.minimumInterval;
            }
        }
    }
}

