/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.exceptionhandler;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.notification.BasicNotification;
import com.techempower.gemini.exceptionhandler.ExceptionHandler;
import com.techempower.gemini.exceptionhandler.ExceptionHandlerHelper;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.concurrent.atomic.AtomicInteger;

public class NotificationExceptionHandler
implements ExceptionHandler,
Configurable {
    public static final String SOURCE = "Exception";
    private final GeminiApplication application;
    private final AtomicInteger skipped = new AtomicInteger(0);
    private long minimumInterval = 120000L;
    private long nextDelivery = 0L;

    public NotificationExceptionHandler(GeminiApplication application) {
        this.application = application;
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void handleException(Context context, Throwable exc) {
        this.handleException(context, exc, null);
    }

    @Override
    public void handleException(Context context, Throwable exc, String description) {
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.nextDelivery) {
            this.skipped.incrementAndGet();
        } else {
            int skip = this.skipped.get();
            this.skipped.set(0);
            String synopsis = String.valueOf(exc.getClass().getName()) + (skip > 0 ? " (" + skip + " skipped)" : "");
            String details = ExceptionHandlerHelper.renderExceptionAsReport(context, null, exc, description, skip);
            BasicNotification n = new BasicNotification(SOURCE, synopsis, details);
            this.application.getNotifier().addNotification(n);
            this.nextDelivery = currentTime + this.minimumInterval;
        }
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.minimumInterval = (long)props.getIntegerProperty("NotificationExceptionHandler.MinimumInterval", 120) * 1000L;
    }
}

