/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.filestore;

import com.google.common.io.Files;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.RequestFile;
import com.techempower.gemini.filestore.StoredFile;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.helper.FileHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import com.techempower.util.Identifiable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileStore
implements Configurable {
    public static final String COMPONENT_CODE = "FSto";
    public static final int DIRECTORY_CHUNK_SIZE = 1000;
    public static final int DIRECTORY_CHUNK_DIGITS = 3;
    public static final String DEFAULT_CONFIGURATION_PREFIX = "FileStore.";
    public static final int DEFAULT_FILENAME_LENGTH_MAX = 250;
    public static final int MAXIMUM_FILES_PER_UPLOAD = 10;
    private final ComponentLog log;
    private final Map<Class<?>, String> typesToCodes;
    private String filesystemRoot;
    private String urlRoot;
    private String configurationPrefix;
    private boolean enabled = true;
    private int filenameLengthMaximum = 250;
    private String imageMagickExecutable = "";
    private String imageMagickResizeArgument = "-resize";
    private static final ProcessManagementOptions MANAGEMENT_PERMISSIONS_ALL = new ProcessManagementOptions(true, true, true);
    private static final OnlyFilesFilter ONLY_FILES_FILTER = new OnlyFilesFilter();

    public FileStore(GeminiApplication application) {
        this(application, DEFAULT_CONFIGURATION_PREFIX);
    }

    public FileStore(GeminiApplication application, String configurationPrefix) {
        this.log = application.getLog(COMPONENT_CODE);
        this.configurationPrefix = configurationPrefix;
        this.typesToCodes = new HashMap();
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.setEnabled(false);
        this.filesystemRoot = props.getProperty(String.valueOf(this.configurationPrefix) + "FilesystemRoot", "c:\\temp\\");
        this.urlRoot = props.getProperty(String.valueOf(this.configurationPrefix) + "URLRoot", "/");
        this.filenameLengthMaximum = props.getIntegerProperty(String.valueOf(this.configurationPrefix) + "FilenameLengthMaximum", 250);
        this.imageMagickExecutable = props.getProperty(String.valueOf(this.configurationPrefix) + "ImageMagickExecutable", this.imageMagickExecutable);
        this.imageMagickResizeArgument = props.getProperty(String.valueOf(this.configurationPrefix) + "ImageMagickResizeArgument", this.imageMagickResizeArgument);
        if (StringHelper.isNonEmpty(this.filesystemRoot)) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
            this.log.log("No file system root specified in configuration file!", 70);
        }
    }

    public void registerType(Identifiable identifiableType, char code) {
        this.typesToCodes.put(identifiableType.getClass(), "" + code);
    }

    public String getTypeCode(Identifiable identifiableType) {
        return this.typesToCodes.get(identifiableType.getClass());
    }

    public String getRelativePath(String directoryPrefix, int itemIdentity) {
        int relativeNumber = itemIdentity % 1000;
        int chunkNumber = itemIdentity / 1000;
        return String.valueOf(directoryPrefix) + chunkNumber + "/" + StringHelper.padZero(relativeNumber, 3) + "/";
    }

    public String getRelativePath(Identifiable ident) {
        return this.getRelativePath(this.getTypeCode(ident), ident.getId());
    }

    public String getPath(Identifiable ident) {
        return String.valueOf(this.filesystemRoot) + this.getRelativePath(ident);
    }

    public String getUrl(Identifiable ident) {
        return String.valueOf(this.urlRoot) + this.getRelativePath(ident);
    }

    public String getPathname(Identifiable ident, String filename) {
        return String.valueOf(this.getPath(ident)) + this.normalizeFilename(filename);
    }

    public long getTotalBytes(Identifiable ident) {
        return this.getTotalBytes(this.getPath(ident));
    }

    public StoredFile[] getFileList(Identifiable ident) {
        File[] files = this.getRawFileList(this.getPath(ident));
        return this.getFileList(files, this.getUrl(ident));
    }

    public StoredFile getStoredFile(Identifiable ident, String filename) {
        File file = new File(this.getPathname(ident, filename));
        return this.getStoredFile(file, this.getUrl(ident));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean convertImageFile(Identifiable source, String sourceFilename, Identifiable dest, String destFilename, int newWidth, int newHeight) {
        if (StringHelper.isNonEmpty(this.imageMagickExecutable)) {
            this.prepDirectory(dest);
            String sourceName = this.getPathname(source, sourceFilename);
            String destName = this.getPathname(dest, destFilename);
            ArrayList<String> args = new ArrayList<String>(5);
            args.add(this.imageMagickExecutable);
            args.add(sourceName);
            if (newWidth > 0 && newHeight > 0) {
                args.add(this.imageMagickResizeArgument);
                args.add(String.valueOf(newWidth) + "x" + newHeight);
            }
            args.add(destName);
            this.log.log("Executing imagemagick convert.");
            ProcessBuilder pb = new ProcessBuilder(args);
            try {
                Process proc = pb.start();
                proc.waitFor();
                int exitValue = proc.exitValue();
                this.log.log("Exit value from imagemagick: " + exitValue);
                if (exitValue != 0) return false;
                return true;
            }
            catch (IOException ioexc) {
                this.log.log("IOException while executing imagemagick: " + ioexc);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        } else {
            this.log.log("Cannot convert image!  ImageMagick executable is not specified in configuration file.");
        }
        return false;
    }

    public boolean renameFile(Identifiable ident, String currentFilename, String newFilename) {
        String currentName = this.getPathname(ident, currentFilename);
        String newName = this.getPathname(ident, newFilename);
        File currentFile = new File(currentName);
        File newFile = new File(newName);
        if (!newFile.exists()) {
            return currentFile.renameTo(newFile);
        }
        this.log.log("New filename is already in use: " + newFilename);
        return false;
    }

    public boolean moveFile(Identifiable source, Identifiable dest, String filename) {
        String inputFile = this.getPathname(source, filename);
        String outputDirectory = this.getPath(dest);
        return this.moveFile(inputFile, outputDirectory);
    }

    public boolean moveFile(String sourceFilename, Identifiable ident) {
        String outputDirectory = this.getPath(ident);
        return this.moveFile(sourceFilename, outputDirectory);
    }

    public boolean storeFile(InputStream fileInputStream, Identifiable dest, String filename) {
        String destinationFilename = this.getPathname(dest, filename);
        this.prepDirectory(dest);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream outputStream = new FileOutputStream(destinationFilename);){
                FileHelper.copyStreamContents(fileInputStream, outputStream, 0L);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioexc) {
            this.log.log("IOException while storing file " + filename + ": " + ioexc);
            return false;
        }
        return true;
    }

    public boolean storeFile(File sourceFile, Identifiable dest) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream inputStream = new FileInputStream(sourceFile);){
                return this.storeFile(inputStream, dest, sourceFile.getName());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioexc) {
            this.log.log("IOException while storing file " + sourceFile + ": " + ioexc);
            return false;
        }
    }

    public boolean exists(Identifiable ident, String filename) {
        String filepath = this.getPathname(ident, filename);
        File file = new File(filepath);
        return file.exists();
    }

    public boolean deleteFile(Identifiable ident, String filename) {
        return this.deleteFile(this.getPathname(ident, filename));
    }

    public List<String> deleteAllFiles(Identifiable ident) {
        return this.deleteAllFiles(this.getPath(ident));
    }

    public boolean prepDirectory(Identifiable ident) {
        return this.makeDirectories(this.getPath(ident));
    }

    public ManagementOutcome processManagement(PyxisUser user, Context context) {
        return this.processManagement(user, user, context);
    }

    public ManagementOutcome processManagement(PyxisUser user, Identifiable forObject, Context context) {
        return this.processManagement(user, forObject, context, MANAGEMENT_PERMISSIONS_ALL);
    }

    public ManagementOutcome processManagement(PyxisUser user, Identifiable forObject, Context context, ProcessManagementOptions options) {
        ManagementOutcome outcome = new ManagementOutcome();
        outcome.success = true;
        this.prepDirectory(forObject);
        if (outcome.success && options.allowUpload) {
            int i = 0;
            while (i <= 10) {
                RequestFile file = context.files().get("file" + (i == 0 ? "" : "" + i));
                if (file != null) {
                    String filename = file.getFilename();
                    try {
                        file.writeTo(Paths.get(this.getPathname(forObject, filename), new String[0]));
                        outcome.success = true;
                    }
                    catch (IOException e) {
                        outcome.success = false;
                    }
                    outcome.addUploadedFile(filename);
                    this.log.log(user + " uploaded " + filename);
                }
                ++i;
            }
        }
        if (options.allowDelete) {
            String[] deletions = context.query().getStrings("delete");
            if (deletions != null) {
                int i = 0;
                while (i < deletions.length) {
                    if (this.deleteFile(forObject, deletions[i])) {
                        outcome.addDeletedFile(deletions[i]);
                        this.log.log(String.valueOf(deletions[i]) + " deleted (multiple)");
                    }
                    ++i;
                }
            } else {
                String delete = context.query().get("delete");
                if (delete != null && this.deleteFile(forObject, delete)) {
                    outcome.addDeletedFile(delete);
                    this.log.log(String.valueOf(delete) + " deleted (single)");
                }
            }
        }
        if (options.allowDeleteAll && context.query().getInt("deleteall") == 1) {
            List<String> deleted = this.deleteAllFiles(forObject);
            for (String filename : deleted) {
                outcome.addDeletedFile(filename);
            }
        }
        return outcome;
    }

    public ComponentLog getLog() {
        return this.log;
    }

    protected boolean moveFile(String sourceFilename, String destDirectoryName) {
        File sourceFile;
        block3: {
            this.makeDirectories(destDirectoryName);
            sourceFile = new File(sourceFilename);
            File destDirectory = new File(destDirectoryName);
            if (!sourceFile.exists() || !destDirectory.exists()) break block3;
            Files.move((File)sourceFile, (File)new File(destDirectory, sourceFile.getName()));
            return true;
        }
        try {
            this.log.log("Move: Source file " + sourceFile + " not found.");
        }
        catch (IOException ioexc) {
            this.log.log("IOException while moving file " + sourceFilename + ".", ioexc);
        }
        return false;
    }

    protected boolean deleteFile(String filename) {
        File file = new File(filename);
        return file.delete();
    }

    protected List<String> deleteAllFiles(String path) {
        File[] files = this.getRawFileList(path);
        ArrayList<String> deleted = new ArrayList<String>(files.length);
        int i = 0;
        while (i < files.length) {
            String name = files[i].getName();
            boolean success = files[i].delete();
            if (success) {
                deleted.add(name);
            }
            ++i;
        }
        return deleted;
    }

    protected boolean makeDirectories(String path) {
        File directory = new File(path);
        if (!directory.exists() || !directory.isDirectory()) {
            return directory.mkdirs();
        }
        return false;
    }

    protected long getTotalBytes(String absolutePath) {
        File[] fileList = this.getRawFileList(absolutePath);
        long total = 0L;
        int i = 0;
        while (i < fileList.length) {
            total += fileList[i].length();
            ++i;
        }
        return total;
    }

    protected StoredFile[] getFileList(File[] files, String urlPrefix) {
        StoredFile[] toReturn = new StoredFile[files.length];
        int i = 0;
        while (i < files.length) {
            toReturn[i] = new StoredFile(files[i].getName(), String.valueOf(urlPrefix) + files[i].getName(), files[i].length());
            ++i;
        }
        return toReturn;
    }

    protected StoredFile getStoredFile(File file, String urlPrefix) {
        if (file.exists()) {
            return new StoredFile(file.getName(), String.valueOf(urlPrefix) + file.getName(), file.length());
        }
        return null;
    }

    protected File[] getRawFileList(String absolutePath) {
        File directory = new File(absolutePath);
        if (directory.exists() && directory.isDirectory()) {
            return directory.listFiles(ONLY_FILES_FILTER);
        }
        return new File[0];
    }

    public String normalizeFilename(String source) {
        return FileHelper.normalizeFilename(StringHelper.truncate(source, this.filenameLengthMaximum));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static class ManagementOutcome {
        public boolean success = true;
        public List<String> deletedFiles = null;
        public List<String> uploadedFiles = null;

        public void addDeletedFile(String deletedFilename) {
            if (this.deletedFiles == null) {
                this.deletedFiles = new ArrayList<String>();
                this.deletedFiles.add(deletedFilename);
            }
        }

        public void addUploadedFile(String uploadedFilename) {
            if (this.uploadedFiles == null) {
                this.uploadedFiles = new ArrayList<String>();
                this.uploadedFiles.add(uploadedFilename);
            }
        }
    }

    private static class OnlyFilesFilter
    implements FileFilter {
        private OnlyFilesFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile();
        }
    }

    public static class ProcessManagementOptions {
        public final boolean allowUpload;
        public final boolean allowDelete;
        public final boolean allowDeleteAll;

        public ProcessManagementOptions(boolean allowUpload, boolean allowDelete, boolean allowDeleteAll) {
            this.allowDelete = allowDelete;
            this.allowDeleteAll = allowDeleteAll;
            this.allowUpload = allowUpload;
        }
    }
}

