/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.filter;

import com.techempower.gemini.ApplicationRegistrar;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.HttpRequest;
import com.techempower.gemini.filter.BasicFilter;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.PyxisUserGroup;
import com.techempower.gemini.pyxis.authorization.Authorizer;
import com.techempower.gemini.pyxis.authorization.Rejector;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccessFilter
extends BasicFilter
implements Configurable {
    public static final String COMPONENT_CODE = "hAcF";
    public static final String HANDLER_PREFIX = "acf-";
    public static final String CMD_PROCEED = "acf-proc";
    public static final String PROPS_PREFIX = "AccessFilter.";
    public static final int ERROR_NO_ACCESS = 1;
    public static final int ERROR_UNKNOWN = 2;
    private GeminiApplication application = null;
    private PyxisSecurity security = null;
    private ComponentLog log = null;
    private String propsPrefix = "AccessFilter.";
    private String applicationName;
    private String userGroupName = "Users";
    private String loginHandlerName = "login";
    private PyxisUserGroup userGroup;

    @Override
    public void init(FilterConfig config) {
        super.init(config);
        this.applicationName = this.getInitParameter(config, "AppName", this.applicationName);
        this.propsPrefix = this.getInitParameter(config, "PropsPrefix", this.propsPrefix);
        this.userGroupName = this.getInitParameter(config, "UserGroup", this.userGroupName);
        this.loginHandlerName = this.getInitParameter(config, "LoginHandlerName", this.loginHandlerName);
        if (StringHelper.isNonEmpty(this.applicationName)) {
            this.findApplication();
        } else {
            this.debug("Cannot initialize; missing 'AppName' parameter.");
        }
    }

    @Override
    public void destroy() {
        this.application = null;
        this.log = null;
    }

    public ComponentLog getLog() {
        return this.log;
    }

    public GeminiApplication getApplication() {
        return this.application;
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (StringHelper.isNonEmpty(this.applicationName)) {
            this.findApplication();
        }
        if (this.application != null) {
            if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
                final HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
                final HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
                HttpRequest request = new HttpRequest(httpRequest, httpResponse, this.getServletContext(), this.getApplication());
                Context context = new Context(request, this.getApplication());
                boolean authorized = this.security.authCheck(context, new Authorizer(){

                    @Override
                    public boolean isAuthorized(PyxisUser user) {
                        return AccessFilter.this.isUserPermitted(user, httpRequest, httpResponse);
                    }
                }, new Rejector(){

                    @Override
                    public void reject(Context requestContext, PyxisUser user) {
                        AccessFilter.this.debug("User requesting content to which they are not authorized.");
                        AccessFilter.this.doError((ServletRequest)httpRequest, (ServletResponse)httpResponse, 1, "");
                    }
                });
                if (authorized) {
                    chain.doFilter(servletRequest, servletResponse);
                }
            } else {
                this.debug("Request not an HttpServletRequest.");
                this.doError(servletRequest, servletResponse, 2, "");
            }
        } else {
            this.doError(servletRequest, servletResponse, 2, "");
        }
    }

    protected boolean isUserPermitted(PyxisUser user, HttpServletRequest request, HttpServletResponse response) {
        return user != null && user.isMember(this.userGroup);
    }

    protected void findApplication() {
        if (this.application == null) {
            this.application = ApplicationRegistrar.lookup(this.applicationName);
            if (this.application != null) {
                this.security = this.application.getSecurity();
                this.log = this.application.getLog(COMPONENT_CODE);
                this.application.getConfigurator().addConfigurable(this);
                EnhancedProperties props = this.application.getConfigurator().getLastProperties();
                this.configure(props);
            } else {
                this.debug("Cannot find application '" + this.applicationName + "'.");
            }
        }
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.userGroupName = props.getProperty(String.valueOf(this.propsPrefix) + "UserGroup", this.userGroupName);
        this.loginHandlerName = props.getProperty(String.valueOf(this.propsPrefix) + "LoginHandlerName", this.loginHandlerName);
        if (StringHelper.isNonEmpty(this.userGroupName)) {
            try {
                Collection<PyxisUserGroup> userGroups = this.security.getAllUserGroups();
                Iterator<PyxisUserGroup> iter = userGroups.iterator();
                boolean found = false;
                while (iter.hasNext()) {
                    PyxisUserGroup groupObj = iter.next();
                    PyxisUserGroup group = groupObj;
                    if (!group.getName().equalsIgnoreCase(this.userGroupName)) continue;
                    found = true;
                    this.userGroup = group;
                }
                if (!found) {
                    this.debug("User group " + this.userGroupName + " not found!");
                }
            }
            catch (Exception exc) {
                this.log.log("Exception while finding user group " + this.userGroupName + ": " + exc);
            }
        }
        if (this.userGroup != null) {
            this.debug("Configured [g: " + this.userGroup.getName() + "; lh: " + this.loginHandlerName + "; ep: " + this.getErrorPage() + "]");
        }
    }

    protected void debug(String text) {
        if (this.log != null) {
            this.log.log(text);
        } else {
            super.debug(text, 2);
        }
    }
}

