/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BasicFilter
implements Filter {
    public static final int DEBUG_LEVEL_ANY = 0;
    public static final int DEBUG_LEVEL_ERROR = 1;
    public static final int DEBUG_LEVEL_FILTER = 2;
    public static final int DEBUG_LEVEL_NOTICE = 3;
    private static final int DEBUG_THRESHOLD_ERROR = 1;
    private static final int DEBUG_THRESHOLD_FILTER = 2;
    private static final int DEBUG_THRESHOLD_NOTICE = 3;
    private static final int DEBUG_THRESHOLD_ALL = 4;
    private ServletContext servletContext;
    private boolean debugEnabled;
    private int debugThreshold;
    private String filterName;
    private String errorPage = "/access-error.jsp";

    public void init(FilterConfig config) {
        this.servletContext = config.getServletContext();
        this.debugEnabled = this.getInitParameter(config, "DebugEnabled", false);
        this.debugThreshold = (int)this.getInitParameter(config, "DebugThreshold", 1L);
        this.errorPage = this.getInitParameter(config, "ErrorPage", this.errorPage);
        this.filterName = config.getFilterName();
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected String getInitParameter(FilterConfig config, String name, String defaultValue) {
        if (config.getInitParameter(name) != null) {
            return config.getInitParameter(name);
        }
        return defaultValue;
    }

    protected long getInitParameter(FilterConfig config, String name, long defaultValue) {
        if (config.getInitParameter(name) != null) {
            try {
                return Long.parseLong(config.getInitParameter(name));
            }
            catch (NumberFormatException nfexc) {
                this.debug("NFE: " + nfexc, 1);
            }
        }
        return defaultValue;
    }

    protected boolean getInitParameter(FilterConfig config, String name, boolean defaultValue) {
        String value = config.getInitParameter(name);
        if (value != null) {
            if ("yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
                return true;
            }
            if ("no".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                return false;
            }
        }
        return defaultValue;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void doError(ServletRequest request, ServletResponse response, int errorType, String errorText) {
        try {
            request.setAttribute("ErrorType", (Object)errorType);
            request.setAttribute("ErrorText", (Object)errorText);
            RequestDispatcher rd = request.getRequestDispatcher(this.errorPage);
            rd.forward(request, response);
        }
        catch (IOException | ServletException throwable) {
            // empty catch block
        }
    }

    protected void debug(String text, int level) {
        if (this.debugEnabled && level <= this.debugThreshold) {
            System.out.println(String.valueOf(this.filterName) + ": " + text);
        }
    }
}

