/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.filter;

import com.techempower.gemini.filter.BasicFilter;
import com.techempower.helper.DateHelper;
import com.techempower.text.SynchronizedSimpleDateFormat;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExpiresFilter
extends BasicFilter {
    public static final String COMPONENT_CODE = "hExF";
    public static final long RENDER_INTERVAL = 15000L;
    private long expirationDelta = 3600000L;
    private int expirationSeconds = (int)(this.expirationDelta / 1000L);
    private long nextRender = 0L;
    private String renderedExpiration = null;
    private SynchronizedSimpleDateFormat dateFormatter = new SynchronizedSimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");

    @Override
    public void init(FilterConfig config) {
        super.init(config);
        this.setExpirationDelta(this.getInitParameter(config, "ExpirationDelta", this.expirationDelta));
        this.dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        long now = System.currentTimeMillis();
        if (now > this.nextRender || this.renderedExpiration == null) {
            this.nextRender = now + 15000L;
            Calendar cal = DateHelper.getCalendarInstance(now + this.expirationDelta);
            this.renderedExpiration = this.dateFormatter.format(cal.getTime());
        }
        response.setHeader("Expires", this.renderedExpiration);
        response.setHeader("Cache-Control", "max-age=" + this.expirationSeconds + ", public");
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void setExpirationDelta(long expirationDelta) {
        this.expirationDelta = expirationDelta;
        this.expirationSeconds = (int)(this.expirationDelta / 1000L);
    }
}

