/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.filter;

import com.techempower.gemini.filter.BasicFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReferralRequiredFilter
extends BasicFilter {
    public static final String COMPONENT_CODE = "hExF";
    private String requiredReferrerValue = "";
    private boolean hashRequired = false;

    @Override
    public void init(FilterConfig config) {
        super.init(config);
        this.requiredReferrerValue = this.getInitParameter(config, "Required", "");
        this.hashRequired = this.getInitParameter(config, "HashRequired", false);
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String referer = request.getHeader("Referer");
        if (referer == null) {
            referer = "";
        }
        this.debug("Referrer: " + referer, 2);
        if (referer.startsWith(this.requiredReferrerValue)) {
            if (!this.hashRequired || this.goodHash(request)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                this.doError((ServletRequest)request, (ServletResponse)response, 2, "Incorrect hash.");
            }
        } else {
            this.doError((ServletRequest)request, (ServletResponse)response, 1, "Incorrect referrer.");
        }
    }

    protected boolean goodHash(HttpServletRequest request) {
        String context = request.getContextPath();
        String uri = request.getRequestURI();
        String filename = uri.substring(context.length());
        String hashValue = Integer.toString(Math.abs(filename.hashCode()), 36).toLowerCase();
        String providedHash = request.getParameter("a");
        this.debug("File: " + filename + "; desired hash: " + hashValue + "; received hash: " + providedHash, 2);
        return hashValue.equals(providedHash);
    }
}

