/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.form.FormCheckBox;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormElementValidator;
import com.techempower.gemini.form.FormFileBrowse;
import com.techempower.gemini.form.FormHiddenElement;
import com.techempower.gemini.form.FormRevertableElement;
import com.techempower.gemini.form.FormSubmissionElement;
import com.techempower.gemini.form.FormValidation;
import com.techempower.gemini.form.FormValidator;
import com.techempower.gemini.form.FormValues;
import com.techempower.gemini.form.ScriptFormElement;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.StringHelper;
import com.techempower.js.JavaScriptWriter;
import com.techempower.log.ComponentLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Form {
    public static final String COMPONENT_CODE = "form";
    public static final String POST = "post";
    public static final String GET = "get";
    public static final String VALIDATION = "validation";
    private final GeminiApplication application;
    private final ComponentLog log;
    private final Map<String, FormElement> formElementsByName = new HashMap<String, FormElement>();
    private final List<FormElement> formElements = new ArrayList<FormElement>();
    private final List<FormSubmissionElement> formSubmissions = new ArrayList<FormSubmissionElement>();
    private List<FormValidator> validators = null;
    private FormValues values = null;
    private String formName = "Form";
    private String formAction = "";
    private String formMethod = "post";
    private String formTarget = "";
    private String formSubmit = null;
    private String encodingType = null;
    private String formPrefix = null;
    private String formSuffix = null;
    private String renderInstPrefix = null;
    private String renderInstSuffix = null;
    private String renderPrefix = null;
    private String renderMiddle = null;
    private String renderSuffix = null;
    private String renderPrefixVal = null;
    private String renderMiddleVal = null;
    private String renderSuffixVal = null;
    private String additionalAttributes = null;
    private boolean includeNameInFormTag = false;
    private boolean html5NoValidate = false;
    private Boolean autocomplete = null;
    private Set<String> acceptCharset = null;
    private boolean useLabels = false;

    public Form(GeminiApplication application) {
        this.application = application;
        this.log = application.getLog(COMPONENT_CODE);
        try {
            this.useLabels = application.getConfigurator().getLastProperties().getYesNoProperty("UseLabels", false);
        }
        catch (Exception e) {
            this.log.log("Could not access configuartion properties from within form.", e);
        }
    }

    public Form(GeminiApplication application, String name, String action, String method) {
        this.application = application;
        this.log = application.getLog(COMPONENT_CODE);
        this.setName(name);
        this.setAction(action);
        this.setMethod(method);
        try {
            this.useLabels = application.getConfigurator().getLastProperties().getYesNoProperty("UseLabels", false);
        }
        catch (Exception e) {
            this.log.log("Could not access configuartion properties from within form.", e);
        }
    }

    public FormValues values() {
        if (this.values == null) {
            this.values = new FormValues(this);
        }
        return this.values;
    }

    public FormValidation validate(Context context) {
        FormValidation toReturn = new FormValidation(this, context);
        return toReturn;
    }

    public Form add(FormValidator fv) {
        if (this.validators == null) {
            this.validators = new ArrayList<FormValidator>();
        }
        this.validators.add(fv);
        return this;
    }

    public void addValidator(FormValidator fv) {
        this.add(fv);
    }

    public Form add(FormElementValidator fev, String ... elementNames) {
        if (fev != null && elementNames != null) {
            int i = 0;
            while (i < elementNames.length) {
                Object element = this.getElement(elementNames[i]);
                if (element != null) {
                    ((FormElement)element).addValidator(fev);
                }
                ++i;
            }
        }
        return this;
    }

    public void addElementValidator(FormElementValidator fev, String ... elementNames) {
        this.add(fev, elementNames);
    }

    public Collection<FormValidator> getValidators() {
        return this.validators;
    }

    public String toString() {
        return "Form [\"" + this.getName() + "\"; " + this.formElements.size() + " element(s)]";
    }

    public String dumpContents() {
        StringBuilder toReturn = new StringBuilder(1000);
        int i = 0;
        while (i < this.formElements.size()) {
            FormElement elem = this.formElements.get(i);
            toReturn.append(elem.getDisplayName());
            toReturn.append(": ");
            if (elem instanceof FormCheckBox) {
                FormCheckBox checkBox = (FormCheckBox)elem;
                if (checkBox.isChecked()) {
                    toReturn.append("checked");
                } else {
                    toReturn.append("not checked");
                }
            } else {
                toReturn.append(elem.getStringValue());
            }
            toReturn.append("\r\n");
            ++i;
        }
        return toReturn.toString();
    }

    public String renderStartLabel(FormElement element) {
        if (this.useLabels) {
            String forAttribute = element.getId();
            if (StringHelper.isEmptyTrimmed(forAttribute)) {
                forAttribute = element.getName();
            }
            forAttribute = StringHelper.isNonEmptyTrimmed(forAttribute) ? " for=\"" + forAttribute + '\"' : "";
            return "<label" + forAttribute + ">";
        }
        return "";
    }

    public String renderEndLabel() {
        if (this.useLabels) {
            return "</label>";
        }
        return "";
    }

    public String renderStartWithHiddenElements() {
        return this.renderStartWithHiddenElements("");
    }

    public String renderStartWithHiddenElements(String cssClass) {
        String hiddenElements = this.renderHiddenElements(false);
        return String.valueOf(this.renderStart(cssClass)) + hiddenElements;
    }

    public String render() {
        return this.render(null, true, true);
    }

    public String render(boolean includeStartAndEnd, boolean displayHiddenElements) {
        return this.render(null, includeStartAndEnd, displayHiddenElements);
    }

    public String render(FormValidation validation, boolean includeStartAndEnd, boolean displayHiddenElements) {
        return this.render(validation, includeStartAndEnd, displayHiddenElements, true);
    }

    public String render(FormValidation validation, boolean includeStartAndEnd, boolean displayHiddenElements, boolean includeValidationScriptAfterForm) {
        StringBuilder toReturn = new StringBuilder(1000);
        if (includeStartAndEnd) {
            toReturn.append(this.renderStart());
            if (!displayHiddenElements) {
                toReturn.append(this.renderHiddenElements(false));
            }
            toReturn.append(this.getFormRenderingPrefix());
        }
        for (FormElement elem : this.formElements) {
            if (!displayHiddenElements && elem instanceof FormHiddenElement) continue;
            if (StringHelper.isNonEmpty(elem.getHelpText())) {
                toReturn.append(this.getRenderingHelpPrefix());
                toReturn.append(elem.getHelpText());
                toReturn.append(this.getRenderingHelpSuffix());
            }
            if (validation != null && validation.getElements().contains(elem)) {
                toReturn.append(this.getRenderingPrefixErrored());
                toReturn.append(this.renderStartLabel(elem));
                toReturn.append(elem.getDisplayName());
                toReturn.append(this.renderEndLabel());
                toReturn.append(this.getRenderingSeparatorErrored());
                toReturn.append(elem.render());
                toReturn.append(this.getRenderingSuffixErrored());
                continue;
            }
            toReturn.append(this.getRenderingPrefix());
            toReturn.append(this.renderStartLabel(elem));
            toReturn.append(elem.getDisplayName());
            toReturn.append(this.renderEndLabel());
            toReturn.append(this.getRenderingSeparator());
            toReturn.append(elem.render());
            toReturn.append(this.getRenderingSuffix());
        }
        if (includeStartAndEnd) {
            toReturn.append(this.getFormRenderingSuffix());
            toReturn.append(this.renderEnd(includeValidationScriptAfterForm));
        }
        return toReturn.toString();
    }

    public String renderHiddenElements(boolean newLines) {
        StringBuilder toReturn = new StringBuilder(1000);
        Iterator<FormHiddenElement> hidden = this.getHiddenElements();
        while (hidden.hasNext()) {
            FormElement elem = (FormElement)((Object)hidden.next());
            toReturn.append(elem.render());
            if (!newLines) continue;
            toReturn.append("\r\n");
        }
        return toReturn.toString();
    }

    public String renderElements(boolean newLines) {
        StringBuilder toReturn = new StringBuilder(1000);
        for (FormElement element : this.formElements) {
            if (element == null) continue;
            toReturn.append(element.render());
            if (!newLines) continue;
            toReturn.append("\r\n");
        }
        return toReturn.toString();
    }

    public Form setFormRenderingPrefix(String prefix) {
        this.formPrefix = prefix;
        return this;
    }

    public String getFormRenderingPrefix() {
        if (this.formPrefix == null) {
            this.setFormRenderingPrefix("<table border=\"1\" cellspacing=\"1\" cellpadding=\"1\">");
        }
        return this.formPrefix;
    }

    public Form setFormRenderingSuffix(String suffix) {
        this.formSuffix = suffix;
        return this;
    }

    public String getFormRenderingSuffix() {
        if (this.formSuffix == null) {
            this.setFormRenderingSuffix("</table>");
        }
        return this.formSuffix;
    }

    public Form setRenderingPrefix(String prefix) {
        this.renderPrefix = prefix;
        return this;
    }

    public String getRenderingPrefix() {
        if (this.renderPrefix == null) {
            this.setRenderingPrefix("<tr><td>");
        }
        return this.renderPrefix;
    }

    public Form setRenderingSeparator(String separator) {
        this.renderMiddle = separator;
        return this;
    }

    public String getRenderingSeparator() {
        if (this.renderMiddle == null) {
            this.setRenderingSeparator(":</td><td>");
        }
        return this.renderMiddle;
    }

    public Form setRenderingSuffix(String suffix) {
        this.renderSuffix = suffix;
        return this;
    }

    public String getRenderingSuffix() {
        if (this.renderSuffix == null) {
            this.setRenderingSuffix("</td></tr>");
        }
        return this.renderSuffix;
    }

    public Form setRenderingHelpPrefix(String prefix) {
        this.renderInstPrefix = prefix;
        return this;
    }

    public String getRenderingHelpPrefix() {
        if (this.renderInstPrefix == null) {
            this.setRenderingHelpPrefix("<tr><td colspan='2'>");
        }
        return this.renderInstPrefix;
    }

    public Form setRenderingHelpSuffix(String suffix) {
        this.renderInstSuffix = suffix;
        return this;
    }

    public String getRenderingHelpSuffix() {
        if (this.renderInstSuffix == null) {
            this.setRenderingHelpSuffix("</td></tr>");
        }
        return this.renderInstSuffix;
    }

    public Form setRenderingPrefixErrored(String prefix) {
        this.renderPrefixVal = prefix;
        return this;
    }

    public String getRenderingPrefixErrored() {
        if (this.renderPrefixVal == null) {
            this.setRenderingPrefixErrored("<tr><td><b>");
        }
        return this.renderPrefixVal;
    }

    public Form setRenderingSeparatorErrored(String separator) {
        this.renderMiddleVal = separator;
        return this;
    }

    public String getRenderingSeparatorErrored() {
        if (this.renderMiddleVal == null) {
            this.setRenderingSeparatorErrored(":</b></td><td>");
        }
        return this.renderMiddleVal;
    }

    public Form setRenderingSuffixErrored(String suffix) {
        this.renderSuffixVal = suffix;
        return this;
    }

    public String getRenderingSuffixErrored() {
        if (this.renderSuffixVal == null) {
            this.setRenderingSuffixErrored("</td></tr>");
        }
        return this.renderSuffixVal;
    }

    public String renderStart() {
        return this.renderStart("");
    }

    public String renderStart(String cssClass) {
        StringBuilder buffer = new StringBuilder(120);
        buffer.append("<form id=\"");
        buffer.append(this.getName());
        if (this.isIncludeNameInFormTag()) {
            buffer.append("\" name=\"");
            buffer.append(this.getName());
        }
        if (this.isHtml5NoValidate()) {
            buffer.append("\" novalidate=\"novalidate");
        }
        if (StringHelper.isNonEmpty(cssClass)) {
            buffer.append("\" class=\"");
            buffer.append(cssClass);
        }
        buffer.append("\" action=\"");
        buffer.append(this.getAction());
        buffer.append("\" method=\"");
        buffer.append(this.getMethod());
        buffer.append("\"");
        if (StringHelper.isNonEmpty(this.getTarget())) {
            buffer.append(" target=\"");
            buffer.append(this.getTarget());
            buffer.append("\"");
        }
        if (StringHelper.isNonEmpty(this.formSubmit)) {
            buffer.append(" onsubmit=\"");
            buffer.append(this.formSubmit);
            buffer.append("\"");
        }
        if (StringHelper.isNonEmpty(this.encodingType)) {
            buffer.append(" enctype=\"");
            buffer.append(this.encodingType);
            buffer.append("\"");
        }
        if (this.autocomplete != null) {
            buffer.append(" autocomplete=\"");
            if (this.autocomplete.booleanValue()) {
                buffer.append("on");
            } else {
                buffer.append("off");
            }
            buffer.append("\"");
        }
        if (CollectionHelper.isNonEmpty(this.acceptCharset)) {
            buffer.append(" accept-charset=\"");
            StringHelper.join(" ", this.acceptCharset);
            buffer.append("\"");
        }
        if (StringHelper.isNonEmpty(this.additionalAttributes)) {
            buffer.append(" " + this.additionalAttributes);
        }
        buffer.append(">");
        return buffer.toString();
    }

    public String renderEnd() {
        return this.renderEnd(true);
    }

    public String renderEnd(boolean withJSValidation) {
        StringBuilder end = new StringBuilder(200);
        end.append("</form>");
        if (withJSValidation && this.application.getConfigurator().getLastProperties().getYesNoProperty("UseClientSideValidation", false)) {
            end.append(this.renderScriptTagForClientSideValidation());
        }
        return end.toString();
    }

    public String renderScriptTagForClientSideValidation() {
        StringBuilder script = new StringBuilder(200);
        script.append("<script type=\"text/javascript\">\r\n");
        script.append("$(document).ready(function(){\r\n");
        script.append("  $(\"#");
        script.append(this.formName);
        script.append("\").validate(");
        HashMap<String, String> clientSideValidationOptions = new HashMap<String, String>(2);
        clientSideValidationOptions.put("meta", "validate");
        clientSideValidationOptions.put("errorClass", "invalid");
        script.append(JavaScriptWriter.standard().write(clientSideValidationOptions));
        script.append(");\r\n});\r\n</script>");
        return script.toString();
    }

    public Form setName(String name) {
        this.formName = name;
        return this;
    }

    public String getName() {
        return this.formName;
    }

    public boolean isIncludeNameInFormTag() {
        return this.includeNameInFormTag;
    }

    public Form setIncludeNameInFormTag(boolean includeNameInFormTag) {
        this.includeNameInFormTag = includeNameInFormTag;
        return this;
    }

    public boolean isHtml5NoValidate() {
        return this.html5NoValidate;
    }

    public void setHtml5NoValidate(boolean html5NoValidate) {
        this.html5NoValidate = html5NoValidate;
    }

    public void setTarget(String target) {
        this.formTarget = target;
    }

    public String getTarget() {
        return this.formTarget;
    }

    public String getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public void setAdditionalAttributes(String additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    public GeminiApplication getApplication() {
        return this.application;
    }

    public void setAction(String action) {
        this.formAction = action;
    }

    public String getAction() {
        return this.formAction;
    }

    public void setMethod(String method) {
        this.formMethod = method;
    }

    public String getMethod() {
        return this.formMethod;
    }

    public void setOnSubmit(String onSubmit) {
        this.formSubmit = onSubmit;
    }

    public String getOnSubmit() {
        return this.formSubmit;
    }

    public Iterator<FormElement> getElements() {
        return this.formElements.iterator();
    }

    public List<FormElement> getList() {
        return new ArrayList<FormElement>(this.formElements);
    }

    public Map<String, FormElement> getMap() {
        return new HashMap<String, FormElement>(this.formElementsByName);
    }

    public List<FormElement> getElementsStartWith(String prefix) {
        ArrayList<FormElement> matchingElements = new ArrayList<FormElement>();
        for (FormElement element : this.formElements) {
            if (element == null || !StringHelper.startsWithIgnoreCase(element.getName(), prefix)) continue;
            matchingElements.add(element);
        }
        return matchingElements;
    }

    public void setEncodingType(String enctype) {
        this.encodingType = enctype;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public Boolean getAutocomplete() {
        return this.autocomplete;
    }

    public void setAutocomplete(Boolean autocomplete) {
        this.autocomplete = autocomplete;
    }

    public Iterator<FormHiddenElement> getHiddenElements() {
        ArrayList<FormHiddenElement> hiddenElements = new ArrayList<FormHiddenElement>();
        for (FormElement obj : this.formElements) {
            if (!(obj instanceof FormHiddenElement)) continue;
            hiddenElements.add((FormHiddenElement)((Object)obj));
        }
        return hiddenElements.iterator();
    }

    public Iterator<FormElement> getVisibleElements() {
        ArrayList<FormElement> visibleElements = new ArrayList<FormElement>();
        for (FormElement obj : this.formElements) {
            if (obj instanceof FormHiddenElement) continue;
            visibleElements.add(obj);
        }
        return visibleElements.iterator();
    }

    public void addElementsFromForm(Form anotherForm) {
        this.addAll(anotherForm.getList());
    }

    public Form addAll(List<FormElement> elements) {
        for (FormElement element : elements) {
            this.add(element);
        }
        return this;
    }

    public Form add(FormElement element) {
        int index = -1;
        if (this.formElementsByName.containsKey(element.getName())) {
            index = this.formElements.indexOf(element);
        }
        this.formElementsByName.put(element.getName(), element);
        if (index >= 0) {
            this.formElements.set(index, element);
        } else {
            this.formElements.add(element);
        }
        if (element instanceof FormSubmissionElement) {
            if (this.formSubmissions.indexOf(element) >= 0) {
                this.formSubmissions.remove(element);
            }
            if (index >= 0) {
                this.formSubmissions.add(index, (FormSubmissionElement)element);
            } else {
                this.formSubmissions.add((FormSubmissionElement)element);
            }
        }
        if (element instanceof FormFileBrowse && (this.getEncodingType() == null || this.getEncodingType().equals(""))) {
            this.setEncodingType("multipart/form-data");
        }
        element.setForm(this);
        return this;
    }

    public void addElement(FormElement element) {
        this.add(element);
    }

    public void addElement(int index, FormElement element) {
        this.add(element);
    }

    public void add(int index, FormElement element) {
        this.add(element);
    }

    public int getElementIndex(String elementName) {
        return this.getElementIndex((FormElement)this.getElement(elementName));
    }

    public int getElementIndex(FormElement element) {
        return this.formElements.indexOf(element);
    }

    public void addSubmissionElement(FormSubmissionElement element) {
        this.add(element);
    }

    public Form remove(String name) {
        this.remove((FormElement)this.getElement(name));
        return this;
    }

    public void removeElement(String name) {
        this.remove(name);
    }

    public Form remove(FormElement element) {
        if (element != null) {
            element.setForm(null);
            this.formElements.remove(element);
            this.formElementsByName.remove(element.getName());
            if (element instanceof FormSubmissionElement) {
                this.formSubmissions.remove(element);
            }
        }
        return this;
    }

    public void removeElement(FormElement element) {
        this.remove(element);
    }

    public void removeSubmissionElement(FormSubmissionElement element) {
        this.remove(element);
    }

    public FormElement getElement(int elementNumber) {
        if (elementNumber >= 0 && elementNumber < this.formElements.size()) {
            return this.formElements.get(elementNumber);
        }
        return null;
    }

    public int getElementCount() {
        return this.formElements.size();
    }

    public FormElement getFirstVisibleElement() {
        for (FormElement element : this.formElements) {
            if (element instanceof FormHiddenElement) continue;
            return element;
        }
        return null;
    }

    public <E extends FormElement> E getElement(String name) {
        return (E)this.formElementsByName.get(name);
    }

    @Deprecated
    public String getStringValue(String elementName) {
        return this.values().get(elementName);
    }

    @Deprecated
    public String getStringValue(String elementName, String defaultValue) {
        return this.values().get(elementName, defaultValue);
    }

    @Deprecated
    public int getIntegerValue(String elementName) {
        return this.values().getInt(elementName);
    }

    @Deprecated
    public int getIntegerValue(String elementName, int defaultValue) {
        return this.values().getInt(elementName, defaultValue);
    }

    @Deprecated
    public long getLongValue(String elementName) {
        return this.values().getLong(elementName);
    }

    @Deprecated
    public long getLongValue(String elementName, long defaultValue) {
        return this.values().getLong(elementName, defaultValue);
    }

    @Deprecated
    public float getFloatValue(String elementName) {
        return this.values().getFloat(elementName);
    }

    @Deprecated
    public float getFloatValue(String elementName, float defaultValue) {
        return this.values().getFloat(elementName, defaultValue);
    }

    @Deprecated
    public boolean getCheckedValue(String checkBoxElementName) {
        return this.values().getBoolean(checkBoxElementName);
    }

    @Deprecated
    public boolean getCheckedValue(String checkBoxElementName, boolean defaultValue) {
        return this.values().getBoolean(checkBoxElementName, defaultValue);
    }

    @Deprecated
    public Date getDateValue(String dateElementName) {
        return this.values().getDate(dateElementName);
    }

    @Deprecated
    public String getRenderableValue(String elementName) {
        Object element = this.getElement(elementName);
        if (element != null) {
            return ((FormElement)element).getRenderableValue();
        }
        return null;
    }

    @Deprecated
    public String getRenderableValue(String elementName, String defaultValue) {
        Object element = this.getElement(elementName);
        if (element != null) {
            return ((FormElement)element).getRenderableValue();
        }
        return defaultValue;
    }

    public Form setValues(Context context) {
        for (FormElement element : this.formElements) {
            element.setValue(context);
        }
        return this;
    }

    public boolean isSubmitted(Context context) {
        for (FormSubmissionElement element : this.formSubmissions) {
            if (context != null) {
                element.setValue(context);
            }
            if (!element.isSubmitted()) continue;
            return true;
        }
        return false;
    }

    public boolean hasBeenSubmitted(Context context) {
        if (this.isSubmitted(context)) {
            this.setValues(context);
            return true;
        }
        return false;
    }

    public <C extends Context> boolean hasBeenValidlySubmitted(C context) {
        if (this.hasBeenSubmitted(context)) {
            FormValidation validation = this.validate(context);
            if (validation.hasErrors()) {
                context.delivery().putObject(VALIDATION, validation);
            } else {
                this.onValidlySubmitted();
                return true;
            }
        }
        return false;
    }

    protected abstract void onValidlySubmitted();

    public Form revertCheckBoxes() {
        for (FormElement element : this.formElements) {
            if (!(element instanceof FormRevertableElement)) continue;
            ((FormRevertableElement)((Object)element)).revert();
        }
        return this;
    }

    public String renderHeadScript(String scriptDirectory) {
        StringBuilder toReturn = new StringBuilder();
        ArrayList usedClasses = new ArrayList();
        for (FormElement elem : this.formElements) {
            if (!(elem instanceof ScriptFormElement) || usedClasses.contains(elem.getClass())) continue;
            usedClasses.add(elem.getClass());
            toReturn.append(((ScriptFormElement)((Object)elem)).renderHeadScript(this.formName, scriptDirectory));
            toReturn.append("\r\n");
        }
        return toReturn.toString();
    }

    public String renderOnLoadScript() {
        StringBuilder toReturn = new StringBuilder();
        for (FormElement elem : this.formElements) {
            if (!(elem instanceof ScriptFormElement)) continue;
            toReturn.append(((ScriptFormElement)((Object)elem)).renderOnLoadScript(this.formName));
        }
        return toReturn.toString();
    }

    public Form addAcceptCharset(String charsetName) {
        if (this.acceptCharset == null) {
            this.acceptCharset = new HashSet<String>();
        }
        this.acceptCharset.add(charsetName);
        return this;
    }
}

