/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.FormElement;
import com.techempower.helper.NetworkHelper;

public class FormButton
extends FormElement {
    public static final String DEFAULT_VALUE = "Button";
    private String value;

    public FormButton(String name) {
        super(name);
    }

    public FormButton(String name, String value) {
        super(name);
        this.value = value;
    }

    @Override
    public FormElement setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public FormElement setValue(Context context) {
        this.value = context.query().get(this.getName(), "");
        return this;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public String getRenderableValue() {
        return NetworkHelper.escapeStringForHtml(this.value);
    }

    @Override
    public String getEscapedValue() {
        return NetworkHelper.escapeStringForHtml(this.value);
    }

    @Override
    public String render() {
        return this.render(this.getStyle());
    }

    @Override
    public String render(String cssCode) {
        StringBuilder buffer = new StringBuilder(120);
        buffer.append("<input type=\"button\"");
        buffer.append(this.renderClassName());
        buffer.append(" name=\"");
        buffer.append(this.getName());
        buffer.append("\" value=\"");
        buffer.append(this.getRenderableValue());
        buffer.append('\"');
        buffer.append(this.renderTabIndex());
        buffer.append(this.renderFormEvents());
        buffer.append(this.renderEnabled());
        if (!this.isUsingHTML5Forms()) {
            buffer.append(this.renderReadOnly());
        }
        buffer.append(this.renderId());
        buffer.append(this.renderStyle(cssCode));
        buffer.append(" />");
        return buffer.toString();
    }
}

