/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormDateElement;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormTextField;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class FormComplexDateField
extends FormTextField
implements FormDateElement {
    public static final int LENGTH = 50;
    public static final String VALUE = "";
    private static final Calendar DEFAULT_MIN_DATE = DateHelper.getCalendarInstance();
    private static final Calendar DEFAULT_MAX_DATE;
    private List<SimpleDateFormat> dateFormatters = null;
    private Calendar minDate = null;
    private Calendar maxDate = null;
    private TimeZone timeZone = null;
    private boolean deltaDate = false;
    private String type = "text";

    static {
        DEFAULT_MIN_DATE.set(1900, 0, 1, 0, 0, 0);
        DEFAULT_MIN_DATE.set(14, 0);
        DEFAULT_MIN_DATE.set(9, 0);
        DEFAULT_MAX_DATE = DateHelper.getCalendarInstance();
        DEFAULT_MAX_DATE.set(9999, 11, 31, 11, 59, 59);
        DEFAULT_MAX_DATE.set(14, 999);
        DEFAULT_MAX_DATE.set(9, 1);
    }

    public FormComplexDateField(String name, String value, boolean required, int length, int maxLength, Calendar minDate, Calendar maxDate) {
        super(name, value, required, length, maxLength);
        this.setMinimum(minDate);
        this.setMaximum(maxDate);
        this.dateFormatters = DateHelper.getDefaultDateFormatters();
    }

    public FormComplexDateField(String name, String value, boolean required, int length, int maxLength, Calendar minDate, Calendar maxDate, Form form) {
        super(name, value, required, length, maxLength, form);
        this.setMinimum(minDate);
        this.setMaximum(maxDate);
        this.dateFormatters = DateHelper.getDefaultDateFormatters();
    }

    public FormComplexDateField(String name, String value, boolean required, int length, Calendar minDate, Calendar maxDate) {
        this(name, value, required, length, length, minDate, maxDate);
    }

    public FormComplexDateField(String name, String value, boolean required, int length, Calendar minDate, Calendar maxDate, Form form) {
        this(name, value, required, length, length, minDate, maxDate, form);
    }

    public FormComplexDateField(String name, String value, boolean required, int length) {
        this(name, value, required, length, length, DEFAULT_MIN_DATE, DEFAULT_MAX_DATE);
    }

    public FormComplexDateField(String name, String value, boolean required, int length, Form form) {
        this(name, value, required, length, length, DEFAULT_MIN_DATE, DEFAULT_MAX_DATE, form);
    }

    public FormComplexDateField(String name, boolean required, int length) {
        this(name, VALUE, required, length);
    }

    public FormComplexDateField(String name, boolean required, int length, Form form) {
        this(name, VALUE, required, length, form);
    }

    public FormComplexDateField(String name, int length) {
        this(name, VALUE, false, length);
    }

    public FormComplexDateField(String name, int length, Form form) {
        this(name, VALUE, false, length, form);
    }

    public FormComplexDateField(String name, Calendar minDate, Calendar maxDate) {
        this(name, VALUE, false, 50, minDate, maxDate);
    }

    public FormComplexDateField(String name, Calendar minDate, Calendar maxDate, Form form) {
        this(name, VALUE, false, 50, minDate, maxDate, form);
    }

    public FormComplexDateField(String name) {
        this(name, VALUE, false, 50);
    }

    public FormComplexDateField(String name, Form form) {
        this(name, VALUE, false, 50, form);
    }

    public FormComplexDateField(String name, Date value, boolean required, int length, Form form) {
        super(name, required, length, length, form);
        this.setValue(value);
        this.setLength(length);
        this.setMaxLength(length);
    }

    public FormComplexDateField(String name, Date value, boolean required, int length) {
        super(name, required, length, length, null);
        this.setValue(value);
        this.setLength(length);
        this.setMaxLength(length);
    }

    public FormComplexDateField(String name, Calendar value, boolean required, int length, Form form) {
        super(name, required, length, length, form);
        this.setValue(value);
        this.setLength(length);
        this.setMaxLength(length);
    }

    public FormComplexDateField(String name, Calendar value, boolean required, int length) {
        super(name, required, length, length, null);
        this.setValue(value);
        this.setLength(length);
        this.setMaxLength(length);
    }

    public void setDeltaDate(boolean mode) {
        this.deltaDate = mode;
    }

    public boolean isDeltaDate() {
        return this.deltaDate;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setMinimum(Calendar minDate) {
        this.minDate = minDate;
    }

    public Calendar getMinimum() {
        return this.minDate;
    }

    public void setMaximum(Calendar maxDate) {
        this.maxDate = maxDate;
    }

    public Calendar getMaximum() {
        return this.maxDate;
    }

    @Override
    @Deprecated
    public Calendar getCalendarValue() {
        return this.getCalendarValue(null);
    }

    public Calendar getCalendarValue(Calendar deltaRelative) {
        Calendar toReturn = null;
        if (StringHelper.isNonEmpty(this.getValue())) {
            toReturn = this.getTimeZone() != null ? DateHelper.parse(this.getValue(), this.dateFormatters, null, this.timeZone) : DateHelper.parse(this.getValue(), this.dateFormatters);
            if (this.deltaDate && toReturn == null && !DateHelper.deltaDate(toReturn = deltaRelative != null ? (Calendar)deltaRelative.clone() : DateHelper.getCalendarInstance(), this.getValue())) {
                toReturn = null;
            }
        }
        return toReturn;
    }

    @Override
    public Date getDateValue() {
        return this.getDateValue(null);
    }

    public Date getDateValue(Calendar deltaRelative) {
        Calendar calValue = this.getCalendarValue(deltaRelative);
        if (calValue != null) {
            return calValue.getTime();
        }
        return null;
    }

    @Override
    public void setValue(Date date) {
        if (date != null) {
            this.setValue(DateHelper.STANDARD_FULL_DATE_FORMAT.format(date, this.timeZone));
        } else {
            this.setValue(VALUE);
        }
    }

    @Override
    public void setValue(Calendar calendar) {
        if (calendar != null) {
            this.setValue(DateHelper.STANDARD_FULL_DATE_FORMAT.format(calendar.getTime(), this.timeZone));
        } else {
            this.setValue(VALUE);
        }
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        super.requiredValidation(val);
        if (this.dateFormatters == null || this.dateFormatters.size() <= 0) {
            this.dateFormatters = DateHelper.getDefaultDateFormatters();
        }
        if (this.isRequired() && this.getValue().trim().length() == 0) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError("gfcdf-empty-e", macros, "gfcdf-empty-i", macros, "gfcdf-empty-l", macros);
        } else if (DateHelper.isValid(this.getValue(), this.dateFormatters)) {
            Calendar dateToBoundsCheck;
            if (this.minDate == null) {
                this.minDate = DEFAULT_MIN_DATE;
            }
            if (this.maxDate == null) {
                this.maxDate = DEFAULT_MAX_DATE;
            }
            if ((dateToBoundsCheck = this.getCalendarValue()).before(this.minDate)) {
                String[] macros = new String[]{this.getDisplayName(), DateHelper.format(this.getMinimum(), 1, 2, "/", VALUE)};
                val.setError("gfcdf-before-e", macros, "gfcdf-before-i", macros, "gfcdf-before-l", macros);
            } else if (dateToBoundsCheck.after(this.maxDate)) {
                String[] macros = new String[]{this.getDisplayName(), DateHelper.format(this.getMaximum(), 1, 2, "/", VALUE)};
                val.setError("gfcdf-after-e", macros, "gfcdf-after-i", macros, "gfcdf-after-l", macros);
            }
        } else if (!(this.deltaDate && DateHelper.deltaDate(DateHelper.getCalendarInstance(), this.getValue()) || this.getValue().trim().length() <= 0)) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError("gfcdf-invalid-e", macros, "gfcdf-invalid-i", macros, "gfcdf-invalid-l", macros);
        }
    }

    public void setDateFormatters(List<SimpleDateFormat> pDateFormatters) {
        if (pDateFormatters != null && !pDateFormatters.isEmpty()) {
            this.dateFormatters = pDateFormatters;
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void useDateType() {
        this.type = "date";
    }

    public void useTextType() {
        this.type = "text";
    }

    public void useDatetimeType() {
        this.type = "datetime";
    }
}

