/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormFloatField;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;
import java.text.NumberFormat;
import java.util.Locale;

public class FormCurrencyField
extends FormFloatField {
    public static final float MINIMUM = 0.0f;
    public static final float MAXIMUM = 1.0E9f;
    public static final int TEXT_LENGTH = 12;
    private NumberFormat currencyFormatter = NumberFormat.getCurrencyInstance();
    private String[] finds = new String[]{",", this.currencyFormatter.getCurrency().getSymbol()};
    private String[] replaces = new String[]{"", ""};

    public FormCurrencyField(String name, String value, boolean required, float min, float max, int length, int maxLength) {
        super(name, value, required, min, max, length, maxLength);
    }

    public FormCurrencyField(String name, String value, boolean required, float min, float max, int length, int maxLength, Form form) {
        super(name, value, required, min, max, length, maxLength, form);
    }

    public FormCurrencyField(String name, String value, boolean required, float min, float max, int length) {
        this(name, value, required, min, max, length, length);
    }

    public FormCurrencyField(String name, String value, boolean required, float min, float max, int length, Form form) {
        this(name, value, required, min, max, length, length, form);
    }

    public FormCurrencyField(String name, String value, boolean required, float min, float max) {
        this(name, value, required, min, max, 12);
    }

    public FormCurrencyField(String name, String value, boolean required, float min, float max, Form form) {
        this(name, value, required, min, max, 12, form);
    }

    public FormCurrencyField(String name, float value, boolean required, float min, float max) {
        this(name, "" + value, required, min, max, 12);
    }

    public FormCurrencyField(String name, float value, boolean required, float min, float max, Form form) {
        this(name, "" + value, required, min, max, 12, form);
    }

    public FormCurrencyField(String name, String value, float min, float max) {
        this(name, value, false, min, max, 12);
    }

    public FormCurrencyField(String name, String value, float min, float max, Form form) {
        this(name, value, false, min, max, 12, form);
    }

    public FormCurrencyField(String name, float min, float max) {
        this(name, "", false, min, max, 12);
    }

    public FormCurrencyField(String name, float min, float max, Form form) {
        this(name, "", false, min, max, 12, form);
    }

    public FormCurrencyField(String name) {
        this(name, "", false, 0.0f, 1.0E9f, 12);
    }

    public FormCurrencyField(String name, Form form) {
        this(name, "", false, 0.0f, 1.0E9f, 12, form);
    }

    @Override
    public FormCurrencyField setValue(String value) {
        if (!this.isReadOnly()) {
            super.setValue(StringHelper.replaceSubstrings(value, this.finds, this.replaces));
        }
        return this;
    }

    @Override
    public String getRenderableValue() {
        if (this.getValue().length() == 0) {
            return "";
        }
        String toReturn = this.renderAsCurrency(this.getFloatValue());
        return NetworkHelper.escapeStringForHtml(toReturn);
    }

    @Override
    public String getStringValue() {
        if (this.getValue().length() == 0) {
            return "";
        }
        return this.renderAsCurrency(this.getFloatValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderAsCurrency(float value) {
        NumberFormat numberFormat = this.currencyFormatter;
        synchronized (numberFormat) {
            return this.currencyFormatter.format(value);
        }
    }

    @Override
    public String getMaximumAsString() {
        return this.renderAsCurrency(this.getMaximum());
    }

    @Override
    public String getMinimumAsString() {
        return this.renderAsCurrency(this.getMinimum());
    }

    public NumberFormat getCurrencyFormatter() {
        return this.currencyFormatter;
    }

    public void setCurrencyFormatter(NumberFormat currencyFomatter, Locale locale) {
        this.currencyFormatter = currencyFomatter;
        this.finds = new String[]{",", this.currencyFormatter.getCurrency().getSymbol(locale)};
        this.replaces = new String[]{"", ""};
    }

    @Override
    public String getType() {
        return "text";
    }
}

