/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormComplexDateField;
import com.techempower.gemini.form.FormSelect;
import com.techempower.helper.DateHelper;
import com.techempower.util.UtilityConstants;
import java.util.Calendar;
import java.util.Date;

public class FormDateFieldDropDown
extends FormComplexDateField {
    public static final int DEFAULT_YEAR_SPAN = 10;
    private int yearStart = DateHelper.getCalendarInstance().get(1);
    private int yearSpan = 10;
    private boolean useAbbreviations = false;
    private boolean useInternationalOrder = false;

    public FormDateFieldDropDown(String name, String value, boolean required, int length) {
        super(name, value, required, length);
    }

    public FormDateFieldDropDown(String name, String value, boolean required, int length, Form form) {
        super(name, value, required, length, form);
    }

    public FormDateFieldDropDown(String name, String value, boolean required) {
        super(name, value, required, 20);
    }

    public FormDateFieldDropDown(String name, String value, boolean required, Form form) {
        super(name, value, required, 20, form);
    }

    public FormDateFieldDropDown(String name, Date value, boolean required, int length) {
        super(name, value, required, length);
    }

    public FormDateFieldDropDown(String name, Date value, boolean required, int length, Form form) {
        super(name, value, required, length, form);
    }

    public FormDateFieldDropDown(String name, Date value, boolean required) {
        super(name, value, required, 20);
    }

    public FormDateFieldDropDown(String name, Date value, boolean required, Form form) {
        super(name, value, required, 20, form);
    }

    public FormDateFieldDropDown(String name, Calendar value, boolean required, int length) {
        super(name, value, required, length);
    }

    public FormDateFieldDropDown(String name, Calendar value, boolean required, int length, Form form) {
        super(name, value, required, length, form);
    }

    public FormDateFieldDropDown(String name, Calendar value, boolean required) {
        super(name, value, required, 20);
    }

    public FormDateFieldDropDown(String name, Calendar value, boolean required, Form form) {
        super(name, value, required, 20, form);
    }

    public FormDateFieldDropDown(String name, boolean required, int length) {
        this(name, "", required, length);
    }

    public FormDateFieldDropDown(String name, boolean required, int length, Form form) {
        this(name, "", required, length, form);
    }

    public FormDateFieldDropDown(String name, boolean required) {
        this(name, "", required, 20);
    }

    public FormDateFieldDropDown(String name, boolean required, Form form) {
        this(name, "", required, 20, form);
    }

    public FormDateFieldDropDown(String name, int length) {
        this(name, "", false, length);
    }

    public FormDateFieldDropDown(String name, int length, Form form) {
        this(name, "", false, length, form);
    }

    public FormDateFieldDropDown(String name) {
        this(name, "", false, 20);
    }

    public FormDateFieldDropDown(String name, Form form) {
        this(name, "", false, 20, form);
    }

    @Override
    public FormDateFieldDropDown setValue(Context context) {
        String month = context.query().get(String.valueOf(this.getName()) + "-month", "");
        String day = context.query().get(String.valueOf(this.getName()) + "-day", "");
        String year = context.query().get(String.valueOf(this.getName()) + "-year", "");
        if (!(month.equalsIgnoreCase("") || day.equalsIgnoreCase("") || year.equalsIgnoreCase(""))) {
            this.setValue(String.valueOf(month) + "/" + day + "/" + year);
        }
        return this;
    }

    @Override
    public String render(String cssCode) {
        if (this.useInternationalOrder()) {
            return String.valueOf(this.buildDayDropDown().render(cssCode)) + this.buildMonthDropDown().render(cssCode) + this.buildYearDropDown().render(cssCode);
        }
        return String.valueOf(this.buildMonthDropDown().render(cssCode)) + this.buildDayDropDown().render(cssCode) + this.buildYearDropDown().render(cssCode);
    }

    protected FormSelect buildMonthDropDown() {
        Calendar dateValue;
        String[] values = new String[12];
        int i = 0;
        while (i < 12) {
            values[i] = Integer.toString(i + 1);
            ++i;
        }
        String selected = "1";
        if (!this.isRequired()) {
            selected = "";
        }
        if ((dateValue = this.getCalendarValue()) != null) {
            selected = Integer.toString(this.getCalendarValue().get(2) + 1);
        }
        String[] monthNames = this.useAbbreviations() ? UtilityConstants.MONTH_NAMES_ABBREVIATED : UtilityConstants.MONTH_NAMES;
        FormSelect monthSelect = new FormSelect(String.valueOf(this.getName()) + "-month");
        monthSelect.addOptionsFromArray(values, monthNames).setRequired(this.isRequired()).setValue(selected);
        if (!this.isRequired()) {
            monthSelect.insertOption(0, new FormSelect.Option("", ""));
        }
        return monthSelect;
    }

    protected FormSelect buildDayDropDown() {
        Calendar dateValue;
        String[] values = new String[31];
        int i = 0;
        while (i < 31) {
            values[i] = Integer.toString(i + 1);
            ++i;
        }
        String selected = "1";
        if (!this.isRequired()) {
            selected = "";
        }
        if ((dateValue = this.getCalendarValue()) != null) {
            selected = Integer.toString(this.getCalendarValue().get(5));
        }
        FormSelect daySelect = new FormSelect(String.valueOf(this.getName()) + "-day");
        daySelect.addOptionsFromArray(values).setRequired(this.isRequired()).setValue(selected);
        if (!this.isRequired()) {
            daySelect.insertOption(0, new FormSelect.Option("", ""));
        }
        return daySelect;
    }

    protected FormSelect buildYearDropDown() {
        Calendar dateValue;
        int i;
        String[] values = new String[Math.abs(this.yearSpan)];
        if (this.yearSpan > 0) {
            i = 0;
            while (i < values.length) {
                values[i] = Integer.toString(this.yearStart + i);
                ++i;
            }
        } else {
            i = values.length - 1;
            while (i >= 0) {
                values[i] = Integer.toString(this.yearStart - i);
                --i;
            }
        }
        String selected = Integer.toString(this.yearStart);
        if (!this.isRequired()) {
            selected = "";
        }
        if ((dateValue = this.getCalendarValue()) != null) {
            selected = Integer.toString(this.getCalendarValue().get(1));
        }
        FormSelect yearSelect = new FormSelect(String.valueOf(this.getName()) + "-year");
        yearSelect.addOptionsFromArray(values, values).setRequired(this.isRequired()).setValue(selected);
        if (!this.isRequired()) {
            yearSelect.insertOption(0, new FormSelect.Option("", ""));
        }
        return yearSelect;
    }

    public int getYearSpan() {
        return this.yearSpan;
    }

    public void setYearSpan(int yearSpan) {
        this.yearSpan = yearSpan;
    }

    public int getYearStart() {
        return this.yearStart;
    }

    public void setYearStart(int yearStart) {
        this.yearStart = yearStart;
    }

    public void setYearStart(Date start) {
        Calendar cal = DateHelper.getCalendarInstance();
        cal.setTime(start);
        this.setYearStart(cal.get(1));
    }

    public boolean useAbbreviations() {
        return this.useAbbreviations;
    }

    public void setUseAbbreviations(boolean useAbbreviations) {
        this.useAbbreviations = useAbbreviations;
    }

    public boolean useInternationalOrder() {
        return this.useInternationalOrder;
    }

    public void setUseInternationalOrder(boolean useInternationalOrder) {
        this.useInternationalOrder = useInternationalOrder;
    }
}

