/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormTextField;
import com.techempower.helper.NetworkHelper;

public class FormEmailAddressField
extends FormTextField {
    public FormEmailAddressField(String displayName, String name, String value, boolean required, int length, int maxLength) {
        super(name, value, required, length);
        if (displayName != null) {
            this.setDisplayName(displayName);
        }
        this.setLength(length);
        this.setMaxLength(maxLength);
    }

    public FormEmailAddressField(String displayName, String name, String value, boolean required, int length, int maxLength, Form form) {
        super(name, value, required, length, form);
        if (displayName != null) {
            this.setDisplayName(displayName);
        }
        this.setLength(length);
        this.setMaxLength(maxLength);
    }

    public FormEmailAddressField(String name, String value, boolean required, int length, int maxLength) {
        this(null, name, value, required, length, maxLength);
    }

    public FormEmailAddressField(String name, String value, boolean required, int length, int maxLength, Form form) {
        this(null, name, value, required, length, maxLength, form);
    }

    public FormEmailAddressField(String name, String value, boolean required, int length) {
        this(null, name, value, required, length, length);
    }

    public FormEmailAddressField(String name, String value, boolean required, int length, Form form) {
        this(null, name, value, required, length, length, form);
    }

    public FormEmailAddressField(String name, boolean required, int length, int maxLength) {
        this(null, name, "", required, length, maxLength);
    }

    public FormEmailAddressField(String name, boolean required, int length, int maxLength, Form form) {
        this(null, name, "", required, length, maxLength, form);
    }

    public FormEmailAddressField(String name, boolean required, int length) {
        this(null, name, "", required, length, length);
    }

    public FormEmailAddressField(String name, boolean required, int length, Form form) {
        this(null, name, "", required, length, length, form);
    }

    public FormEmailAddressField(String name, int length) {
        this(null, name, "", false, length, length);
    }

    public FormEmailAddressField(String name, int length, Form form) {
        this(null, name, "", false, length, length, form);
    }

    public FormEmailAddressField(String name) {
        this(null, name, "", false, 20, 20);
    }

    public FormEmailAddressField(String name, Form form) {
        this(null, name, "", false, 20, 20, form);
    }

    @Override
    public int getIntegerValue() {
        return 0;
    }

    @Override
    public FormEmailAddressField setValue(String value) {
        super.setValue(value.trim());
        return this;
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        if (this.isRequired() && this.getStringValue().length() == 0) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError("gfeaf-empty-e", macros, "gfeaf-empty-i", macros, "gfeaf-empty-l", macros);
        } else if (this.getStringValue().length() > this.getMaxLength()) {
            String[] macros = new String[]{this.getDisplayName(), "" + this.getMaxLength()};
            val.setError("gfeaf-long-e", macros, "gfeaf-long-i", macros, "gfeaf-long-l", macros);
        } else if (this.getStringValue().length() > 0 && !NetworkHelper.validateHTML5EmailAddress(this.getStringValue())) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError("gfeaf-invalidformat-e", macros, "gfeaf-invalidformat-i", macros, "gfeaf-invalidformat-l", macros);
        }
    }

    @Override
    public String getType() {
        return "email";
    }

    @Override
    protected void addClientSideValidationClasses() {
        this.addClassName("email");
        super.addClientSideValidationClasses();
    }
}

