/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormTextField;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;

public class FormPasswordField
extends FormTextField {
    private String confirmValue = "";
    private boolean confirm;
    private boolean caseSensitive;
    private boolean alphanumericOnly;
    private boolean neverRenderPassword = false;
    public static final int FIELD_PASSWORD = 0;
    public static final int FIELD_CONFIRM = 1;

    public FormPasswordField(String displayName, String name, String value, boolean required, int length, int maxLength) {
        super(displayName, name, value, required, length, maxLength);
        this.setConfirm(false, false);
        this.setAlphanumericOnly(false);
    }

    public FormPasswordField(String displayName, String name, String value, boolean required, int length, int maxLength, Form form) {
        super(displayName, name, value, required, length, maxLength, form);
        this.setConfirm(false, false);
        this.setAlphanumericOnly(false);
    }

    public FormPasswordField(String name, String value, boolean required, int length, int maxLength) {
        this(name, name, value, required, length, maxLength);
    }

    public FormPasswordField(String name, String value, boolean required, int length, int maxLength, Form form) {
        this(name, name, value, required, length, maxLength, form);
    }

    public FormPasswordField(String name, String value, boolean required, int length) {
        this(name, name, value, required, length, length);
    }

    public FormPasswordField(String name, String value, boolean required, int length, Form form) {
        this(name, name, value, required, length, length, form);
    }

    public FormPasswordField(String name, boolean required, int length, int maxLength) {
        this(name, "", required, length, maxLength);
    }

    public FormPasswordField(String name, boolean required, int length, int maxLength, Form form) {
        this(name, "", required, length, maxLength, form);
    }

    public FormPasswordField(String name, boolean required, int length) {
        this(name, "", required, length);
    }

    public FormPasswordField(String name, boolean required, int length, Form form) {
        this(name, "", required, length, form);
    }

    public FormPasswordField(String name, int length) {
        this(name, "", false, length);
    }

    public FormPasswordField(String name, int length, Form form) {
        this(name, "", false, length, form);
    }

    public FormPasswordField(String name) {
        this(name, "", false, 20);
    }

    public FormPasswordField(String name, Form form) {
        this(name, "", false, 20, form);
    }

    public FormPasswordField setConfirm(boolean confirm, boolean caseSensitive) {
        this.confirm = confirm;
        this.caseSensitive = caseSensitive;
        this.confirmValue = this.getStringValue();
        if (confirm) {
            this.addRule("equalTo", "#" + this.getName());
        } else {
            this.removeRule("equalTo");
        }
        return this;
    }

    public FormPasswordField setAlphanumericOnly(boolean anOnly) {
        this.alphanumericOnly = anOnly;
        return this;
    }

    public FormPasswordField setNeverRenderPassword(boolean neverRenderPassword) {
        this.neverRenderPassword = neverRenderPassword;
        return this;
    }

    protected String getConfirmName() {
        return String.valueOf(this.getName()) + "-confirm";
    }

    public String getConfirmValue() {
        return this.confirmValue;
    }

    @Override
    public FormPasswordField setValue(Context context) {
        this.setValue(context.query().get(this.getName(), this.getValue()));
        if (this.confirm) {
            this.confirmValue = context.query().get(this.getConfirmName(), this.confirmValue);
        }
        return this;
    }

    @Override
    public FormPasswordField setValue(String value) {
        super.setValue(value);
        if (this.confirm) {
            this.confirmValue = value;
        }
        return this;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public boolean isNeverRenderPassword() {
        return this.neverRenderPassword;
    }

    @Override
    public String render() {
        return this.render(this.getStyle());
    }

    @Override
    public String render(String cssCode) {
        StringBuilder buffer = new StringBuilder(100);
        buffer.append(this.renderSingle(cssCode, 0));
        if (this.confirm) {
            buffer.append(this.renderSingle(cssCode, 1));
        }
        return buffer.toString();
    }

    public String renderSingle(int fieldNumber) {
        return this.renderSingle(this.getStyle(), fieldNumber);
    }

    public String renderPrincipal() {
        return this.renderSingle(0);
    }

    public String renderConfirm() {
        return this.renderSingle(1);
    }

    public String renderSingle(String cssCode, int fieldNumber) {
        if (fieldNumber >= 0 && fieldNumber <= 1) {
            StringBuilder buffer = new StringBuilder(60);
            buffer.append("<input type=\"password\"");
            buffer.append(this.renderClassName());
            if (this.isConfirm() && fieldNumber == 1) {
                buffer.append(" id=\"");
                buffer.append(this.getConfirmName());
                buffer.append("\" name=\"");
                buffer.append(this.getConfirmName());
                buffer.append("\" value=\"");
                if (!this.isNeverRenderPassword()) {
                    buffer.append(NetworkHelper.escapeStringForHtml(this.getConfirmValue()));
                }
                buffer.append("\"");
                if (this.getTabIndex() >= 0) {
                    buffer.append(" tabindex=\"" + (this.getTabIndex() + 1) + "\" ");
                }
                if (this.isUsingClientSideValidation()) {
                    buffer.append(" data-validate='");
                    buffer.append(this.renderParameterizedValidationRules());
                    buffer.append('\'');
                }
            } else {
                buffer.append(" id=\"");
                buffer.append(this.getName());
                buffer.append("\" name=\"");
                buffer.append(this.getName());
                buffer.append("\" value=\"");
                if (!this.isNeverRenderPassword()) {
                    buffer.append(this.getRenderableValue());
                }
                buffer.append("\"");
                if (this.getTabIndex() >= 0) {
                    buffer.append(" tabindex=\"" + (this.getTabIndex() + 1) + "\" ");
                }
                if (this.isUsingClientSideValidation()) {
                    buffer.append(" data-validate='");
                    buffer.append(this.renderParameterizedValidationRules());
                    buffer.append('\'');
                }
            }
            buffer.append(" size=\"");
            buffer.append(this.getLength());
            if (StringHelper.isNonEmptyTrimmed(this.getPlaceholder())) {
                buffer.append("\" placeholder=\"");
                buffer.append(this.getRenderablePlaceholder());
            }
            buffer.append("\" maxlength=\"");
            buffer.append(this.getMaxLength());
            buffer.append("\"");
            buffer.append(this.renderTabIndex());
            buffer.append(this.renderFormEvents());
            buffer.append(this.renderEnabled());
            buffer.append(this.renderReadOnly());
            buffer.append(this.renderAutocompleteDisabled());
            if (this.isUsingHTML5Forms() && this.isValidationEnabled()) {
                buffer.append(this.renderPatternString());
                buffer.append(this.renderXMozErrorMessageString());
            }
            if (this.isRequired() && this.isUsingHTML5Forms() && this.isValidationEnabled()) {
                buffer.append(" required=\"required\"");
            }
            buffer.append(this.renderStyle(cssCode));
            buffer.append("/>");
            return buffer.toString();
        }
        return "";
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        String[] macros;
        boolean charactersOkay = true;
        if (this.alphanumericOnly) {
            String value = this.getStringValue();
            charactersOkay = StringHelper.isAllAlphaNumeric(value);
        }
        if (charactersOkay) {
            if (this.isRequired() && this.getStringValue().length() == 0) {
                macros = new String[]{this.getDisplayName()};
                val.setError("gfpf-empty-e", macros, "gfpf-empty-i", macros, "gfpf-empty-l", macros);
            } else if (this.getStringValue().length() > 0 && this.getStringValue().length() < this.getMinLength()) {
                macros = new String[]{this.getDisplayName(), "" + this.getMinLength()};
                val.setError("gfpf-short-e", macros, "gfpf-short-i", macros, "gfpf-short-l", macros);
            } else if (this.getStringValue().length() > this.getMaxLength()) {
                macros = new String[]{this.getDisplayName(), "" + this.getMaxLength()};
                val.setError("gfpf-long-e", macros, "gfpf-long-i", macros, "gfpf-long-l", macros);
            } else if (this.confirm) {
                if (this.caseSensitive) {
                    if (!this.getStringValue().equals(this.confirmValue)) {
                        macros = new String[]{this.getDisplayName()};
                        val.setError("gfpf-mismatchCase-e", macros, "gfpf-mismatchCase-i", macros, "gfpf-mismatchCase-l", macros);
                    }
                } else if (!this.getStringValue().equalsIgnoreCase(this.confirmValue)) {
                    macros = new String[]{this.getDisplayName()};
                    val.setError("gfpf-mismatch-e", macros, "gfpf-mismatch-i", macros, "gfpf-mismatch-l", macros);
                }
            }
        } else {
            macros = new String[]{this.getDisplayName()};
            val.setError("gfpf-badchars-e", macros, "gfpf-badchars-i", macros, "gfpf-badchars-l", macros);
        }
    }
}

