/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormTextField;
import com.techempower.helper.PhoneHelper;
import com.techempower.helper.StringHelper;

public class FormPhoneNumberField
extends FormTextField {
    public FormPhoneNumberField(String displayName, String name, String value, boolean required, int length, int maxLength) {
        super(displayName, name, value, required, length, maxLength);
    }

    public FormPhoneNumberField(String displayName, String name, String value, boolean required, int length, int maxLength, Form form) {
        super(displayName, name, value, required, length, maxLength, form);
    }

    public FormPhoneNumberField(String name, String value, boolean required, int length, int maxLength) {
        super(name, value, required, length, maxLength);
    }

    public FormPhoneNumberField(String name, String value, boolean required, int length, int maxLength, Form form) {
        super(name, value, required, length, maxLength, form);
    }

    public FormPhoneNumberField(String name, String value, boolean required, int length) {
        super(name, value, required, length);
    }

    public FormPhoneNumberField(String name, String value, boolean required, int length, Form form) {
        super(name, value, required, length, form);
    }

    @Override
    public int getIntegerValue() {
        return 0;
    }

    public String getPhoneStandardFormat() {
        return PhoneHelper.formatStandard(this.getStringValue());
    }

    public String getPhoneAreaParenFormat() {
        return PhoneHelper.formatParen(this.getStringValue());
    }

    public long getPhoneAsLong() {
        String numbersOnly = StringHelper.stripNonNumeric(this.getValue());
        try {
            return Long.parseLong(numbersOnly);
        }
        catch (NumberFormatException nfexc) {
            return 0L;
        }
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        if (this.isRequired() && this.getStringValue().length() == 0) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError("gfpnf-empty-e", macros, "gfpnf-empty-i", macros, "gfpnf-empty-l", macros);
        } else if (this.getStringValue().length() > this.getMaxLength()) {
            String[] macros = new String[]{this.getDisplayName(), "" + this.getMaxLength()};
            val.setError("gfpnf-long-e", macros, "gfpnf-long-i", macros, "gfpnf-long-l", macros);
        } else if (this.getStringValue().length() > 0 && (this.getPhoneAsLong() < 1000000000L || this.getPhoneAsLong() > 9999999999L)) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError("gfpnf-invalidformat-e", macros, "gfpnf-invalidformat-i", macros, "gfpnf-invalidformat-l", macros);
        }
    }

    @Override
    public String getType() {
        return "tel";
    }
}

