/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

public class FormRadioButtonGroup
extends FormElement {
    public static final String[] DEFAULT_VALUES = new String[0];
    public static final String DEFAULT_SELECTION = "";
    private String selection;
    private List<String> values;
    private List<String> labels;
    private boolean incrementTabIndex = true;
    private boolean showLabels = true;
    private boolean numberByValue = false;

    public FormRadioButtonGroup(String name, String selection, String[] values, String[] labels, boolean required, boolean numberByValue) {
        super(name, selection, required);
        this.setLabelList(labels);
        this.setValueList(values);
        this.numberByValue = numberByValue;
    }

    public FormRadioButtonGroup(String name, String selection, String[] values, String[] labels, boolean required, boolean numberByValue, Form form) {
        super(name, selection, required, form);
        this.setLabelList(labels);
        this.setValueList(values);
        this.numberByValue = numberByValue;
    }

    public FormRadioButtonGroup(String name, String selection, String[] values, String[] labels, boolean required) {
        this(name, selection, values, labels, required, false);
    }

    public FormRadioButtonGroup(String name, String selection, String[] values, String[] labels, boolean required, Form form) {
        this(name, selection, values, labels, required, false, form);
    }

    public FormRadioButtonGroup(String name, String selection, String[] values, boolean required) {
        super(name, selection, required);
        this.setValueList(values);
    }

    public FormRadioButtonGroup(String name, String selection, String[] values, boolean required, Form form) {
        super(name, selection, required, form);
        this.setValueList(values);
    }

    public FormRadioButtonGroup(String name, String selection, String values, String labels, boolean required) {
        super(name, selection, required);
        this.setValueList(values);
        this.setLabelList(labels);
    }

    public FormRadioButtonGroup(String name, String selection, String values, String labels, boolean required, Form form) {
        super(name, selection, required, form);
        this.setValueList(values);
        this.setLabelList(labels);
    }

    public FormRadioButtonGroup(String name, String selection, String values, boolean required) {
        this(name, selection, values, DEFAULT_SELECTION, required);
    }

    public FormRadioButtonGroup(String name, String selection, String values, boolean required, Form form) {
        this(name, selection, values, DEFAULT_SELECTION, required, form);
    }

    public FormRadioButtonGroup(String name, String values, boolean required) {
        this(name, DEFAULT_SELECTION, values, required);
    }

    public FormRadioButtonGroup(String name, String values, boolean required, Form form) {
        this(name, DEFAULT_SELECTION, values, required, form);
    }

    public FormRadioButtonGroup(String name, String[] values, String[] labels, boolean required, Form form) {
        this(name, DEFAULT_SELECTION, values, labels, required, form);
    }

    public FormRadioButtonGroup(String name, String[] values, boolean required) {
        this(name, DEFAULT_SELECTION, values, required);
    }

    public FormRadioButtonGroup(String name, String[] values, boolean required, Form form) {
        this(name, DEFAULT_SELECTION, values, required, form);
    }

    public FormRadioButtonGroup(String name, String values) {
        this(name, DEFAULT_SELECTION, values, false);
    }

    public FormRadioButtonGroup(String name, String values, Form form) {
        this(name, DEFAULT_SELECTION, values, false, form);
    }

    public FormRadioButtonGroup(String name) {
        this(name, DEFAULT_SELECTION, DEFAULT_VALUES, false);
    }

    public FormRadioButtonGroup(String name, Form form) {
        this(name, DEFAULT_SELECTION, DEFAULT_VALUES, false, form);
    }

    public FormRadioButtonGroup(String name, String displayName, String values) {
        this(name, DEFAULT_SELECTION, values, false);
        this.setDisplayName(displayName);
    }

    public FormRadioButtonGroup(String name, String displayName, String values, Form form) {
        this(name, DEFAULT_SELECTION, values, false, form);
        this.setDisplayName(displayName);
    }

    public String getButtonID(int buttonNumber) {
        return String.valueOf(this.getName()) + "_" + (this.numberByValue ? this.values.get(buttonNumber) : Integer.toString(buttonNumber));
    }

    @Override
    public FormElement setValue(String selection) {
        if (!this.isReadOnly()) {
            this.selection = selection;
        }
        return this;
    }

    public void setValueList(String values) {
        StringTokenizer valueTokenizer = new StringTokenizer(values, ",");
        int tokens = valueTokenizer.countTokens();
        this.values = new ArrayList<String>(tokens);
        while (valueTokenizer.hasMoreTokens()) {
            this.values.add(valueTokenizer.nextToken().trim());
        }
    }

    public void setValueList(String[] values) {
        this.values = new ArrayList<String>(values.length);
        int i = 0;
        while (i < values.length) {
            this.values.add(values[i]);
            ++i;
        }
    }

    public void setValueList(Collection<String> values) {
        this.values = new ArrayList<String>(values);
    }

    public void setLabelList(String[] labels) {
        if (labels != null) {
            this.labels = new ArrayList<String>(labels.length);
            int i = 0;
            while (i < labels.length) {
                this.labels.add(labels[i]);
                ++i;
            }
        } else {
            this.setShowLabels(false);
        }
    }

    public void setLabelList(Collection<String> labels) {
        if (labels != null) {
            this.labels = new ArrayList<String>(labels);
        } else {
            this.setShowLabels(false);
        }
    }

    public void setLabelList(String values) {
        StringTokenizer valueTokenizer = new StringTokenizer(values, ",");
        int tokens = valueTokenizer.countTokens();
        this.labels = new ArrayList<String>(tokens);
        while (valueTokenizer.hasMoreTokens()) {
            this.labels.add(valueTokenizer.nextToken().trim());
        }
    }

    public String getLabel(int buttonNumber) {
        if (this.values != null && buttonNumber >= 0 && buttonNumber < this.values.size()) {
            if (this.labels != null && buttonNumber >= 0 && buttonNumber < this.labels.size()) {
                return this.labels.get(buttonNumber);
            }
            return this.values.get(buttonNumber);
        }
        return DEFAULT_SELECTION;
    }

    public String getValue(int buttonNumber) {
        if (this.values != null && buttonNumber >= 0 && buttonNumber < this.values.size()) {
            return this.values.get(buttonNumber);
        }
        return DEFAULT_SELECTION;
    }

    @Override
    public FormElement setValue(Context context) {
        this.setValue(context.query().get(this.getName(), this.selection));
        return this;
    }

    protected String getValue() {
        return this.selection;
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public String getRenderableValue() {
        return NetworkHelper.escapeStringForHtml(this.getValue());
    }

    @Override
    public String getEscapedValue() {
        return StringHelper.escapeSingleQuotes(this.getValue());
    }

    @Override
    public int getIntegerValue() {
        return NumberHelper.parseInt(this.selection);
    }

    public String[] getValueList() {
        String[] valuesAsArray = new String[this.values.size()];
        valuesAsArray = this.values.toArray(valuesAsArray);
        return valuesAsArray;
    }

    public List<String> getValuesList() {
        return this.values;
    }

    public List<String> getLabelsList() {
        return this.labels;
    }

    public int getValueCount() {
        return this.values.size();
    }

    @Override
    public String render() {
        return this.render(this.getStyle());
    }

    @Override
    public String render(String cssCode) {
        StringBuilder buffer = new StringBuilder(100);
        int i = 0;
        while (i < this.values.size()) {
            buffer.append(this.renderSingle(cssCode, i));
            ++i;
        }
        return buffer.toString();
    }

    public String renderSingle(String buttonValue) {
        int i = 0;
        while (i < this.values.size()) {
            String value = this.values.get(i);
            if (value.equals(buttonValue)) {
                return this.renderSingle(i);
            }
            ++i;
        }
        return DEFAULT_SELECTION;
    }

    public String renderSingle(int buttonNumber) {
        return this.renderSingle(this.getStyle(), buttonNumber);
    }

    public String renderSingle(String cssCode, int buttonNumber) {
        return this.renderSingle(cssCode, buttonNumber, this.showLabels);
    }

    public String renderSingle(String cssCode, int buttonNumber, boolean showLabel) {
        if (buttonNumber >= 0 && buttonNumber < this.values.size()) {
            String value = this.values.get(buttonNumber);
            StringBuilder buffer = new StringBuilder(100);
            buffer.append("<input type=\"radio\"");
            buffer.append(" id=\"" + this.getButtonID(buttonNumber) + "\"");
            buffer.append(" name=\"" + this.getName() + "\"");
            buffer.append(" value=\"" + NetworkHelper.escapeStringForHtml(value) + "\"");
            if (value.equals(this.getStringValue())) {
                buffer.append(" checked=\"checked\"");
            }
            buffer.append(this.renderTabIndex(buttonNumber));
            buffer.append(this.renderFormEvents());
            buffer.append(this.renderEnabled());
            buffer.append(this.renderStyle(cssCode));
            buffer.append(" />");
            if (showLabel) {
                buffer.append(this.renderSingleLabel(buttonNumber, true));
            }
            return buffer.toString();
        }
        return DEFAULT_SELECTION;
    }

    public String renderSingleLabel(int buttonNumber, boolean enableClickOnLabel) {
        return this.renderSingleLabel(DEFAULT_SELECTION, buttonNumber, enableClickOnLabel);
    }

    public String renderSingleLabel(String cssCode, int buttonNumber, boolean enableClickOnLabel) {
        if (enableClickOnLabel) {
            return "<label style=\"" + StringHelper.emptyDefault(cssCode, DEFAULT_SELECTION) + "\" for=\"" + this.getButtonID(buttonNumber) + "\">" + NetworkHelper.escapeStringForHtml(this.getLabel(buttonNumber)) + "</label>";
        }
        return NetworkHelper.escapeStringForHtml(this.getLabel(buttonNumber));
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        if (StringHelper.isEmpty(this.getValue())) {
            if (this.isRequired()) {
                String[] macros = new String[]{this.getDisplayName()};
                val.setError("gfrbg-empty-e", macros, "gfrbg-empty-i", macros, "gfrbg-empty-l", macros);
            }
        } else if (!this.getValuesList().contains(this.getValue())) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError("gfrbg-invalid-e", macros, "gfrbg-invalid-i", macros, "gfrbg-invalid-l", macros);
        }
    }

    public boolean isIncrementTabIndex() {
        return this.incrementTabIndex;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public boolean setIncrementTabIndex(boolean increment) {
        this.incrementTabIndex = increment;
        return this.incrementTabIndex;
    }

    private String renderTabIndex(int index) {
        if (this.isIncrementTabIndex() && this.getTabIndex() >= 0) {
            return " tabindex=\"" + (this.getTabIndex() + index) + "\" ";
        }
        return DEFAULT_SELECTION;
    }
}

