/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElement;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;

public class FormResetButton
extends FormElement {
    private String value;
    private static final String DEFAULT_VALUE = "";

    public FormResetButton(String name, String value) {
        super(name, value, false);
    }

    public FormResetButton(String name, String value, Form form) {
        super(name, value, false, form);
    }

    public FormResetButton(String name, Form form) {
        super(name, DEFAULT_VALUE, false, form);
    }

    protected String getValue() {
        return this.value;
    }

    @Override
    public String getEscapedValue() {
        return NetworkHelper.escapeStringForHtml(this.getValue());
    }

    @Override
    public String getRenderableValue() {
        return this.getEscapedValue();
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public String render() {
        return this.render(null);
    }

    @Override
    public String render(String cssCode) {
        StringBuilder sb = new StringBuilder();
        sb.append("<input type=\"reset\"");
        if (StringHelper.isNonEmpty(this.getName())) {
            sb.append(" name=\"");
            sb.append(this.getName());
            sb.append("\"");
        }
        if (StringHelper.isNonEmpty(this.getValue())) {
            sb.append(" value=\"");
            sb.append(NetworkHelper.escapeStringForHtml(this.getValue()));
            sb.append("\"");
        }
        if (StringHelper.isNonEmpty(cssCode)) {
            sb.append(" style=\"");
            sb.append(cssCode);
            sb.append("\"");
        }
        sb.append(" />");
        return sb.toString();
    }

    @Override
    public FormElement setValue(Context context) {
        return this;
    }

    @Override
    public FormElement setValue(String value) {
        this.value = value;
        return this;
    }
}

