/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.DateHelper;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;
import com.techempower.util.TimeZoneDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class FormSelect
extends FormElement {
    private final List<Element> elements = CollectionHelper.toList(new Element[0]);
    private List<String> values = CollectionHelper.toList(new String[0]);
    private boolean multiple = false;
    private int size = -1;
    private int count = 0;
    private String resourceNamePrefix = "gfs-";
    private static final TimeZoneNameComparator TIME_ZONE_NAME_COMPARATOR = new TimeZoneNameComparator();

    public FormSelect(String name) {
        super(name);
    }

    public FormSelect(String name, Form form) {
        super(name, form);
    }

    public FormSelect addValue(String value) {
        this.values.add(value);
        return this;
    }

    public FormSelect addValues(String ... valuesToAdd) {
        Collections.addAll(this.values, valuesToAdd);
        return this;
    }

    @Override
    public FormSelect setValue(String value) {
        this.values = value == null ? CollectionHelper.toList(new String[0]) : CollectionHelper.toList(value);
        return this;
    }

    public FormSelect setValue(int value) {
        this.values = CollectionHelper.toList("" + value);
        return this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public FormSelect setValues(String ... values) {
        this.values = CollectionHelper.toList(values);
        return this;
    }

    public FormSelect setValues(List<String> values) {
        this.values = values;
        return this;
    }

    @Override
    public FormSelect setValue(Context context) {
        if (this.isMultiple()) {
            String[] requestValues = context.query().getStrings(this.getName());
            if (requestValues == null) {
                this.setValues(new String[0]);
            } else {
                this.setValues(requestValues);
            }
        } else {
            String value = context.query().get(this.getName());
            if (value != null) {
                this.setValue(value);
            }
        }
        return this;
    }

    public int getOptionCount() {
        return this.count;
    }

    @Override
    public String getStringValue() {
        return StringHelper.join(",", this.values);
    }

    @Override
    public String getRenderableValue() {
        return NetworkHelper.escapeStringForHtml(this.getStringValue());
    }

    @Override
    public String getEscapedValue() {
        return this.getRenderableValue();
    }

    @Override
    public String render() {
        return this.render(null);
    }

    private void renderOption(Option option, StringBuilder out) {
        out.append("<option");
        out.append(" value=\"");
        out.append(NetworkHelper.escapeStringForHtml(option.value));
        out.append("\"");
        if (this.values.contains(option.value)) {
            out.append(" selected");
        }
        if (!option.isEnabled()) {
            out.append(" disabled");
        }
        out.append(">");
        if (StringHelper.isNonEmpty(option.label)) {
            out.append(NetworkHelper.escapeStringForHtml(option.label));
        }
        out.append("</option>");
    }

    @Override
    public String render(String cssCode) {
        int tabIndex;
        String id;
        String name;
        String className;
        StringBuilder out = new StringBuilder();
        String localCssCode = cssCode;
        out.append("<select");
        if (this.isMultiple()) {
            out.append(" multiple");
        }
        if (this.size >= 0) {
            out.append(" size=\"");
            out.append(this.size);
            out.append("\"");
        }
        if (!this.isEnabled()) {
            out.append(" disabled");
        }
        if (StringHelper.isEmpty(localCssCode)) {
            localCssCode = this.getStyle();
        }
        if (StringHelper.isNonEmpty(localCssCode)) {
            out.append(" style=\"");
            out.append(NetworkHelper.escapeStringForHtml(localCssCode));
            out.append("\"");
        }
        if (StringHelper.isNonEmpty(className = this.getClassName())) {
            out.append(" class=\"");
            out.append(NetworkHelper.escapeStringForHtml(className));
            out.append("\"");
        }
        if (StringHelper.isNonEmpty(name = this.getName())) {
            out.append(" name=\"");
            out.append(NetworkHelper.escapeStringForHtml(name));
            out.append("\"");
        }
        if (StringHelper.isEmpty(id = this.getId())) {
            id = name;
        }
        if (StringHelper.isNonEmpty(id)) {
            out.append(" id=\"");
            out.append(NetworkHelper.escapeStringForHtml(id));
            out.append("\"");
        }
        if ((tabIndex = this.getTabIndex()) >= 0) {
            out.append(" tabindex=\"");
            out.append(tabIndex);
            out.append("\"");
        }
        out.append(this.renderFormEvents());
        out.append(">");
        for (Element c : this.elements) {
            if (c instanceof Option) {
                Option o = (Option)c;
                this.renderOption(o, out);
                continue;
            }
            if (!(c instanceof OptGroup)) continue;
            OptGroup g = (OptGroup)c;
            out.append("<optgroup");
            if (StringHelper.isNonEmpty(g.label)) {
                out.append(" label=\"");
                out.append(NetworkHelper.escapeStringForHtml(g.label));
                out.append("\"");
            }
            if (!g.isEnabled()) {
                out.append(" disabled");
            }
            out.append(">");
            for (Option o : g.options) {
                this.renderOption(o, out);
            }
            out.append("</optgroup>");
        }
        out.append("</select>");
        return out.toString();
    }

    public Option addOption(int value) {
        return this.addOption("" + value);
    }

    public Option addOption(String value) {
        return this.addOption(value, value);
    }

    public Option addOption(int value, String label) {
        return this.addOption("" + value, label);
    }

    public Option addOption(String value, String label) {
        return this.addOption(new Option(value, label));
    }

    public Option addOption(Option option) {
        this.elements.add(option);
        ++this.count;
        return option;
    }

    public void removeAllOptions() {
        this.elements.clear();
        this.count = 0;
    }

    public Option insertOption(int index, Option option) {
        this.elements.add(index, option);
        ++this.count;
        return option;
    }

    public void addOptions(Option ... options) {
        Option[] optionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Option o = optionArray[n2];
            this.addOption(o);
            ++n2;
        }
    }

    public OptGroup addOptGroup(String label, Option ... options) {
        return this.addOptGroup(new OptGroup(label, options));
    }

    public OptGroup addOptGroup(OptGroup optGroup) {
        this.elements.add(optGroup);
        this.count += optGroup.options.size();
        return optGroup;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public FormSelect setMultiple(boolean multiple) {
        this.multiple = multiple;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public FormSelect setSize(int size) {
        this.size = size;
        return this;
    }

    protected String getResourceNamePrefix() {
        return this.resourceNamePrefix;
    }

    public FormSelect setResourceNamePrefix(String resourceNamePrefix) {
        this.resourceNamePrefix = resourceNamePrefix;
        return this;
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        if (this.isRequired() && (CollectionHelper.isEmpty(this.values) || this.values.size() == 1 && StringHelper.isEmpty(this.values.get(0)))) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError(String.valueOf(this.getResourceNamePrefix()) + "empty-e", macros, String.valueOf(this.getResourceNamePrefix()) + "empty-i", macros, String.valueOf(this.getResourceNamePrefix()) + "empty-l", macros);
            return;
        }
        Set<String> validValues = CollectionHelper.toSet(new String[0]);
        for (Element element : this.elements) {
            OptGroup g;
            if (element instanceof Option) {
                Option o = (Option)element;
                if (!o.isEnabled()) continue;
                validValues.add(o.value);
                continue;
            }
            if (!(element instanceof OptGroup) || !(g = (OptGroup)element).isEnabled()) continue;
            for (Option o : g.options) {
                if (!o.isEnabled()) continue;
                validValues.add(o.value);
            }
        }
        for (String value : this.values) {
            if (validValues.contains(value)) continue;
            String[] macros = new String[]{this.getDisplayName()};
            val.setError(String.valueOf(this.getResourceNamePrefix()) + "invalid-e", macros, String.valueOf(this.getResourceNamePrefix()) + "invalid-i", macros, String.valueOf(this.getResourceNamePrefix()) + "invalid-l", macros);
            return;
        }
    }

    public <T> FormSelect addOptionsFromReflection(Class<T> clazz, Collection<T> objects, String valueMethodName, String labelMethodName) {
        try {
            Method valueMethod = clazz.getMethod(valueMethodName, new Class[0]);
            Method labelMethod = clazz.getMethod(labelMethodName, new Class[0]);
            for (T o : objects) {
                Object value = valueMethod.invoke(o, new Object[0]);
                Object label = labelMethod.invoke(o, new Object[0]);
                this.addOption(value == null ? null : String.valueOf(value), label == null ? null : String.valueOf(label));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public FormSelect addOptionsFromResources(Context context, String prefix) {
        String[] resourcedValues = context.getResources().get(String.valueOf(prefix) + "-value").split(",");
        String[] resourcedLabels = context.getResources().get(String.valueOf(prefix) + "-display").split("#");
        int length = Math.min(resourcedValues.length, resourcedLabels.length);
        int i = 0;
        while (i < length) {
            this.addOption(resourcedValues[i], resourcedLabels[i]);
            ++i;
        }
        return this;
    }

    public FormSelect addOptionsForCountry(Context context) {
        this.addOptionsFromResources(context, "gfddmc");
        return this;
    }

    public FormSelect addOptionsForCountryUsFirst(Context context) {
        this.addOptionsFromResources(context, "gfddmcusf");
        return this;
    }

    public FormSelect addOptionsForMonth(Context context) {
        this.addOptionsFromResources(context, "gfddmm");
        return this;
    }

    public FormSelect addOptionsForState(Context context) {
        this.addOptionsFromResources(context, "gfddms");
        return this;
    }

    public FormSelect addOptionsForStateOrProvince(Context context) {
        this.addOptionsFromResources(context, "gfddms+c");
        return this;
    }

    public FormSelect addOptionsForTimeZone(TimeZoneDescriptor ... timeZones) {
        TimeZoneDescriptor[] timeZoneDescriptorArray = timeZones;
        int n = timeZones.length;
        int n2 = 0;
        while (n2 < n) {
            TimeZoneDescriptor tzd = timeZoneDescriptorArray[n2];
            this.addOption(tzd.getIndex(), tzd.getDescription());
            ++n2;
        }
        return this;
    }

    public FormSelect addOptionsForTimeZone(String ... timeZoneIds) {
        Set<String> displayNames = CollectionHelper.toSet(new String[0]);
        String[] localTimeZoneIds = timeZoneIds;
        if (StringHelper.isEmpty(localTimeZoneIds)) {
            localTimeZoneIds = TimeZone.getAvailableIDs();
        }
        ArrayList<TimeZone> timeZones = new ArrayList<TimeZone>(localTimeZoneIds.length);
        int i = 0;
        while (i < localTimeZoneIds.length) {
            String displayName;
            TimeZone timeZone = TimeZone.getTimeZone(localTimeZoneIds[i]);
            if (timeZone != null && !displayNames.contains(displayName = timeZone.getDisplayName(timeZone.inDaylightTime(new Date()), 1))) {
                timeZones.add(timeZone);
                displayNames.add(displayName);
            }
            ++i;
        }
        Collections.sort(timeZones, TIME_ZONE_NAME_COMPARATOR);
        for (TimeZone timeZone : timeZones) {
            this.addOption("" + timeZone.getRawOffset(), timeZone.getDisplayName());
        }
        return this;
    }

    public FormSelect addOptionsForYear(int negativeDelta, int positiveDelta) {
        int currentYear = DateHelper.getCalendarInstance().get(1);
        int maxValue = currentYear + positiveDelta;
        int minValue = currentYear - negativeDelta;
        int length = maxValue - minValue + 1;
        int i = 0;
        while (i < length) {
            this.addOption("" + (minValue + i));
            ++i;
        }
        return this;
    }

    public FormSelect addOptionsFromArray(int ... valuesToAdd) {
        this.addOptionsFromArray(CollectionHelper.toStringArray(valuesToAdd));
        return this;
    }

    public FormSelect addOptionsFromArray(String ... valuesToAdd) {
        this.addOptionsFromArray(valuesToAdd, valuesToAdd);
        return this;
    }

    public FormSelect addOptionsFromArray(String[] valuesToAdd, String[] labels) {
        int length = Math.min(valuesToAdd.length, labels.length);
        int i = 0;
        while (i < length) {
            this.addOption(valuesToAdd[i], labels[i]);
            ++i;
        }
        return this;
    }

    public FormSelect addOptionsFromArray(int[] valuesToAdd, String[] labels) {
        this.addOptionsFromArray(CollectionHelper.toStringArray(valuesToAdd), labels);
        return this;
    }

    public FormSelect addOptionsFromCollection(Collection<String> valuesToAdd) {
        this.addOptionsFromCollection(valuesToAdd, valuesToAdd);
        return this;
    }

    public FormSelect addOptionsFromCollection(Collection<String> valuesToAdd, Collection<String> labels) {
        int length = Math.min(valuesToAdd.size(), labels.size());
        Iterator<String> valuesIterator = valuesToAdd.iterator();
        Iterator<String> labelsIterator = labels.iterator();
        int i = 0;
        while (i < length) {
            this.addOption(new Option(valuesIterator.next(), labelsIterator.next()));
            ++i;
        }
        return this;
    }

    public FormSelect addOptionsFromMap(Map<String, String> options) {
        for (Map.Entry<String, String> entry : options.entrySet()) {
            this.addOption(new Option(entry.getValue(), entry.getKey()));
        }
        return this;
    }

    public static interface Element {
    }

    public static class OptGroup
    implements Element {
        private final String label;
        private final List<Option> options;
        private boolean enabled = true;

        public OptGroup(String label, Option ... options) {
            this.label = label;
            this.options = CollectionHelper.toList(options);
        }

        public Option addOption(int value) {
            return this.addOption("" + value);
        }

        public Option addOption(String value) {
            return this.addOption(value, value);
        }

        public Option addOption(int value, String labelText) {
            return this.addOption("" + value, labelText);
        }

        public Option addOption(String value, String labelText) {
            return this.addOption(new Option(value, labelText));
        }

        public Option addOption(Option option) {
            this.options.add(option);
            return option;
        }

        public void addOptions(Option ... optionsToAdd) {
            Option[] optionArray = optionsToAdd;
            int n = optionsToAdd.length;
            int n2 = 0;
            while (n2 < n) {
                Option o = optionArray[n2];
                this.addOption(o);
                ++n2;
            }
        }

        public OptGroup setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class Option
    implements Element {
        private String value;
        private String label;
        private boolean enabled = true;

        public Option(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Option setEnabled(boolean enabled) {
            this.enabled = true;
            return this;
        }
    }

    static final class TimeZoneNameComparator
    implements Comparator<TimeZone> {
        TimeZoneNameComparator() {
        }

        @Override
        public int compare(TimeZone o1, TimeZone o2) {
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        }
    }
}

