/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormIntegerField;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.StringHelper;

public class FormSocialSecurityNumber
extends FormElement {
    public static final int FIELD_FIRST = 0;
    public static final int FIELD_SECOND = 1;
    public static final int FIELD_THIRD = 2;
    private static final String AUTO_TAB_JAVASCRIPT = "if(this.value.length == this.maxLength && (event.keyCode != 9) && (event.keyCode != 16)){this.form['NEXT_FORM_ELEMENT_NAME'].focus();}";
    private static final String FIRST_FE_SUFFIX = "-gfssn-first";
    private static final String SECOND_FE_SUFFIX = "-gfssn-second";
    private static final String THIRD_FE_SUFFIX = "-gfssn-third";
    private FormIntegerField first;
    private FormIntegerField second;
    private FormIntegerField third;

    public FormSocialSecurityNumber(String name, String value, boolean required) {
        super(name, value, required);
        this.init(name, value, required);
    }

    public FormSocialSecurityNumber(String name, String value, boolean required, Form form) {
        super(name, value, required, form);
        this.init(name, value, required);
    }

    public FormSocialSecurityNumber(String name, boolean required) {
        this(name, "", required);
    }

    public FormSocialSecurityNumber(String name, boolean required, Form form) {
        this(name, "", required, form);
    }

    public FormSocialSecurityNumber(String name) {
        this(name, "", false);
    }

    public FormSocialSecurityNumber(String name, Form form) {
        this(name, "", false, form);
    }

    private void init(String name, String value, boolean required) {
        String feName = String.valueOf(name) + FIRST_FE_SUFFIX;
        this.first = new FormIntegerField(feName, required, 3);
        this.first.setMinLength(3);
        this.first.setMaxLength(3);
        this.first.useTypeText();
        this.first.addRule("digits", true);
        feName = String.valueOf(name) + SECOND_FE_SUFFIX;
        this.second = new FormIntegerField(feName, required, 2);
        this.second.setMinLength(2);
        this.second.setMaxLength(2);
        this.second.useTypeText();
        this.second.addRule("digits", true);
        feName = String.valueOf(name) + THIRD_FE_SUFFIX;
        this.third = new FormIntegerField(feName, required, 4);
        this.third.setMinLength(4);
        this.third.setMaxLength(4);
        this.third.useTypeText();
        this.third.addRule("digits", true);
        this.setDisplayName(name);
        this.setValue(value);
    }

    @Override
    public FormSocialSecurityNumber setValue(String value) {
        if (!this.isReadOnly() && StringHelper.isNonEmpty(value)) {
            String removeDashes = StringHelper.stripNonNumeric(value);
            this.first.setValue(removeDashes.substring(0, 3));
            this.second.setValue(removeDashes.substring(3, 5));
            this.third.setValue(removeDashes.substring(5, 9));
        }
        return this;
    }

    @Override
    public FormSocialSecurityNumber setValue(Context context) {
        this.first.setValue(context);
        this.second.setValue(context);
        this.third.setValue(context);
        return this;
    }

    @Override
    public String getStringValue() {
        String value = "";
        if (StringHelper.isNonEmpty(this.first.getStringValue())) {
            value = String.valueOf(value) + this.first.getStringValue();
        }
        if (StringHelper.isNonEmpty(this.second.getStringValue())) {
            value = String.valueOf(value) + this.second.getStringValue();
        }
        if (StringHelper.isNonEmpty(this.third.getStringValue())) {
            value = String.valueOf(value) + this.third.getStringValue();
        }
        return value;
    }

    @Override
    public String getRenderableValue() {
        return String.valueOf(this.first.getRenderableValue()) + this.second.getRenderableValue() + this.third.getRenderableValue();
    }

    @Override
    public String getEscapedValue() {
        return String.valueOf(this.first.getEscapedValue()) + this.second.getEscapedValue() + this.third.getEscapedValue();
    }

    @Override
    public String render() {
        return this.render(this.getStyle());
    }

    @Override
    public String render(String cssCode) {
        StringBuilder buffer = new StringBuilder(180);
        buffer.append(this.first.render(cssCode));
        buffer.append(this.second.render(cssCode));
        buffer.append(this.third.render(cssCode));
        return buffer.toString();
    }

    public String renderSingle(int fieldNumber) {
        return this.renderSingle("", fieldNumber);
    }

    public String renderSingle(String cssStyle, int fieldNumber) {
        switch (fieldNumber) {
            case 0: {
                return this.first.render(cssStyle);
            }
            case 1: {
                return this.second.render(cssStyle);
            }
            case 2: {
                return this.third.render(cssStyle);
            }
        }
        return "";
    }

    @Override
    public FormSocialSecurityNumber setDisplayName(String displayName) {
        super.setDisplayName(displayName);
        this.setDisplayName(0, displayName);
        this.setDisplayName(1, displayName);
        this.setDisplayName(2, displayName);
        return this;
    }

    public void setDisplayName(int field, String displayName) {
        switch (field) {
            case 0: {
                this.first.setDisplayName(displayName);
                break;
            }
            case 1: {
                this.second.setDisplayName(displayName);
                break;
            }
            case 2: {
                this.third.setDisplayName(displayName);
                break;
            }
        }
    }

    public void addAutoTabJavascript() {
        String javascript = AUTO_TAB_JAVASCRIPT.replaceAll("NEXT_FORM_ELEMENT_NAME", this.second.getName());
        this.first.addFormEvent("onKeyUp", javascript);
        this.first.addFormEvent("onFocus", "this.select()");
        javascript = AUTO_TAB_JAVASCRIPT.replaceAll("NEXT_FORM_ELEMENT_NAME", this.third.getName());
        this.second.addFormEvent("onKeyUp", javascript);
        this.second.addFormEvent("onFocus", "this.select()");
        this.third.addFormEvent("onFocus", "this.select()");
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        this.first.requiredValidation(val);
        this.second.requiredValidation(val);
        this.third.requiredValidation(val);
        if (val.isError()) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError("gfssn-missing-e", macros, "gfssn-missing-i", macros, "gfssn-missing-l", macros);
        }
    }

    @Override
    public void addFormEvent(String event, String action) {
        this.first.addFormEvent(event, action);
        this.second.addFormEvent(event, action);
        this.third.addFormEvent(event, action);
    }

    @Override
    public FormSocialSecurityNumber setTabIndex(int order) {
        super.setTabIndex(order);
        if (this.getTabIndex() >= 0) {
            this.first.setTabIndex(this.getTabIndex());
            this.second.setTabIndex(this.getTabIndex() + 1);
            this.third.setTabIndex(this.getTabIndex() + 2);
        }
        return this;
    }

    @Override
    public FormSocialSecurityNumber setAutocompleteDisabled(boolean autocompleteDisabled) {
        super.setAutocompleteDisabled(autocompleteDisabled);
        this.first.setAutocompleteDisabled(autocompleteDisabled);
        this.second.setAutocompleteDisabled(autocompleteDisabled);
        this.third.setAutocompleteDisabled(autocompleteDisabled);
        return this;
    }
}

