/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import com.techempower.js.JavaScriptWriter;

public class FormTextField
extends FormElement {
    public static final int DEFAULT_LENGTH = 20;
    public static final String DEFAULT_VALUE = "";
    private String value;
    private int length;
    private int maxLength;
    private int minLength;
    private String placeholder = "";
    private String type = "text";
    private String list = "";
    private String pattern = "";
    private String xmozerrormessage = "";
    private String results = "";

    public FormTextField(String displayName, String name, String value, boolean required, int length, int maxLength) {
        super(name, value, required);
        if (displayName != null) {
            this.setDisplayName(displayName);
        }
        this.setLength(length);
        this.setMaxLength(maxLength);
        this.setMinLength(0);
    }

    public FormTextField(String displayName, String name, String value, boolean required, int length, int maxLength, Form form) {
        super(name, value, required, form);
        if (displayName != null) {
            this.setDisplayName(displayName);
        }
        this.setLength(length);
        this.setMaxLength(maxLength);
        this.setMinLength(0);
    }

    public FormTextField(String name, String value, boolean required, int length, int maxLength) {
        this(null, name, value, required, length, maxLength);
    }

    public FormTextField(String name, String value, boolean required, int length, int maxLength, Form form) {
        this(null, name, value, required, length, maxLength, form);
    }

    public FormTextField(String name, String value, boolean required, int length) {
        this(null, name, value, required, length, length);
    }

    public FormTextField(String name, String value, boolean required, int length, Form form) {
        this(null, name, value, required, length, length, form);
    }

    public FormTextField(String name, boolean required, int length, int maxLength) {
        this(null, name, DEFAULT_VALUE, required, length, maxLength);
    }

    public FormTextField(String name, boolean required, int length, int maxLength, Form form) {
        this(null, name, DEFAULT_VALUE, required, length, maxLength, form);
    }

    public FormTextField(String name, boolean required, int length) {
        this(null, name, DEFAULT_VALUE, required, length, length);
    }

    public FormTextField(String name, boolean required, int length, Form form) {
        this(null, name, DEFAULT_VALUE, required, length, length, form);
    }

    public FormTextField(String name, int length) {
        this(null, name, DEFAULT_VALUE, false, length, length);
    }

    public FormTextField(String name, int length, Form form) {
        this(null, name, DEFAULT_VALUE, false, length, length, form);
    }

    public FormTextField(String name) {
        this(null, name, DEFAULT_VALUE, false, 20, 20);
    }

    public FormTextField(String name, Form form) {
        this(null, name, DEFAULT_VALUE, false, 20, 20, form);
    }

    public FormTextField setLength(int length) {
        this.length = length;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public FormTextField setValue(String value) {
        if (!this.isReadOnly()) {
            this.value = value == null ? DEFAULT_VALUE : value;
        }
        return this;
    }

    @Override
    public FormTextField setValue(Context context) {
        this.setValue(context.query().get(this.getName(), this.value));
        return this;
    }

    protected String getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public String getRenderableValue() {
        return NetworkHelper.escapeStringForHtml(this.getValue());
    }

    @Override
    public String getEscapedValue() {
        return StringHelper.escapeSingleQuotes(this.getValue());
    }

    @Override
    public int getIntegerValue() {
        if (this.value != null) {
            return NumberHelper.parseInt(this.value.trim());
        }
        return 0;
    }

    @Override
    public String render() {
        return this.render(this.getStyle());
    }

    @Override
    public String render(String cssCode) {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append("<input type=\"");
        buffer.append(this.getType());
        buffer.append("\"");
        buffer.append(this.renderClassName());
        buffer.append(" name=\"");
        buffer.append(this.getName());
        buffer.append("\" value=\"");
        buffer.append(this.getRenderableValue());
        buffer.append("\" size=\"");
        buffer.append(this.getLength());
        if (StringHelper.isNonEmptyTrimmed(this.getPlaceholder())) {
            buffer.append("\" placeholder=\"");
            buffer.append(this.getRenderablePlaceholder());
        }
        if (this.isRequired() && this.isUsingHTML5Forms() && this.isValidationEnabled()) {
            buffer.append("\" required=\"required");
        }
        if (this.isAutofocus()) {
            buffer.append("\" autofocus=\"autofocus");
        }
        buffer.append("\" maxlength=\"");
        buffer.append(this.getMaxLength());
        buffer.append('\"');
        if (this.isUsingClientSideValidation()) {
            buffer.append(" data-validate='");
            buffer.append(this.renderParameterizedValidationRules());
            buffer.append('\'');
        }
        buffer.append(this.renderTabIndex());
        buffer.append(this.renderFormEvents());
        buffer.append(this.renderEnabled());
        buffer.append(this.renderReadOnly());
        buffer.append(this.renderAutocompleteDisabled());
        buffer.append(this.renderListString());
        buffer.append(this.renderResultsString());
        if (this.isUsingHTML5Forms() && this.isValidationEnabled()) {
            buffer.append(this.renderPatternString());
            buffer.append(this.renderXMozErrorMessageString());
        }
        buffer.append(this.renderId());
        buffer.append(this.renderStyle(cssCode));
        buffer.append("/>");
        return buffer.toString();
    }

    protected String renderParameterizedValidationRules() {
        return this.getRules() == null ? "{}" : JavaScriptWriter.standard().write(this.getRules());
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public FormTextField setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public String getRenderablePlaceholder() {
        return NetworkHelper.escapeStringForHtml(this.getPlaceholder());
    }

    protected String getResourceNamePrefix() {
        return "gftf-";
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        if (this.isRequired() && this.getStringValue().length() == 0) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError(String.valueOf(this.getResourceNamePrefix()) + "empty-e", macros, String.valueOf(this.getResourceNamePrefix()) + "empty-i", macros, String.valueOf(this.getResourceNamePrefix()) + "empty-l", macros);
        } else if (this.getStringValue().length() > 0 && this.getStringValue().length() < this.getMinLength()) {
            String[] macros = new String[]{this.getDisplayName(), DEFAULT_VALUE + this.getMinLength()};
            val.setError(String.valueOf(this.getResourceNamePrefix()) + "short-e", macros, String.valueOf(this.getResourceNamePrefix()) + "short-i", macros, String.valueOf(this.getResourceNamePrefix()) + "short-l", macros);
        } else if (this.getStringValue().length() > this.getMaxLength()) {
            String[] macros = new String[]{this.getDisplayName(), DEFAULT_VALUE + this.getMaxLength()};
            val.setError(String.valueOf(this.getResourceNamePrefix()) + "long-e", macros, String.valueOf(this.getResourceNamePrefix()) + "long-i", macros, String.valueOf(this.getResourceNamePrefix()) + "long-l", macros);
        }
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public FormTextField setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.getMinLength() > 0) {
            this.addRule("maxlength", maxLength);
        }
        return this;
    }

    public FormTextField setMinLength(int minLength) {
        this.minLength = minLength;
        if (this.getMinLength() > 0) {
            this.addRule("minlength", minLength);
        }
        return this;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public String getType() {
        return this.type;
    }

    public FormTextField useTypeText() {
        this.type = "text";
        return this;
    }

    public FormTextField useTypeSearch() {
        this.type = "search";
        return this;
    }

    public String getList() {
        return this.list;
    }

    public FormTextField setList(String list) {
        this.list = list;
        return this;
    }

    protected String renderListString() {
        if (StringHelper.isEmptyTrimmed(this.getList())) {
            return DEFAULT_VALUE;
        }
        return " list=\"" + this.getList() + '\"';
    }

    public String getPattern() {
        return this.pattern;
    }

    public FormTextField setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    protected String renderPatternString() {
        if (StringHelper.isEmptyTrimmed(this.getPattern())) {
            return DEFAULT_VALUE;
        }
        return " pattern=\"" + this.getPattern() + '\"';
    }

    public String getXmozerrormessage() {
        return this.xmozerrormessage;
    }

    public FormTextField setXmozerrormessage(String xmozerrormessage) {
        this.xmozerrormessage = xmozerrormessage;
        return this;
    }

    protected String renderXMozErrorMessageString() {
        if (StringHelper.isEmptyTrimmed(this.getXmozerrormessage())) {
            return DEFAULT_VALUE;
        }
        return " x-moz-errormessage=\"" + this.getXmozerrormessage() + '\"';
    }

    public String getResults() {
        return this.results;
    }

    public FormTextField setResults(String results) {
        this.results = results;
        return this;
    }

    public FormTextField setResults(int results) {
        this.results = DEFAULT_VALUE + results;
        return this;
    }

    protected String renderResultsString() {
        if (StringHelper.isEmptyTrimmed(this.getResults())) {
            return DEFAULT_VALUE;
        }
        return " results=\"" + this.getResults() + '\"';
    }
}

