/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormFloatField;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class FormUSDollarField
extends FormFloatField {
    public static final float MINIMUM = 0.0f;
    public static final float MAXIMUM = 1.0E9f;
    public static final int TEXT_LENGTH = 12;
    private static final String[] FINDS = new String[]{",", "$"};
    private static final String[] REPLACES = new String[]{"", ""};
    private static final NumberFormat US_DOLLAR_FORMATTER = new DecimalFormat("#,##0.00;-#,##0.00");

    public FormUSDollarField(String name, String value, boolean required, float min, float max, int length, int maxLength) {
        super(name, value, required, min, max, length, maxLength);
    }

    public FormUSDollarField(String name, String value, boolean required, float min, float max, int length, int maxLength, Form form) {
        super(name, value, required, min, max, length, maxLength, form);
    }

    public FormUSDollarField(String name, String value, boolean required, float min, float max, int length) {
        this(name, value, required, min, max, length, length);
    }

    public FormUSDollarField(String name, String value, boolean required, float min, float max, int length, Form form) {
        this(name, value, required, min, max, length, length, form);
    }

    public FormUSDollarField(String name, String value, boolean required, float min, float max) {
        this(name, value, required, min, max, 12);
    }

    public FormUSDollarField(String name, String value, boolean required, float min, float max, Form form) {
        this(name, value, required, min, max, 12, form);
    }

    public FormUSDollarField(String name, String value, float min, float max) {
        this(name, value, false, min, max, 12);
    }

    public FormUSDollarField(String name, String value, float min, float max, Form form) {
        this(name, value, false, min, max, 12, form);
    }

    public FormUSDollarField(String name, float min, float max) {
        this(name, "", false, min, max, 12);
    }

    public FormUSDollarField(String name, float min, float max, Form form) {
        this(name, "", false, min, max, 12, form);
    }

    public FormUSDollarField(String name, boolean required, int length) {
        this(name, "", required, 0.0f, 1.0E9f, length);
    }

    public FormUSDollarField(String name, boolean required, int length, Form form) {
        this(name, "", required, 0.0f, 1.0E9f, length, form);
    }

    public FormUSDollarField(String name, boolean required, int length, int maxLength) {
        this(name, "", required, 0.0f, 1.0E9f, length, maxLength);
    }

    public FormUSDollarField(String name, boolean required, int length, int maxLength, Form form) {
        this(name, "", required, 0.0f, 1.0E9f, length, maxLength, form);
    }

    public FormUSDollarField(String name) {
        this(name, "", false, 0.0f, 1.0E9f, 12);
    }

    public FormUSDollarField(String name, Form form) {
        this(name, "", false, 0.0f, 1.0E9f, 12, form);
    }

    @Override
    public FormUSDollarField setValue(String value) {
        if (!this.isReadOnly()) {
            super.setValue(StringHelper.replaceSubstrings(value, FINDS, REPLACES));
        }
        return this;
    }

    @Override
    public String getRenderableValue() {
        if (this.getValue().length() == 0) {
            return "";
        }
        String toReturn = "$" + this.renderAsDollars(this.getFloatValue());
        return NetworkHelper.escapeStringForHtml(toReturn);
    }

    @Override
    public String getStringValue() {
        if (this.getValue().length() == 0) {
            return "";
        }
        return "$" + this.renderAsDollars(this.getFloatValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderAsDollars(float value) {
        NumberFormat numberFormat = US_DOLLAR_FORMATTER;
        synchronized (numberFormat) {
            return US_DOLLAR_FORMATTER.format(value);
        }
    }

    @Override
    public String getMaximumAsString() {
        return "$" + this.renderAsDollars(this.getMaximum());
    }

    @Override
    public String getMinimumAsString() {
        return "$" + this.renderAsDollars(this.getMinimum());
    }

    @Override
    protected void addClientSideValidationClasses() {
        super.addClientSideValidationClasses();
        this.removeClassName("number");
    }

    @Override
    public String getType() {
        return "text";
    }
}

