/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormTextField;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;

public class FormUsernameField
extends FormTextField {
    public static final int DEFAULT_MINIMUM_LENGTH = 4;
    private UsernameFormat format = UsernameFormat.NORMAL;

    public FormUsernameField(String displayName, String name, String value, boolean required, int minLength, int length, int maxLength) {
        super(displayName, name, value, required, length, maxLength);
        this.setMinLength(minLength);
    }

    public FormUsernameField(String displayName, String name, String value, boolean required, int minLength, int length, int maxLength, Form form) {
        super(displayName, name, value, required, length, maxLength, form);
        this.setMinLength(minLength);
    }

    public FormUsernameField(String name, String value, boolean required, int minLength, int length, int maxLength) {
        this(null, name, value, required, minLength, length, maxLength);
    }

    public FormUsernameField(String name, String value, boolean required, int minLength, int length, int maxLength, Form form) {
        this(null, name, value, required, minLength, length, maxLength, form);
    }

    public FormUsernameField(String name, String value, boolean required, int minLength, int length) {
        this(null, name, value, required, minLength, length, length);
    }

    public FormUsernameField(String name, String value, boolean required, int minLength, int length, Form form) {
        this(null, name, value, required, minLength, length, length, form);
    }

    public FormUsernameField(String name, boolean required, int minLength, int length, int maxLength) {
        this(null, name, "", required, minLength, length, maxLength);
    }

    public FormUsernameField(String name, boolean required, int minLength, int length, int maxLength, Form form) {
        this(null, name, "", required, minLength, length, maxLength, form);
    }

    public FormUsernameField(String name, boolean required, int minLength, int length) {
        this(null, name, "", required, minLength, length, length);
    }

    public FormUsernameField(String name, boolean required, int minLength, int length, Form form) {
        this(null, name, "", required, minLength, length, length, form);
    }

    public FormUsernameField(String name, int minLength, int length) {
        this(null, name, "", false, length, minLength, length);
    }

    public FormUsernameField(String name, int minLength, int length, Form form) {
        this(null, name, "", false, length, minLength, length, form);
    }

    public FormUsernameField(String name, int minLength) {
        this(null, name, "", false, minLength, 20, 20);
    }

    public FormUsernameField(String name, int minLength, Form form) {
        this(null, name, "", false, minLength, 20, 20, form);
    }

    public FormUsernameField setUsernameFormat(UsernameFormat format) {
        this.format = format;
        return this;
    }

    public UsernameFormat getUsernameFormat() {
        return this.format;
    }

    @Override
    public FormTextField setValue(String value) {
        return super.setValue(value == null ? null : value.toLowerCase());
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        super.requiredValidation(val);
        if (!val.isSet() && (this.getValue().length() > 0 || this.isRequired())) {
            String value = this.getStringValue();
            if (value.length() < this.getMinLength()) {
                String[] macros = new String[]{this.getDisplayName(), "" + this.getMinLength()};
                val.setError("gfuf-short-e", macros, "gfuf-short-i", macros, "gfuf-short-l", macros);
            } else {
                boolean valid = false;
                if ((this.format == UsernameFormat.EMAIL || this.format == UsernameFormat.BOTH) && (valid = NetworkHelper.validateHTML5EmailAddress(value))) {
                    return;
                }
                if (this.format == UsernameFormat.NORMAL || this.format == UsernameFormat.BOTH) {
                    valid = StringHelper.isAllAlphaNumeric(value);
                }
                if (!valid) {
                    String[] macros = new String[]{this.getDisplayName()};
                    val.setError("gfuf-badchars-e", macros, "gfuf-badchars-i", macros, "gfuf-badchars-l", macros);
                }
            }
        }
    }

    public static enum UsernameFormat {
        NORMAL,
        EMAIL,
        BOTH;

    }
}

