/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form.validator;

import com.techempower.cache.EntityStore;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormElementValidator;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.StringHelper;
import com.techempower.util.Identifiable;

public class CacheUniquenessValidator
implements FormElementValidator {
    private final Class<? extends Identifiable> cachedClass;
    private final String methodName;
    private final Object self;
    private final EntityStore store;

    public <T extends Identifiable> CacheUniquenessValidator(EntityStore store, Class<T> cachedClass, String methodName, Object selfReference) {
        this.store = store;
        this.cachedClass = cachedClass;
        this.methodName = methodName;
        this.self = selfReference;
    }

    @Override
    public void validate(FormElement element, FormSingleValidation val) {
        String value = element.getStringValue();
        if (StringHelper.isNonEmpty(value)) {
            Identifiable found = this.store.get(this.cachedClass, this.methodName, value);
            if (this.self != null && found != this.self && found != null || this.self == null && found != null) {
                val.setRawError(String.valueOf(element.getName()) + " needs to have a unique value.", "The value provided in " + element.getDisplayName() + " is already in use, please try another.", "This value is already in use, please try another.");
            }
        }
    }
}

