/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form.validator;

import com.techempower.gemini.Context;
import com.techempower.gemini.RequestFile;
import com.techempower.gemini.form.FormCsvFileBrowse;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormElementValidator;
import com.techempower.gemini.form.FormFileBrowse;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.StringHelper;
import com.techempower.io.csv.CsvReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class CsvValidator
implements FormElementValidator {
    private final Context context;

    public <C extends Context> CsvValidator(C context) {
        this.context = context;
    }

    protected <C extends Context> C getContext() {
        return (C)this.context;
    }

    @Override
    public void validate(FormElement element, FormSingleValidation val) {
        byte[] file;
        if (!(element instanceof FormFileBrowse)) {
            throw new RuntimeException("Element is not a file input type.");
        }
        String error = "";
        RequestFile requestFile = this.context.files().get(element.getName());
        if (requestFile == null) {
            file = new byte[]{};
        } else {
            try {
                file = requestFile.getContentAsBytes();
            }
            catch (IOException e) {
                file = new byte[]{};
            }
        }
        if (file.length == 0) {
            if (element.isRequired()) {
                error = "An error occurred, please try again later.";
                val.setRawError(error, error, error);
            }
        } else {
            Throwable throwable = null;
            Object var7_9 = null;
            try (CsvReader csvr = ((FormCsvFileBrowse)element).getCsvReader();){
                if (csvr != null) {
                    List<String> cols = Arrays.asList(csvr.getColumns());
                    if (cols.size() == 0) {
                        error = "There are no columns in the CSV.";
                        val.setRawError(error, error, error);
                    }
                    for (String col : cols) {
                        if (!StringHelper.isEmptyTrimmed(col)) continue;
                        error = "Headers values may not be empty.";
                        val.setRawError(error, error, error);
                    }
                } else if (element.isRequired()) {
                    error = "An error occurred trying to parse the CSV.";
                    val.setRawError(error, error, error);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

