/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form.validator;

import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormElementValidator;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.PyxisUser;
import java.util.Objects;

public class PasswordAuthenticationValidator
implements FormElementValidator {
    private final PyxisUser user;
    private final PyxisSecurity security;

    public PasswordAuthenticationValidator(PyxisSecurity security, PyxisUser user) {
        Objects.requireNonNull(security, "Security reference not provided.");
        Objects.requireNonNull(user, "User reference not provided.");
        this.user = user;
        this.security = security;
    }

    @Override
    public void validate(FormElement element, FormSingleValidation val) {
        String providedPassword = element.getStringValue();
        if (!this.security.passwordTest(this.user, providedPassword)) {
            String[] macros = new String[]{val.getElement().getDisplayName()};
            val.setError("gfpav-badpassword-e", macros, "gfpav-badpassword-i", macros, "gfpav-badpassword-l", macros);
        }
    }
}

