/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form.validator;

import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormElementValidator;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.StringHelper;

public class StreetValidator
implements FormElementValidator {
    public static final int MINIMUM_LENGTH = 3;
    public static final int MAXIMUM_LENGTH = 100;

    @Override
    public void validate(FormElement element, FormSingleValidation val) {
        int spaceLoc;
        int len;
        String value = element.getStringValue();
        boolean good = false;
        int n = len = value != null ? value.length() : 0;
        if ((len >= 3 || len <= 100) && (spaceLoc = value.indexOf(32)) > 0 && spaceLoc < len - 1) {
            String numberPart = value.substring(0, spaceLoc);
            String streetPart = value.substring(spaceLoc + 1);
            if (StringHelper.isAllNumeric(numberPart) && !StringHelper.isAllNumeric(streetPart)) {
                good = true;
            }
        }
        if (!good) {
            this.setStandardError(element, val);
        }
    }

    protected void setStandardError(FormElement element, FormSingleValidation val) {
        val.setRawError(String.valueOf(element.getDisplayName()) + " does not contian a properly-formatted street address", "Please provide a properly-formatted street address in " + element.getDisplayName() + ".", "Please provide a properly-formatted street address in this field.");
    }
}

