/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.handler;

import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.Handler;
import com.techempower.gemini.LegacyContext;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class FileTossHandler<D extends BasicDispatcher, C extends LegacyContext>
implements Handler<D, C> {
    public static final String COMPONENT_CODE = "hFts";
    public static final String HANDLER_PREFIX = "file-";
    public static final String CMD_GET_FILE = "file-get";
    private final GeminiApplication application;

    public FileTossHandler(GeminiApplication application) {
        this.application = application;
    }

    protected GeminiApplication getApplication() {
        return this.application;
    }

    @Override
    public String getDescription() {
        return "Restricted-access file tossing";
    }

    @Override
    public int getPriority() {
        return -1000;
    }

    @Override
    public boolean acceptRequest(D dispatcher, C context, String command) {
        return command.startsWith(HANDLER_PREFIX);
    }

    @Override
    public boolean handleRequest(D dispatcher, C context, String command) {
        File file;
        String fileIdentifier = ((Context)context).query().get("id", "");
        if (fileIdentifier.length() > 0 && (file = this.getFile(fileIdentifier)) != null && file.exists() && this.accessGranted(context, fileIdentifier)) {
            return this.tossFile(context, file);
        }
        return false;
    }

    protected boolean tossFile(C context, File file) {
        return ((LegacyContext)context).includeFile(file, file.getName(), true);
    }

    protected Map<String, File> getFiles() {
        return new HashMap<String, File>();
    }

    protected File getFile(String fileIdentifier) {
        return this.getFiles().get(fileIdentifier);
    }

    protected boolean accessGranted(C context, String fileIdentifier) {
        return false;
    }
}

