/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.messaging;

import com.techempower.gemini.messaging.MessageType;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;
import com.techempower.util.StringList;
import java.io.Serializable;

public class Message
implements Serializable {
    private static final long serialVersionUID = 4979511634011145151L;
    private final String id;
    private final StringList classNames = new StringList(" ");
    private final String message;
    private final MessageType type;

    public Message(String message) {
        this.id = null;
        this.message = message;
        this.type = MessageType.NORMAL;
        this.addClass(this.type.getClassName());
    }

    public Message(String message, MessageType type) {
        this.id = null;
        this.message = message;
        this.type = type;
        this.addClass(type.getClassName());
    }

    public Message(String id, String message, MessageType type) {
        this.id = StringHelper.trim(id);
        this.message = message;
        this.type = type;
        this.addClass(type.getClassName());
    }

    public Message(String message, MessageType type, String className) {
        this.id = null;
        this.message = message;
        this.type = type;
        this.classNames.add(className);
    }

    public String getId() {
        return this.id;
    }

    public StringList getClassNames() {
        return this.classNames;
    }

    public void addClass(String className) {
        this.getClassNames().add(className);
    }

    public String getMessage() {
        return this.message;
    }

    public MessageType getType() {
        return this.type;
    }

    public String render(String tagName, boolean renderInlineStyle) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('<');
        buffer.append(tagName);
        if (StringHelper.isNonEmpty(this.id)) {
            buffer.append(" id=\"");
            buffer.append(this.id);
            buffer.append('\"');
        }
        if (this.classNames != null && this.classNames.size() > 0) {
            buffer.append(" class=\"");
            buffer.append(this.classNames.toString());
            buffer.append('\"');
        }
        if (renderInlineStyle && this.type != null) {
            buffer.append(" style=\"");
            buffer.append(this.type.getInlineStyle());
            buffer.append('\"');
        }
        buffer.append('>');
        buffer.append(NetworkHelper.escapeStringForHtml(this.message));
        buffer.append("</");
        buffer.append(tagName);
        buffer.append('>');
        return buffer.toString();
    }

    public String renderAsP(boolean withInlineStyles) {
        return this.render("p", withInlineStyles);
    }

    public String renderAsP() {
        return this.renderAsP(false);
    }

    public String renderAsDiv(boolean withInlineStyles) {
        return this.render("div", withInlineStyles);
    }

    public String renderAsDiv() {
        return this.renderAsDiv(false);
    }

    public String renderAsLi(boolean withInlineStyles) {
        return this.render("li", withInlineStyles);
    }

    public String renderAsLi() {
        return this.renderAsLi(false);
    }

    public String renderAsSpan(boolean withInlineStyles) {
        return this.render("span", withInlineStyles);
    }

    public String renderAsSpan() {
        return this.renderAsSpan(false);
    }

    public String renderAsTd(boolean withInlineStyles) {
        return this.render("td", withInlineStyles);
    }

    public String renderAsTd() {
        return this.renderAsTd(false);
    }

    public String toString() {
        return this.renderAsP();
    }
}

