/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor;

import com.techempower.asynchronous.Asynchronous;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.feature.Feature;
import com.techempower.gemini.feature.FeatureManager;
import com.techempower.gemini.monitor.GeminiMonitorListener;
import com.techempower.gemini.monitor.MonitorListener;
import com.techempower.gemini.monitor.MonitorSample;
import com.techempower.gemini.monitor.MonitoredCommand;
import com.techempower.gemini.monitor.cpupercentage.PercentageEvaluator;
import com.techempower.gemini.monitor.cpupercentage.PercentageInterval;
import com.techempower.gemini.monitor.cpupercentage.PercentageMonitorThread;
import com.techempower.gemini.monitor.cpupercentage.PercentageSample;
import com.techempower.gemini.monitor.health.HealthEvaluator;
import com.techempower.gemini.monitor.health.HealthSnapshot;
import com.techempower.gemini.monitor.session.SessionSnapshot;
import com.techempower.gemini.monitor.session.SessionState;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.ThreadHelper;
import com.techempower.log.ComponentLog;
import com.techempower.thread.EndableThread;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSession;

public class GeminiMonitor
implements Configurable,
Feature,
Asynchronous {
    public static final String COMPONENT_CODE = "Moni";
    public static final String PROPS_PREFIX = "GeminiMonitor.";
    public static final int DEFAULT_SNAPSHOT_HISTORY = 120;
    public static final long DEFAULT_SNAPSHOT_INTERVAL = 300000L;
    public static final long MINIMUM_SNAPSHOT_INTERVAL = 500L;
    public static final int MAXIMUM_SNAPSHOT_COUNT = 30000;
    public static final long MINIMUM_PERFORMANCE_INTERVAL = 5000L;
    public static final long MAXIMUM_PERFORMANCE_INTERVAL = 31536000000L;
    private final ComponentLog log;
    private final GeminiApplication app;
    private final FeatureManager fm;
    private final MonitorListener listener;
    private final Map<String, MonitoredCommand> commands;
    private final Map<Long, MonitorSample> currentRequests;
    private final ThreadMXBean threadBean;
    private final boolean cpuTimeSupported;
    private final AtomicInteger concurrentDispatches = new AtomicInteger(0);
    private final AtomicInteger concurrentPages = new AtomicInteger(0);
    private final AtomicInteger concurrentQueries = new AtomicInteger(0);
    private final GeminiMonitorThread thread;
    private GeminiMonitorListener[] monitorListeners;
    private long perfIntervalStart = 0L;
    private long perfIntervalEnd = 0L;
    private long perfIntervalLength = 3600000L;
    private final PercentageMonitorThread percentageThread;
    private PercentageEvaluator[] percEvaluators = new PercentageEvaluator[0];
    private int healthSnapshotCount = 120;
    private long healthIntervalLength = 300000L;
    private long healthIntervalEnd = 0L;
    private HealthSnapshot[] healthSnapshots = new HealthSnapshot[this.healthSnapshotCount];
    private HealthSnapshot currentHealth = null;
    private HealthEvaluator[] healthEvaluators = new HealthEvaluator[0];
    private ThreadGroup rootThreadGroup;
    private final SessionState sessionState;
    private int sessionSnapshotCount = 120;
    private long sessionIntervalLength = 300000L;
    private long sessionIntervalEnd = 0L;
    private SessionSnapshot[] sessionSnapshots = new SessionSnapshot[this.sessionSnapshotCount];

    public GeminiMonitor(GeminiApplication app) {
        this.app = app;
        this.log = app.getLog(COMPONENT_CODE);
        app.getConfigurator().addConfigurable(this);
        this.fm = app.getFeatureManager();
        this.enrollFeature(this.fm);
        this.listener = new MonitorListener(this);
        this.monitorListeners = new GeminiMonitorListener[0];
        this.commands = new HashMap<String, MonitoredCommand>();
        this.currentRequests = new HashMap<Long, MonitorSample>();
        app.addAsynchronous(this);
        this.sessionState = new SessionState(this);
        this.healthSnapshots[0] = this.currentHealth = new HealthSnapshot(this.healthIntervalLength);
        this.threadBean = ManagementFactory.getThreadMXBean();
        this.cpuTimeSupported = this.threadBean.isCurrentThreadCpuTimeSupported();
        this.rootThreadGroup = Thread.currentThread().getThreadGroup();
        while (this.rootThreadGroup.getParent() != null) {
            try {
                this.rootThreadGroup = this.rootThreadGroup.getParent();
            }
            catch (SecurityException sec) {
                break;
            }
        }
        this.thread = new GeminiMonitorThread();
        this.percentageThread = new PercentageMonitorThread(this);
    }

    public GeminiApplication getApplication() {
        return this.app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(EnhancedProperties props) {
        EnhancedProperties.Focus focus = props.focus(PROPS_PREFIX);
        GeminiMonitor geminiMonitor = this;
        synchronized (geminiMonitor) {
            long temp;
            if (focus.getProperty("Enabled") != null) {
                this.log.log(String.valueOf(focus.name("Enabled")) + " is deprecated.  Use Feature.monitor instead.");
                this.fm.set("monitor", focus.getYesNoProperty("Enabled", true));
                if (!this.isEnabled()) {
                    this.log.log("Gemini Monitor disabled.");
                }
            }
            if (focus.getProperty("HealthEnabled") != null) {
                this.log.log(String.valueOf(focus.name("HealthEnabled")) + " is deprecated.  Use Feature.monitor.health instead.");
                this.fm.set("health", focus.getYesNoProperty("HealthEnabled", true));
                if (!this.isHealthEnabled()) {
                    this.log.log("Health Monitoring sub-component disabled.");
                }
            }
            this.healthSnapshotCount = focus.getIntegerProperty("HealthSnapshotCount", 120, 2, 30000);
            this.healthIntervalLength = focus.getLongProperty("HealthSnapshotInterval", 300000L, 500L, 31536000000L);
            if (this.isEnabled()) {
                this.log.log("Health snapshots: " + this.healthSnapshotCount + " at " + this.healthIntervalLength + "ms intervals.");
            }
            if (this.healthSnapshots.length != this.healthSnapshotCount) {
                HealthSnapshot[] newArray = new HealthSnapshot[this.healthSnapshotCount];
                int toCopy = Math.min(newArray.length, this.healthSnapshots.length);
                System.arraycopy(this.healthSnapshots, 0, newArray, 0, toCopy);
                this.healthSnapshots = newArray;
            }
            if ((temp = System.currentTimeMillis() + this.healthIntervalLength) < this.healthIntervalEnd) {
                this.healthIntervalEnd = temp;
                this.currentHealth.setEndTime(temp);
            }
            this.sessionSnapshotCount = focus.getIntegerProperty("SessionSnapshotCount", 120, 2, 30000);
            this.sessionIntervalLength = focus.getLongProperty("SessionSnapshotInterval", 300000L, 500L, 31536000000L);
            if (this.isEnabled()) {
                this.log.log("Session snapshots: " + this.sessionSnapshotCount + " at " + this.sessionIntervalLength + "ms intervals.");
            }
            if (this.sessionSnapshots.length != this.sessionSnapshotCount) {
                SessionSnapshot[] newArray = new SessionSnapshot[this.sessionSnapshotCount];
                int toCopy = Math.min(newArray.length, this.sessionSnapshots.length);
                System.arraycopy(this.sessionSnapshots, 0, newArray, 0, toCopy);
                this.sessionSnapshots = newArray;
            }
            if ((temp = System.currentTimeMillis() + this.sessionIntervalLength) < this.sessionIntervalEnd) {
                this.sessionIntervalEnd = temp;
            }
        }
        this.evaluateIntervals();
    }

    public void enrollFeature(FeatureManager manager) {
        manager.add("monitor", "Gemini Monitor").add("health", "Gemini Monitor's health monitoring").add("session", "Gemini Monitor's web session monitoring").add("cpu", "Gemini Monitor's CPU utilization monitoring");
    }

    public boolean isEnabled() {
        return this.fm.on("monitor");
    }

    public boolean isHealthEnabled() {
        return this.fm.on("health");
    }

    public boolean isCpuPercentageEnabled() {
        return this.fm.on("cpu");
    }

    public boolean isSessionEnabled() {
        return this.fm.on("session");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MonitorSample sample, Context context) {
        if (this.isEnabled()) {
            GeminiMonitor geminiMonitor = this;
            synchronized (geminiMonitor) {
                MonitoredCommand command = this.commands.get(sample.getDispatchCommand());
                try {
                    this.evaluateIntervals();
                    if (command == null) {
                        command = new MonitoredCommand(this, sample.getDispatchCommand());
                        this.commands.put(sample.getDispatchCommand(), command);
                    }
                    command.process(sample, context);
                }
                finally {
                    if (command != null) {
                        command.adjustLoad(-sample.getRequestLoad());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(MonitorSample sample) {
        if (this.isEnabled()) {
            GeminiMonitor geminiMonitor = this;
            synchronized (geminiMonitor) {
                this.currentRequests.put(sample.getThreadID(), sample);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(MonitorSample sample) {
        if (this.isEnabled()) {
            GeminiMonitor geminiMonitor = this;
            synchronized (geminiMonitor) {
                this.currentRequests.remove(sample.getThreadID());
            }
        }
    }

    public MonitorSample getRequest(long threadID) {
        return this.currentRequests.get(threadID);
    }

    public synchronized List<MonitorSample> getCurrentRequests() {
        return new ArrayList<MonitorSample>(this.currentRequests.values());
    }

    public int getCurrentRequestCount() {
        return this.currentRequests.size();
    }

    public synchronized void addGeminiMonitorListener(GeminiMonitorListener gmListener) {
        GeminiMonitorListener[] newListeners = new GeminiMonitorListener[this.monitorListeners.length + 1];
        System.arraycopy(this.monitorListeners, 0, newListeners, 0, this.monitorListeners.length);
        newListeners[this.monitorListeners.length] = gmListener;
        this.monitorListeners = newListeners;
    }

    public synchronized void addHealthEvaluator(HealthEvaluator evaluator) {
        HealthEvaluator[] newList = new HealthEvaluator[this.healthEvaluators.length + 1];
        newList[0] = evaluator;
        if (this.healthEvaluators.length > 0) {
            System.arraycopy(this.healthEvaluators, 0, newList, 1, this.healthEvaluators.length);
        }
        this.healthEvaluators = newList;
    }

    public synchronized void addPercentageEvaluator(PercentageEvaluator evaluator) {
        PercentageEvaluator[] newList = new PercentageEvaluator[this.percEvaluators.length + 1];
        newList[0] = evaluator;
        if (this.percEvaluators.length > 0) {
            System.arraycopy(this.percEvaluators, 0, newList, 1, this.percEvaluators.length);
        }
        this.percEvaluators = newList;
    }

    public String evaluateHealthSnapshot(HealthSnapshot snapshot) {
        String evaluation = null;
        if (this.isHealthEnabled()) {
            int i = 0;
            while (i < this.healthEvaluators.length) {
                try {
                    evaluation = this.healthEvaluators[i].isExceptional(snapshot, this);
                    if (evaluation != null) {
                        break;
                    }
                }
                catch (Exception exc) {
                    this.log.log("Exception while evaluating health: " + exc);
                }
                ++i;
            }
        }
        return evaluation;
    }

    public String evaluatePercentage(PercentageInterval interval) {
        String evaluation = null;
        final PercentageInterval fInterval = interval;
        if (this.isCpuPercentageEnabled()) {
            int i = 0;
            while (i < this.percEvaluators.length) {
                try {
                    evaluation = this.percEvaluators[i].isExceptional(interval, this);
                    if (evaluation != null) {
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                GeminiMonitor.this.notifyListenersExceptionalCpuUtilization(fInterval);
                            }
                        };
                        ThreadHelper.submit(r);
                        break;
                    }
                }
                catch (Exception exc) {
                    this.log.log("Exception while evaluating CPU percentages: " + exc);
                }
                ++i;
            }
        }
        return evaluation;
    }

    public MonitorListener getListener() {
        return this.listener;
    }

    public synchronized long getHealthIntervalLength() {
        return this.healthIntervalLength;
    }

    public synchronized long getSessionIntervalLength() {
        return this.sessionIntervalLength;
    }

    public long getPerfIntervalLength() {
        return this.perfIntervalLength;
    }

    public void setPerfIntervalLength(long intervalLength) {
        this.perfIntervalLength = NumberHelper.boundLong(intervalLength, 5000L, 31536000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateIntervals() {
        if (this.isEnabled()) {
            HealthSnapshot justCompletedHealthReference = null;
            GeminiMonitor geminiMonitor = this;
            synchronized (geminiMonitor) {
                long current = System.currentTimeMillis();
                if (current > this.perfIntervalEnd) {
                    long absoluteHour = current / this.getPerfIntervalLength();
                    this.perfIntervalStart = absoluteHour * this.getPerfIntervalLength();
                    this.perfIntervalEnd = this.perfIntervalStart + this.getPerfIntervalLength() - 1L;
                    Iterator<MonitoredCommand> iter = this.commands.values().iterator();
                    while (iter.hasNext()) {
                        iter.next().push();
                    }
                }
                if (current > this.healthIntervalEnd && this.isHealthEnabled()) {
                    justCompletedHealthReference = this.pushHealthArray(current + this.getHealthIntervalLength());
                }
                if (current > this.sessionIntervalEnd && this.isSessionEnabled()) {
                    this.pushSessionArray(current + this.getSessionIntervalLength());
                }
            }
            if (justCompletedHealthReference != null && justCompletedHealthReference.isExceptional()) {
                this.notifyListenersExceptionalHealth(justCompletedHealthReference);
            }
        }
    }

    protected HealthSnapshot pushHealthArray(long newEnd) {
        HealthSnapshot justCompletedHealthReference = this.currentHealth;
        justCompletedHealthReference.complete(this);
        this.currentHealth = new HealthSnapshot(this.getHealthIntervalLength());
        System.arraycopy(this.healthSnapshots, 0, this.healthSnapshots, 1, this.healthSnapshots.length - 1);
        this.healthSnapshots[0] = this.currentHealth;
        this.healthIntervalEnd = newEnd;
        return justCompletedHealthReference;
    }

    protected void pushSessionArray(long newEnd) {
        SessionSnapshot justCompleted = new SessionSnapshot(this.sessionState);
        System.arraycopy(this.sessionSnapshots, 0, this.sessionSnapshots, 1, this.sessionSnapshots.length - 1);
        this.sessionSnapshots[0] = justCompleted;
        this.sessionIntervalEnd = newEnd;
    }

    public Set<HttpSession> getSessions() {
        if (this.isSessionEnabled()) {
            return this.sessionState.getSessions();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionSnapshot[] getSessionSnapshots() {
        SessionSnapshot[] toReturn = null;
        GeminiMonitor geminiMonitor = this;
        synchronized (geminiMonitor) {
            toReturn = new SessionSnapshot[this.sessionSnapshots.length];
            System.arraycopy(this.sessionSnapshots, 0, toReturn, 0, this.sessionSnapshots.length);
        }
        return toReturn;
    }

    public synchronized HealthSnapshot getCurrentHealth() {
        return this.currentHealth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthSnapshot[] getHealthSnapshots() {
        HealthSnapshot[] toReturn = null;
        GeminiMonitor geminiMonitor = this;
        synchronized (geminiMonitor) {
            toReturn = new HealthSnapshot[this.healthSnapshots.length];
            System.arraycopy(this.healthSnapshots, 0, toReturn, 0, this.healthSnapshots.length);
        }
        return toReturn;
    }

    public List<MonitoredCommand> getMonitoredCommands() {
        ArrayList<MonitoredCommand> toReturn = new ArrayList<MonitoredCommand>(this.commands.values());
        Collections.sort(toReturn);
        return toReturn;
    }

    public MonitoredCommand getMonitoredCommand(String command) {
        return this.commands.get(command);
    }

    public int getCurrentLoad(String command) {
        MonitoredCommand mc = this.getMonitoredCommand(command);
        if (mc != null) {
            return mc.getCurrentLoad();
        }
        return 0;
    }

    protected synchronized long getPerfIntervalStart() {
        return this.perfIntervalStart;
    }

    protected synchronized long getPerfIntervalEnd() {
        return this.perfIntervalEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchStarting(MonitorSample sample, String command) {
        if (this.isEnabled()) {
            GeminiMonitor geminiMonitor = this;
            synchronized (geminiMonitor) {
                MonitoredCommand monitoredCommand;
                if (this.isHealthEnabled()) {
                    this.concurrentDispatches.incrementAndGet();
                    this.currentHealth.incrementDispatchCount();
                }
                if ((monitoredCommand = this.commands.get(command)) != null) {
                    monitoredCommand.adjustLoad(1);
                } else {
                    sample.setRequestLoad(0);
                }
            }
        }
    }

    public void dispatchComplete() {
        if (this.isHealthEnabled()) {
            this.concurrentDispatches.decrementAndGet();
        }
    }

    public void jspIncluded() {
        if (this.isHealthEnabled()) {
            this.concurrentPages.incrementAndGet();
            this.currentHealth.incrementPageRenderCount();
        }
    }

    public void jspComplete() {
        if (this.isHealthEnabled()) {
            this.concurrentPages.decrementAndGet();
        }
    }

    public void queryStarting() {
        if (this.isHealthEnabled()) {
            this.concurrentQueries.incrementAndGet();
            this.currentHealth.incrementQueryCount();
        }
    }

    public void queryCompleting() {
        if (this.isHealthEnabled()) {
            this.concurrentQueries.decrementAndGet();
        }
    }

    public int getDispatchLoad() {
        return this.concurrentDispatches.get();
    }

    public int getPageRenderLoad() {
        return this.concurrentPages.get();
    }

    public int getQueryLoad() {
        return this.concurrentQueries.get();
    }

    public long getRequestCount() {
        return this.app.getRequestNumber();
    }

    public Thread[] getThreadArray() {
        int threadCount = this.rootThreadGroup.activeCount();
        Thread[] toReturn = new Thread[threadCount];
        this.rootThreadGroup.enumerate(toReturn);
        return toReturn;
    }

    public Thread[] getThreadBasics() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Thread[] toReturn = new Thread[map.size()];
        return map.keySet().toArray(toReturn);
    }

    public ThreadInfo[] getThreadDetails() {
        return this.threadBean.dumpAllThreads(true, true);
    }

    public long getCurrentThreadCpuTime() {
        if (this.cpuTimeSupported) {
            return this.threadBean.getCurrentThreadCpuTime();
        }
        return 0L;
    }

    public List<PercentageSample> getCpuUsagePercentages() {
        if (this.isCpuPercentageEnabled() && this.percentageThread != null) {
            return this.percentageThread.getCurrent();
        }
        return null;
    }

    @Override
    public void begin() {
        try {
            this.app.getServletConfig().addListener(this.sessionState);
        }
        catch (IllegalStateException ise) {
            this.log.log("Session listener not added automatically.");
        }
        this.thread.begin();
        this.percentageThread.begin();
    }

    @Override
    public void end() {
        this.thread.end();
        this.percentageThread.end();
    }

    protected void notifyListenersExceptionalHealth(HealthSnapshot snapshot) {
        if (this.isHealthEnabled() && this.monitorListeners.length > 0) {
            GeminiMonitorListener[] geminiMonitorListenerArray = this.monitorListeners;
            int n = this.monitorListeners.length;
            int n2 = 0;
            while (n2 < n) {
                GeminiMonitorListener l = geminiMonitorListenerArray[n2];
                l.healthSnapshotExceptional(snapshot);
                ++n2;
            }
        }
    }

    protected void notifyListenersExceptionalCpuUtilization(PercentageInterval interval) {
        if (this.isCpuPercentageEnabled() && this.monitorListeners.length > 0) {
            GeminiMonitorListener[] geminiMonitorListenerArray = this.monitorListeners;
            int n = this.monitorListeners.length;
            int n2 = 0;
            while (n2 < n) {
                GeminiMonitorListener l = geminiMonitorListenerArray[n2];
                l.cpuUtilizationIntervalExceptional(interval);
                ++n2;
            }
        }
    }

    class GeminiMonitorThread
    extends EndableThread {
        public GeminiMonitorThread() {
            super("Gemini Monitor Thread (" + GeminiMonitor.this.app.getVersion().getProductName() + ")", 500);
            this.setPriority(1);
        }

        @Override
        public void run() {
            GeminiMonitor.this.log.log("GeminiMonitorThread starting.");
            while (this.checkPause()) {
                GeminiMonitor.this.evaluateIntervals();
                this.simpleSleep();
            }
            GeminiMonitor.this.log.log("GeminiMonitorThread ending.");
        }

        @Override
        public String toString() {
            return String.valueOf(this.getName()) + (GeminiMonitor.this.isEnabled() ? "" : " (monitoring disabled)");
        }
    }
}

