/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor;

import com.techempower.data.DatabaseConnectionListener;
import com.techempower.data.jdbc.JdbcConnector;
import com.techempower.gemini.Context;
import com.techempower.gemini.DispatchListener;
import com.techempower.gemini.Dispatcher;
import com.techempower.gemini.Request;
import com.techempower.gemini.RequestListener;
import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.MonitorSample;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import java.sql.SQLException;

public class MonitorListener
implements DatabaseConnectionListener,
DispatchListener,
RequestListener {
    public static final String COMPONENT_CODE = "MonL";
    private final GeminiMonitor monitor;
    private final ComponentLog log;

    public MonitorListener(GeminiMonitor monitor) {
        this.monitor = monitor;
        this.log = monitor.getApplication().getLog(COMPONENT_CODE);
    }

    @Override
    public int exceptionInExecuteBatch(SQLException exc, JdbcConnector conn) {
        if (this.monitor.isEnabled()) {
            MonitorSample.get().queryException();
        }
        return 0;
    }

    @Override
    public int exceptionInRunQuery(SQLException exc, JdbcConnector conn) {
        if (this.monitor.isEnabled()) {
            MonitorSample.get().queryException();
        }
        return 0;
    }

    @Override
    public int exceptionInRunUpdateQuery(SQLException exc, JdbcConnector conn) {
        if (this.monitor.isEnabled()) {
            MonitorSample.get().queryException();
        }
        return 0;
    }

    @Override
    public void queryStarting() {
        if (this.monitor.isEnabled()) {
            MonitorSample.get().queryStarting();
            this.monitor.queryStarting();
        }
    }

    @Override
    public void queryCompleting() {
        if (this.monitor.isEnabled()) {
            MonitorSample.get().queryCompleting();
            this.monitor.queryCompleting();
        }
    }

    @Override
    public void configure(EnhancedProperties props) {
    }

    @Override
    public void dispatchStarting(Dispatcher dispatcher, Context context, String command) {
        MonitorSample sample;
        boolean first;
        if (this.monitor.isEnabled() && (first = (sample = MonitorSample.get()).dispatchStarting(command))) {
            this.monitor.addRequest(MonitorSample.get());
            sample.setRequestNumber(context.getRequestNumber());
            this.monitor.dispatchStarting(sample, command);
        }
    }

    @Override
    public void redispatchOccurring(Dispatcher dispatcher, Context context, String previousCommand, String newCommand) {
        if (this.monitor.isEnabled()) {
            this.dispatchComplete(dispatcher, context);
            this.dispatchStarting(dispatcher, context, newCommand);
        }
    }

    @Override
    public void dispatchComplete(Dispatcher dispatcher, Context context) {
        if (this.monitor.isEnabled()) {
            block6: {
                MonitorSample sample = MonitorSample.get();
                sample.logicComplete();
                sample.setCpuTimeAtEnd(this.monitor.getCurrentThreadCpuTime());
                try {
                    try {
                        this.monitor.process(sample, context);
                    }
                    catch (Exception exc) {
                        this.log.log("Exception while processing MonitorSample.", 70, exc);
                        this.monitor.removeRequest(sample);
                        MonitorSample.complete();
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    this.monitor.removeRequest(sample);
                    MonitorSample.complete();
                    throw throwable;
                }
                this.monitor.removeRequest(sample);
                MonitorSample.complete();
            }
            this.monitor.dispatchComplete();
        }
    }

    @Override
    public void renderComplete(Dispatcher dispatcher, Context context) {
        if (this.monitor.isEnabled()) {
            MonitorSample.get().renderComplete();
            this.monitor.jspComplete();
        }
    }

    @Override
    public void renderStarting(Dispatcher dispatcher, String jspName) {
        if (this.monitor.isEnabled()) {
            MonitorSample.get().logicComplete();
            this.monitor.jspIncluded();
        }
    }

    @Override
    public void requestStarting(Request request) {
        if (this.monitor.isEnabled()) {
            MonitorSample.get().setCpuTimeAtStart(this.monitor.getCurrentThreadCpuTime());
        }
    }

    @Override
    public void contextCreated(Context context) {
    }

    @Override
    public void requestCompleting(Request request, Context context) {
        if (this.monitor.isEnabled()) {
            MonitorSample.complete();
        }
    }
}

