/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor;

import com.techempower.helper.StringHelper;
import java.lang.management.ManagementFactory;

public class MonitorSample
implements Comparable<MonitorSample> {
    public static final long NANOS_PER_MILLI = 1000000L;
    private final long startTime = System.currentTimeMillis();
    private final long threadID = Thread.currentThread().getId();
    private long queryStart;
    private long specialStart;
    private long cpuTimeAtStart;
    private int dispatches = 0;
    private int queries = 0;
    private int logicTime = 0;
    private int renderTime = 0;
    private int queryExceptions = 0;
    private int queryTime = 0;
    private int specialTime = 0;
    private int totalCpuTime = 0;
    private int requestLoad = 1;
    private long requestNumber = 0L;
    private String command;
    private String requestSignature;
    private static final ThreadLocal<MonitorSample> CURRENT = new ThreadLocal<MonitorSample>(){

        @Override
        protected MonitorSample initialValue() {
            return new MonitorSample();
        }
    };

    public static MonitorSample get() {
        return CURRENT.get();
    }

    public static void complete() {
        CURRENT.remove();
    }

    public void setCpuTimeAtStart(long cpuTime) {
        this.cpuTimeAtStart = cpuTime;
    }

    public void setCpuTimeAtEnd(long cpuTime) {
        if (this.cpuTimeAtStart > 0L) {
            this.totalCpuTime = cpuTime - this.cpuTimeAtStart > 1000000L ? (int)((cpuTime - this.cpuTimeAtStart) / 1000000L) : 0;
        }
    }

    public int getTotalCpuTime() {
        return this.totalCpuTime;
    }

    public int getTotalCpuTimeInProgress() {
        long current = ManagementFactory.getThreadMXBean().getThreadCpuTime(this.threadID);
        return (int)((current - this.cpuTimeAtStart) / 1000000L);
    }

    public void specialStarting() {
        this.specialStart = System.currentTimeMillis();
    }

    public void specialCompleting() {
        if (this.specialStart > 0L) {
            this.specialTime += (int)(System.currentTimeMillis() - this.specialStart);
            this.specialStart = 0L;
        }
    }

    public void queryStarting() {
        ++this.queries;
        this.queryStart = System.currentTimeMillis();
    }

    public int getQueries() {
        return this.queries;
    }

    public void queryCompleting() {
        if (this.queryStart > 0L) {
            this.queryTime += (int)(System.currentTimeMillis() - this.queryStart);
            this.queryStart = 0L;
        }
    }

    public int getQueryTime() {
        return this.queryTime;
    }

    public int getSpecialTime() {
        return this.specialTime;
    }

    public void queryException() {
        ++this.queryExceptions;
    }

    public int getQueryExceptions() {
        return this.queryExceptions;
    }

    public long getRequestNumber() {
        return this.requestNumber;
    }

    public void setRequestNumber(long reqNum) {
        this.requestNumber = reqNum;
    }

    public long getThreadID() {
        return this.threadID;
    }

    public boolean dispatchStarting(String commandString) {
        ++this.dispatches;
        boolean first = this.command == null;
        this.command = commandString;
        return first;
    }

    public int getDispatches() {
        return this.dispatches;
    }

    public String getDispatchCommand() {
        return this.command;
    }

    public void logicComplete() {
        if (this.logicTime == 0) {
            this.logicTime = (int)(System.currentTimeMillis() - this.startTime);
        }
    }

    public int getLogicTime() {
        return this.logicTime;
    }

    public void renderComplete() {
        if (this.renderTime == 0) {
            this.renderTime = (int)(System.currentTimeMillis() - this.startTime - (long)this.logicTime);
        }
    }

    public int getRenderTime() {
        return this.renderTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getTotalTime() {
        return this.getLogicTime() + this.getRenderTime();
    }

    public void setRequestSignature(String requestSignature) {
        this.requestSignature = requestSignature;
    }

    public String getRequestSignature() {
        return this.requestSignature;
    }

    public int getQueryTimeInProgress() {
        if (this.queryStart > 0L) {
            return this.queryTime + (int)(System.currentTimeMillis() - this.queryStart);
        }
        return this.queryTime;
    }

    public int getSpecialTimeInProgress() {
        if (this.specialStart > 0L) {
            return this.specialTime + (int)(System.currentTimeMillis() - this.specialStart);
        }
        return this.specialTime;
    }

    public int getLogicTimeInProgress() {
        if (this.logicTime == 0) {
            return (int)(System.currentTimeMillis() - this.startTime);
        }
        return this.logicTime;
    }

    public int getRenderTimeInProgress() {
        if (this.renderTime == 0) {
            if (this.logicTime == 0) {
                return 0;
            }
            return (int)(System.currentTimeMillis() - this.startTime - (long)this.logicTime);
        }
        return this.renderTime;
    }

    public int getTotalTimeInProgress() {
        return this.getLogicTimeInProgress() + this.getRenderTimeInProgress();
    }

    public int getRequestLoad() {
        return this.requestLoad;
    }

    public void setRequestLoad(int requestLoad) {
        this.requestLoad = requestLoad;
    }

    public String toString() {
        return "MS [" + this.dispatches + " disp; " + this.queries + " qs; " + this.queryExceptions + " qexcs; " + this.logicTime + "ms logic; " + this.renderTime + "ms render]";
    }

    @Override
    public int compareTo(MonitorSample other) {
        return StringHelper.compareToIgnoreCase(this.command, other.command);
    }
}

