/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor.cpupercentage;

import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.cpupercentage.PercentageEvaluator;
import com.techempower.gemini.monitor.cpupercentage.PercentageInterval;
import com.techempower.gemini.monitor.cpupercentage.PercentageSample;
import com.techempower.helper.ThreadHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BasicSpikeDetector
implements PercentageEvaluator,
Configurable {
    public static final String CONFIGURATION_PREFIX = "BasicSpikeDetector.";
    public static final int DEFAULT_INTERVAL_BEFORE_EXCEPTIONAL = 5;
    public static final int DEFAULT_PERCENTAGE_THRESHOLD = 90;
    private final ComponentLog log;
    private final Set<String> ignored;
    private final Set<String> ignoredStackItems;
    private final List<List<Long>> overThreshold;
    private final int intervalsBeforeExceptional;
    private final int percentageThreshold;
    private boolean enabled = true;

    public BasicSpikeDetector(GeminiApplication application, int intervalsBeforeExceptional, int percentageThreshold) {
        this.log = application.getLog("Spke");
        this.intervalsBeforeExceptional = intervalsBeforeExceptional;
        this.percentageThreshold = percentageThreshold;
        this.ignored = new HashSet<String>();
        this.ignoredStackItems = new HashSet<String>();
        this.overThreshold = new ArrayList<List<Long>>(intervalsBeforeExceptional + 1);
        int i = 0;
        while (i < intervalsBeforeExceptional + 1) {
            this.overThreshold.add(new ArrayList(0));
            ++i;
        }
        application.getConfigurator().addConfigurable(this);
    }

    public BasicSpikeDetector(GeminiApplication application) {
        this(application, 5, 90);
    }

    @Override
    public String isExceptional(PercentageInterval interval, GeminiMonitor monitor) {
        PercentageSample sample;
        if (!this.enabled) {
            return null;
        }
        StringBuilder toReturn = null;
        this.overThreshold.remove(0);
        int count = 0;
        List<PercentageSample> samples = interval.getSamples();
        int i = 0;
        while (i < samples.size()) {
            sample = samples.get(i);
            if (sample.getUsage() > this.percentageThreshold) {
                ++count;
            }
            ++i;
        }
        ArrayList<Long> entry = new ArrayList<Long>(count);
        int i2 = 0;
        while (i2 < samples.size()) {
            sample = samples.get(i2);
            if (sample.getUsage() > this.percentageThreshold && !this.ignored.contains(sample.getName())) {
                String stackTrace;
                entry.add(sample.getId());
                if (this.isThreadExceptional(sample.getId()) && !this.containsIgnoredStackItems(stackTrace = this.capture(sample.getId()))) {
                    this.log.log("Exceptional thread detected: " + sample.getId());
                    if (toReturn == null) {
                        toReturn = new StringBuilder();
                    }
                    toReturn.append(stackTrace);
                    toReturn.append("\r\n");
                }
            }
            ++i2;
        }
        this.overThreshold.add(entry);
        if (toReturn == null) {
            return null;
        }
        return toReturn.toString();
    }

    protected boolean isThreadExceptional(long id) {
        List<Long> list = this.overThreshold.get(0);
        if (list == null) {
            return false;
        }
        if (list.contains(id)) {
            return false;
        }
        int i = 1;
        while (i < this.overThreshold.size()) {
            list = this.overThreshold.get(i);
            if (list == null || !list.contains(id)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String capture(long threadId) {
        StringBuilder toReturn = new StringBuilder();
        toReturn.append("Thread " + threadId + " over " + this.percentageThreshold + "% CPU usage for " + this.intervalsBeforeExceptional + " intervals (seconds)" + "\r\n");
        Thread thread = ThreadHelper.getThread(threadId);
        if (thread != null) {
            toReturn.append("  " + thread.getName() + "\r\n");
            toReturn.append("  Stack trace:\r\n");
            StackTraceElement[] trace = thread.getStackTrace();
            int i = 0;
            while (i < trace.length) {
                toReturn.append("  " + trace[i].toString() + "\r\n");
                ++i;
            }
        } else {
            toReturn.append("  Thread " + threadId + " not available for capture." + "\r\n");
        }
        return toReturn.toString();
    }

    @Override
    public void configure(EnhancedProperties props) {
        String toIgnore;
        EnhancedProperties.Focus focus = props.focus(CONFIGURATION_PREFIX);
        this.enabled = focus.getYesNoProperty("Enabled", true);
        int index = 1;
        do {
            if ((toIgnore = focus.getProperty("Ignore" + index)) != null) {
                this.addIgnoredThread(toIgnore);
            }
            ++index;
        } while (toIgnore != null);
        if (this.ignored.size() > 0) {
            this.log.log(String.valueOf(this.ignored.size()) + " thread(s) ignored for alerts.");
        }
        index = 1;
        do {
            if ((toIgnore = focus.getProperty("IgnoreStack" + index)) != null) {
                this.addIgnoredStackItem(toIgnore);
            }
            ++index;
        } while (toIgnore != null);
        if (this.ignoredStackItems.size() > 0) {
            this.log.log(String.valueOf(this.ignoredStackItems.size()) + " stack item(s) ignored for alerts.");
        }
    }

    public void addIgnoredThread(String threadName) {
        this.ignored.add(threadName);
    }

    public void addIgnoredStackItem(String stackItem) {
        this.ignoredStackItems.add(stackItem);
    }

    protected boolean containsIgnoredStackItems(String stackTrace) {
        for (String ignoredItem : this.ignoredStackItems) {
            if (!stackTrace.contains(ignoredItem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getEvaluatorName() {
        return "SpikeDetector";
    }
}

