/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor.cpupercentage;

import com.techempower.gemini.monitor.cpupercentage.PercentageSample;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PercentageInterval {
    private final Map<Long, PercentageSample> samples;
    private String evaluation;

    public PercentageInterval(Thread[] threads, PercentageInterval previous, ThreadMXBean jmx, long timeDelta) {
        this.samples = new HashMap<Long, PercentageSample>(threads.length);
        int i = 0;
        while (i < threads.length) {
            if (threads[i] != null) {
                PercentageSample previousSample;
                long id = threads[i].getId();
                PercentageSample sample = new PercentageSample(threads[i].getName(), id, jmx.getThreadCpuTime(id));
                this.samples.put(id, sample);
                if (previous != null && (previousSample = previous.getPercentageSample(id)) != null) {
                    sample.setUsage(previousSample, timeDelta);
                }
            }
            ++i;
        }
    }

    public void setEvaluation(String evaluation) {
        this.evaluation = evaluation;
    }

    public String getEvaluation() {
        return this.evaluation;
    }

    public boolean isExceptional() {
        return this.evaluation != null;
    }

    public PercentageSample getPercentageSample(long threadId) {
        return this.samples.get(threadId);
    }

    public List<PercentageSample> getSamples() {
        ArrayList<PercentageSample> toReturn = new ArrayList<PercentageSample>(this.samples.values());
        Collections.sort(toReturn);
        return toReturn;
    }
}

