/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor.cpupercentage;

import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.cpupercentage.PercentageInterval;
import com.techempower.gemini.monitor.cpupercentage.PercentageSample;
import com.techempower.log.ComponentLog;
import com.techempower.thread.EndableThread;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.List;

public class PercentageMonitorThread
extends EndableThread {
    private static final long SLEEP_PERIOD = 15000L;
    private final GeminiMonitor monitor;
    private final ComponentLog log;
    private final ThreadMXBean jmx;
    private long thisInterval = 0L;
    private long nextInterval = 0L;
    private PercentageInterval current;

    public PercentageMonitorThread(GeminiMonitor monitor) {
        super("Gemini Monitor CPU Percentage (" + monitor.getApplication().getVersion().getProductName() + ")", 1000);
        this.monitor = monitor;
        this.log = monitor.getApplication().getLog("cpup");
        this.jmx = ManagementFactory.getThreadMXBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.log("GeminiMonitor CPU Percentage Thread starting.");
        while (this.checkPause()) {
            if (this.monitor.isCpuPercentageEnabled()) {
                PercentageMonitorThread percentageMonitorThread = this;
                synchronized (percentageMonitorThread) {
                    this.pushInterval();
                    String evaluation = this.monitor.evaluatePercentage(this.current);
                    if (evaluation != null) {
                        this.current.setEvaluation(evaluation);
                    }
                    this.nextInterval += 1000L;
                    if (this.thisInterval > this.nextInterval) {
                        this.nextInterval = this.thisInterval + 1000L;
                    }
                }
                this.simpleSleep((int)(this.nextInterval - this.thisInterval));
                continue;
            }
            this.simpleSleep(15000L);
        }
        this.log.log("GeminiMonitor CPU Percentage Thread ending.");
    }

    public synchronized List<PercentageSample> getCurrent() {
        return this.current.getSamples();
    }

    public void pushInterval() {
        PercentageInterval newInterval;
        long now = System.currentTimeMillis();
        long delta = 1000L;
        if (this.thisInterval > 0L) {
            delta = now - this.thisInterval;
        }
        this.thisInterval = now;
        Thread[] threads = this.monitor.getThreadArray();
        this.current = newInterval = new PercentageInterval(threads, this.current, this.jmx, delta);
    }
}

