/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.monitor.health;

import com.techempower.gemini.monitor.GeminiMonitor;
import com.techempower.gemini.monitor.health.HealthEvaluator;
import com.techempower.gemini.monitor.health.HealthSnapshot;

public class BasicThreadEvaluator
implements HealthEvaluator {
    private final int threadCount;
    private final int blockedCount;
    private final int waitingCount;

    public BasicThreadEvaluator(int totalThreadCount, int blockedCount, int waitingCount) {
        this.threadCount = totalThreadCount;
        this.blockedCount = blockedCount;
        this.waitingCount = waitingCount;
    }

    @Override
    public String isExceptional(HealthSnapshot snapshot, GeminiMonitor monitor) {
        if (this.threadCount > 0 && snapshot.getTotalThreads() >= this.threadCount) {
            return String.valueOf(snapshot.getTotalThreads()) + " total threads exceeds threshold of " + this.threadCount + ".";
        }
        if (this.blockedCount > 0 && snapshot.getBlockedThreads() >= this.blockedCount) {
            return String.valueOf(snapshot.getBlockedThreads()) + " blocked threads exceeds threshold of " + this.blockedCount + ".";
        }
        if (this.waitingCount > 0 && snapshot.getWaitingThreads() >= this.waitingCount) {
            return String.valueOf(snapshot.getWaitingThreads()) + " waiting threads exceeds threshold of " + this.waitingCount + ".";
        }
        return null;
    }

    @Override
    public String getEvaluatorName() {
        return "Thread Evaluator [" + this.threadCount + ";" + this.blockedCount + ";" + this.waitingCount + "]";
    }
}

