/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.path;

import com.techempower.TechEmpowerApplication;
import com.techempower.gemini.Context;
import com.techempower.gemini.DispatchListener;
import com.techempower.gemini.Dispatcher;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.exceptionhandler.ExceptionHandler;
import com.techempower.gemini.path.PathHandler;
import com.techempower.gemini.path.PathSegments;
import com.techempower.gemini.path.UriAware;
import com.techempower.gemini.prehandler.Prehandler;
import com.techempower.log.ComponentLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathDispatcher<A extends GeminiApplication, C extends Context>
implements Dispatcher {
    private final A application;
    private final ComponentLog log;
    private final Map<String, PathHandler<C>> handlers;
    private final PathHandler<C> defaultHandler;
    private final ExceptionHandler[] exceptionHandlers;
    private final Prehandler[] prehandlers;
    private final DispatchListener[] listeners;

    public PathDispatcher(A application, Configuration<C> configuration) {
        this.application = application;
        this.log = ((TechEmpowerApplication)application).getLog("disp");
        this.handlers = new HashMap<String, PathHandler<C>>(((Configuration)configuration).handlers);
        this.defaultHandler = ((Configuration)configuration).defaultHandler;
        this.exceptionHandlers = ((Configuration)configuration).exceptionHandlers.toArray(new ExceptionHandler[((Configuration)configuration).exceptionHandlers.size()]);
        this.prehandlers = ((Configuration)configuration).prehandlers.toArray(new Prehandler[((Configuration)configuration).prehandlers.size()]);
        this.listeners = ((Configuration)configuration).listeners.toArray(new DispatchListener[((Configuration)configuration).listeners.size()]);
        if (this.defaultHandler == null) {
            throw new IllegalArgumentException("Configuration did not provide a default handler.");
        }
        if (this.exceptionHandlers.length == 0) {
            throw new IllegalArgumentException("PathDispatcher must be configured with at least one ExceptionHandler.");
        }
    }

    public PathHandler<C> get(String rootPathSegment) {
        return this.handlers.get(rootPathSegment);
    }

    protected A getApplication() {
        return this.application;
    }

    protected ComponentLog getLog() {
        return this.log;
    }

    protected boolean prehandle(C context) {
        Prehandler[] thePrehandlers;
        Prehandler[] prehandlerArray = thePrehandlers = this.prehandlers;
        int n = thePrehandlers.length;
        int n2 = 0;
        while (n2 < n) {
            Prehandler p = prehandlerArray[n2];
            if (p.prehandle((Context)context)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean dispatch(Context plainContext) {
        boolean success;
        block14: {
            success = false;
            try {
                Context context = plainContext;
                PathSegments segments = new PathSegments(context.getRequestUri());
                this.notifyListenersDispatchStarting(plainContext, segments.getUri());
                PathHandler<Context> handler = null;
                if (segments.getCount() > 0 && (handler = this.get(segments.get(0))) != null) {
                    segments.increaseOffset();
                }
                if (handler == null) {
                    handler = this.defaultHandler;
                }
                if (!(success = this.prehandle(context))) {
                    try {
                        success = handler.prehandle(segments, context);
                        if (!success) {
                            success = handler.handle(segments, context);
                        }
                    }
                    finally {
                        handler.posthandle(segments, context);
                    }
                }
                if (success || handler == this.defaultHandler) break block14;
                try {
                    success = this.defaultHandler.prehandle(segments.offset(0), context);
                    if (!success) {
                        success = this.defaultHandler.handle(segments, context);
                    }
                }
                finally {
                    this.defaultHandler.posthandle(segments, context);
                }
            }
            catch (Throwable exc) {
                this.dispatchException(plainContext, exc, null);
            }
        }
        return success;
    }

    @Override
    public void dispatchComplete(Context context) {
        this.notifyListenersDispatchComplete(context);
    }

    @Override
    public void dispatchException(Context context, Throwable exception, String description) {
        try {
            ExceptionHandler[] exceptionHandlerArray = this.exceptionHandlers;
            int n = this.exceptionHandlers.length;
            int n2 = 0;
            while (n2 < n) {
                ExceptionHandler handler = exceptionHandlerArray[n2];
                if (description != null) {
                    handler.handleException(context, exception, description);
                } else {
                    handler.handleException(context, exception);
                }
                ++n2;
            }
        }
        catch (Exception exc) {
            this.log.log("Exception encountered while processing earlier " + exception, 70, exc);
        }
    }

    protected void notifyListenersDispatchStarting(Context context, String command) {
        DispatchListener[] theListeners;
        DispatchListener[] dispatchListenerArray = theListeners = this.listeners;
        int n = theListeners.length;
        int n2 = 0;
        while (n2 < n) {
            DispatchListener listener = dispatchListenerArray[n2];
            listener.dispatchStarting(this, context, command);
            ++n2;
        }
    }

    protected void notifyListenersDispatchComplete(Context context) {
        DispatchListener[] theListeners;
        DispatchListener[] dispatchListenerArray = theListeners = this.listeners;
        int n = theListeners.length;
        int n2 = 0;
        while (n2 < n) {
            DispatchListener listener = dispatchListenerArray[n2];
            listener.dispatchComplete(this, context);
            ++n2;
        }
    }

    @Override
    public void renderStarting(Context context, String jspName) {
        DispatchListener[] theListeners;
        DispatchListener[] dispatchListenerArray = theListeners = this.listeners;
        int n = theListeners.length;
        int n2 = 0;
        while (n2 < n) {
            DispatchListener listener = dispatchListenerArray[n2];
            listener.renderStarting(this, jspName);
            ++n2;
        }
    }

    @Override
    public void renderComplete(Context context) {
        DispatchListener[] theListeners;
        DispatchListener[] dispatchListenerArray = theListeners = this.listeners;
        int n = theListeners.length;
        int n2 = 0;
        while (n2 < n) {
            DispatchListener listener = dispatchListenerArray[n2];
            listener.renderComplete(this, context);
            ++n2;
        }
    }

    public static class Configuration<C extends Context> {
        private PathHandler<C> defaultHandler;
        private final Map<String, PathHandler<C>> handlers = new HashMap<String, PathHandler<C>>();
        private final List<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>();
        private final List<Prehandler> prehandlers = new ArrayList<Prehandler>();
        private final List<DispatchListener> listeners = new ArrayList<DispatchListener>();

        public Configuration<C> add(String rootPathSegment, PathHandler<C> handler) {
            if (handler instanceof UriAware) {
                ((UriAware)((Object)handler)).setBaseUri("/" + rootPathSegment);
            }
            this.handlers.put(rootPathSegment, handler);
            return this;
        }

        public Configuration<C> add(ExceptionHandler exceptionHandler) {
            this.exceptionHandlers.add(exceptionHandler);
            return this;
        }

        public Configuration<C> add(Prehandler prehandler) {
            this.prehandlers.add(prehandler);
            return this;
        }

        public Configuration<C> add(DispatchListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public Configuration<C> setDefault(PathHandler<C> handler) {
            this.defaultHandler = handler;
            return this;
        }
    }
}

