/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis;

import com.techempower.cache.EntityStore;
import com.techempower.data.EntityRelation;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.pyxis.BasicUser;
import com.techempower.gemini.pyxis.BasicUserGroup;
import com.techempower.gemini.pyxis.LoginTokenManager;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.PyxisSettings;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.PyxisUserGroup;
import com.techempower.gemini.pyxis.authorization.Authorizer;
import com.techempower.gemini.pyxis.authorization.Rejector;
import com.techempower.gemini.pyxis.group.PyxisAdministratorsGroup;
import com.techempower.gemini.pyxis.group.PyxisGuestsGroup;
import com.techempower.gemini.pyxis.group.PyxisUsersGroup;
import com.techempower.gemini.pyxis.listener.LastLoginUpdater;
import com.techempower.gemini.pyxis.listener.SecurityListener;
import com.techempower.gemini.pyxis.password.BCryptPasswordHasher;
import com.techempower.gemini.pyxis.password.PasswordDisallowedUsername;
import com.techempower.gemini.pyxis.password.PasswordHasher;
import com.techempower.gemini.pyxis.password.PasswordLength;
import com.techempower.gemini.pyxis.password.PasswordProposal;
import com.techempower.gemini.pyxis.password.PasswordRequirement;
import com.techempower.gemini.pyxis.password.PlaintextPasswordHasher;
import com.techempower.gemini.session.Session;
import com.techempower.helper.DateHelper;
import com.techempower.helper.NetworkHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class BasicSecurity<U extends PyxisUser, G extends PyxisUserGroup>
implements PyxisSecurity,
Configurable {
    public static final String COMPONENT_CODE = "secu";
    public static final String MULTISESSION_VIOLATION = "MultiSessionViolation";
    public static final int DEFAULT_FAILED_RESET_SECONDS = 300;
    public static final String PROPS_PREFIX = "BasicSecurity.";
    private final GeminiApplication application;
    private final ComponentLog log;
    private final PyxisSettings settings;
    private final LoginTokenManager loginTokenManager;
    private final EntityStore store;
    private final Class<U> userClass;
    private final Class<G> groupClass;
    private final List<PasswordRequirement> passwordRequirements;
    private List<PyxisUserGroup> standardUserGroups;
    private PasswordHasher passwordHasher = null;
    private boolean allowMultipleSessions = true;
    private boolean storeUserAsID = false;
    private String loginUri = "login";
    private String postLoginUrl = "/";
    private boolean cookieLoginEnabled = true;
    private boolean cookieLoginSslOnly = true;
    private boolean requireHttpsForm = true;
    private boolean exitHttpsPostLogin = false;
    private boolean logoutDeletesCookie = false;
    private int failedAttemptLimit = 0;
    private int failedResetSeconds = 300;
    private long nextAutoReset = 0L;
    private List<SecurityListener<Context>> listeners = null;
    private final Map<Integer, Object> userSessionIDs = Collections.synchronizedMap(new HashMap());
    private Map<String, LoginAttempt> ipToAttempts = null;
    private final Rejector forceLoginRejector = new Rejector(){

        @Override
        public void reject(Context context, PyxisUser user) {
            boolean redirectWarranted;
            String requestUri = context.getRequestUri();
            String redirectUrl = BasicSecurity.this.isRequireHttpsForm() ? String.valueOf(context.getSecureUrl()) + BasicSecurity.this.getLoginUri() : "/" + BasicSecurity.this.getLoginUri();
            boolean bl = redirectWarranted = !BasicSecurity.this.postLoginUrl.equals(requestUri);
            if (GeminiHelper.isJsonRequest(context)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("login", redirectUrl);
                map.put("request", requestUri);
                map.put("message", "You need to be logged in to perform this action. Please login and try again.");
                context.setStatus(401);
                GeminiHelper.sendJson(context, map);
            } else {
                context.redirect(String.valueOf(redirectUrl) + (redirectWarranted ? "?r=" + NetworkHelper.encodeUrl(requestUri) : ""));
            }
        }
    };

    public BasicSecurity(GeminiApplication application, Class<U> userClass, Class<G> groupClass) {
        this.application = application;
        this.log = this.application.getLog(COMPONENT_CODE);
        this.settings = this.constructPyxisSettings(application);
        this.listeners = new CopyOnWriteArrayList<SecurityListener<Context>>();
        this.passwordRequirements = new ArrayList<PasswordRequirement>(this.constructPasswordRequirements());
        application.getConfigurator().addConfigurable(this);
        this.loginTokenManager = new LoginTokenManager(application);
        this.constructStandardGroups();
        this.store = application.getStore();
        this.userClass = userClass;
        this.groupClass = groupClass;
        if (this.store == null) {
            this.log.log("ERROR: CachingSecurity cannot function without an application cache!", 90);
        }
        this.addListener(new LastLoginUpdater(this));
    }

    @Override
    public PyxisSettings getSettings() {
        return this.settings;
    }

    protected ComponentLog getLog() {
        return this.log;
    }

    protected EntityStore getStore() {
        return this.store;
    }

    @Override
    public LoginTokenManager getLoginTokenManager() {
        return this.loginTokenManager;
    }

    @Override
    public void configure(EnhancedProperties props) {
        String hashingAlgorithm;
        this.settings.configure(props);
        EnhancedProperties.Focus focus = props.focus(PROPS_PREFIX);
        this.storeUserAsID = focus.getYesNoProperty("StoreUserAsID", this.storeUserAsID);
        this.allowMultipleSessions = focus.getYesNoProperty("AllowMultipleSessions", this.allowMultipleSessions);
        this.loginUri = focus.getProperty("LoginUri", this.loginUri);
        this.postLoginUrl = focus.getProperty("PostLoginUrl", this.postLoginUrl);
        this.cookieLoginEnabled = focus.getYesNoProperty("CookieLoginEnabled", this.cookieLoginEnabled);
        this.cookieLoginSslOnly = focus.getYesNoProperty("CookieLoginSSLOnly", this.cookieLoginSslOnly);
        this.requireHttpsForm = focus.getYesNoProperty("RequireHTTPS", this.requireHttpsForm);
        this.exitHttpsPostLogin = focus.getYesNoProperty("ExitHTTPS", this.exitHttpsPostLogin);
        this.failedAttemptLimit = focus.getIntegerProperty("FailedAttemptLimit", this.failedAttemptLimit);
        this.failedResetSeconds = focus.getIntegerProperty("FailedResetSeconds", this.failedResetSeconds);
        this.logoutDeletesCookie = focus.getYesNoProperty("LogoutDeletesCookies", this.logoutDeletesCookie);
        if (this.isFailedAttemptLimiting()) {
            this.nextAutoReset = DateHelper.getEndOfDay().getTime().getTime();
        }
        switch (hashingAlgorithm = focus.getProperty("HashingAlgorithm", "bcrypt")) {
            case "plaintext": {
                this.passwordHasher = new PlaintextPasswordHasher();
                break;
            }
            default: {
                this.passwordHasher = new BCryptPasswordHasher();
            }
        }
        this.log.log("Using " + this.passwordHasher.getName() + " hashing algorithm.");
        if (focus.getProperty("PasswordCryptographer") != null) {
            this.log.log("Property BasicSecurity.PasswordCryptographer is deprecated. UseBasicSecurity.HashingAlgorithm instead.");
        }
    }

    protected List<PasswordRequirement> constructPasswordRequirements() {
        ArrayList<PasswordRequirement> toReturn = new ArrayList<PasswordRequirement>();
        toReturn.add(new PasswordLength(4, 100));
        toReturn.add(new PasswordDisallowedUsername(false));
        return toReturn;
    }

    @Override
    public String getLoginUri() {
        return this.loginUri;
    }

    @Override
    public String getPostLoginUrl() {
        return this.postLoginUrl;
    }

    @Override
    public boolean isCookieLoginEnabled() {
        return this.cookieLoginEnabled;
    }

    @Override
    public boolean isCookieLoginSslOnly() {
        return this.cookieLoginSslOnly;
    }

    @Override
    public boolean isRequireHttpsForm() {
        return this.requireHttpsForm;
    }

    @Override
    public boolean isExitHttpsPostLogin() {
        return this.exitHttpsPostLogin;
    }

    @Override
    public boolean isFailedAttemptLimiting() {
        return this.failedAttemptLimit > 0;
    }

    @Override
    public boolean authCheck(Context context, Authorizer authorizer, Rejector rejector) {
        PyxisUser user = null;
        if (this.isLoggedIn(context)) {
            user = this.getUser(context);
        } else if (this.cookieLogin(context)) {
            user = this.getUser(context);
        }
        if (user != null && (authorizer == null || authorizer.isAuthorized(user))) {
            return true;
        }
        if (rejector != null) {
            rejector.reject(context, user);
        } else {
            this.forceLoginRejector.reject(context, user);
        }
        return false;
    }

    @Override
    public boolean authCheck(Context context) {
        return this.authCheck(context, null, null);
    }

    @Override
    public Rejector getForceLoginRejector() {
        return this.forceLoginRejector;
    }

    protected boolean cookieLogin(Context context) {
        LoginTokenManager ltm = this.getLoginTokenManager();
        if (ltm != null && this.isCookieLoginPermitted(context)) {
            LoginTokenManager.TokenValidation validation;
            try {
                validation = ltm.validateAndUpdateToken(context);
            }
            catch (SQLException e) {
                this.log.log("SQL exception while validating and updating token.", 70, e);
                return false;
            }
            if (validation.isValid()) {
                if (this.isLoginAttemptPermitted(context)) {
                    PyxisUser user = this.getUser(validation.getUsername());
                    if (this.login(context, user)) {
                        this.log.log("Cookie login for user " + user.getUserUsername() + ".");
                        context.session().put("Pyxis.UsedCookieLogin", true);
                        this.captureSuccessfulLoginAttempt(context);
                        return true;
                    }
                    this.captureFailedLoginAttempt(context);
                } else {
                    this.log.log("Too many attempts from " + context.getClientID() + "; blocked temporarily.");
                }
            }
        }
        return false;
    }

    @Override
    public boolean isCookieLoginPermitted(Context context) {
        return this.isCookieLoginEnabled() && (!this.isCookieLoginSslOnly() || context.isSecure());
    }

    @Override
    public boolean isLoginAttemptPermitted(Context context) {
        if (this.isFailedAttemptLimiting()) {
            Map<String, LoginAttempt> map = this.getIpToAttempts();
            LoginAttempt attempt = map.get(context.getClientID());
            if (attempt == null) {
                return true;
            }
            return attempt.isGood();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureFailedLoginAttempt(Context context) {
        if (this.isFailedAttemptLimiting()) {
            LoginAttempt attempt;
            Map<String, LoginAttempt> map;
            Map<String, LoginAttempt> map2 = map = this.getIpToAttempts();
            synchronized (map2) {
                attempt = map.get(context.getClientID());
                if (attempt == null) {
                    attempt = new LoginAttempt();
                    map.put(context.getClientID(), attempt);
                }
            }
            attempt.attempt();
        }
    }

    protected void captureSuccessfulLoginAttempt(Context context) {
        if (this.isFailedAttemptLimiting()) {
            Map<String, LoginAttempt> map = this.getIpToAttempts();
            map.remove(context.getClientID());
        }
    }

    public GeminiApplication getApplication() {
        return this.application;
    }

    @Override
    public PyxisUser getNewUser() {
        return this.constructUser();
    }

    protected PyxisSettings constructPyxisSettings(GeminiApplication app) {
        return new PyxisSettings(app, PROPS_PREFIX);
    }

    @Override
    public boolean passwordTest(PyxisUser user, String password) {
        return user != null && this.passwordHasher.testPassword(password, user.getUserPassword());
    }

    @Override
    public PyxisUser getUser(String username, String password) {
        if (username == null || password == null) {
            return null;
        }
        PyxisUser user = (PyxisUser)this.store.get(this.userClass, "getUserUsername", username.toLowerCase());
        if (this.passwordTest(user, password)) {
            return user;
        }
        return null;
    }

    public PyxisUser getUserByEmail(String email, String password) {
        if (email == null || password == null) {
            return null;
        }
        try {
            PyxisUser user = (PyxisUser)this.store.get(this.userClass, "getUserEmail", email.toLowerCase());
            if (this.passwordTest(user, password)) {
                return user;
            }
        }
        catch (Exception exc) {
            this.log.log("Exception while retrieving user by email address: " + exc);
        }
        return null;
    }

    @Override
    public PyxisUser getUser(String username) {
        if (username == null) {
            return null;
        }
        return (PyxisUser)this.store.get(this.userClass, "getUserUsername", username.toLowerCase());
    }

    @Override
    public PyxisUser getUser(int userID) {
        return (PyxisUser)this.store.get(this.userClass, userID);
    }

    @Override
    public Collection<PyxisUserGroup> getAllUserGroups() {
        return this.store.list(this.groupClass);
    }

    @Override
    public PyxisUserGroup getUserGroup(String name) {
        return (PyxisUserGroup)this.store.get(this.groupClass, "getName", name);
    }

    @Override
    public PyxisUserGroup getUserGroup(int identity) {
        return (PyxisUserGroup)this.store.get(this.groupClass, identity);
    }

    @Override
    public int[] getGroupsForUser(int userID) {
        EntityRelation<U, G> relation = this.store.getRelation(this.userClass, this.groupClass);
        return relation.rightIDArray(userID);
    }

    @Override
    public int[] getUsersInGroup(int groupID) {
        EntityRelation<U, G> relation = this.store.getRelation(this.userClass, this.groupClass);
        return relation.leftIDArray(groupID);
    }

    @Override
    public boolean updateGroupMembership(int userID, int[] userGroupID) {
        EntityRelation<U, G> relation = this.store.getRelation(this.userClass, this.groupClass);
        relation.removeLeftValue(userID);
        int i = 0;
        while (i < userGroupID.length) {
            relation.add(userID, userGroupID[i]);
            ++i;
        }
        BasicUser user = (BasicUser)this.getUser(userID);
        if (user != null) {
            user.setUserGroups(this.getGroupsForUser(userID));
        }
        return true;
    }

    @Override
    public void addUserToGroup(PyxisUser user, int groupID, boolean dropAll) {
        EntityRelation<U, G> relation = this.store.getRelation(this.userClass, this.groupClass);
        if (dropAll) {
            relation.removeLeftValue(user.getId());
        }
        relation.add(user.getId(), groupID);
        BasicUser bUser = (BasicUser)user;
        bUser.setUserGroups(this.getGroupsForUser(user.getUserID()));
    }

    @Override
    public void removeUserFromGroup(PyxisUser user, int groupID) {
        EntityRelation<U, G> relation = this.store.getRelation(this.userClass, this.groupClass);
        relation.remove(user.getId(), groupID);
        BasicUser bUser = (BasicUser)user;
        bUser.setUserGroups(this.getGroupsForUser(user.getUserID()));
    }

    public String toString() {
        return "CachingSecurity [u:" + (this.userClass != null ? Integer.valueOf(this.userClass.hashCode()) : "<not-specified>") + "]";
    }

    @Override
    public Collection<PyxisUserGroup> getStandardUserGroups() {
        return this.standardUserGroups;
    }

    public boolean saveGroupMembership(BasicUser user) {
        return this.updateGroupMembership(user.getUserID(), user.getUserGroups());
    }

    @Override
    public void setUserMembership(PyxisUser user, int groupID, boolean member) {
        if (member) {
            this.addUserToGroup(user, groupID);
        } else {
            this.removeUserFromGroup(user, groupID);
        }
    }

    @Override
    public void addUserToGroup(PyxisUser user, PyxisUserGroup group) {
        this.addUserToGroup(user, group, false);
    }

    @Override
    public void addUserToGroup(PyxisUser user, int groupID) {
        this.addUserToGroup(user, groupID, false);
    }

    @Override
    public void addUserToGroup(PyxisUser user, PyxisUserGroup group, boolean dropAll) {
        if (group == null) {
            return;
        }
        this.addUserToGroup(user, group.getId(), dropAll);
    }

    @Override
    public void removeUserFromGroup(PyxisUser user, PyxisUserGroup group) {
        if (group == null) {
            return;
        }
        this.removeUserFromGroup(user, group.getId());
    }

    @Override
    public boolean login(Context context, String username, String password) {
        return this.login(context, username, password, false);
    }

    @Override
    public boolean login(Context context, String username, String password, boolean save) {
        PyxisUser user = this.getUser(username, password);
        if (user == null && this.settings.isEmailAuthenticationEnabled()) {
            user = this.getUserByEmail(username, password);
        }
        return this.login(context, user);
    }

    @Override
    public boolean login(Context context, PyxisUser user) {
        return this.login(context, user, false);
    }

    @Override
    public boolean login(Context context, PyxisUser user, boolean save) {
        if (user != null && user.isEnabled()) {
            if (this.storeUserAsID) {
                context.session().put("Pyxis.User", user.getId());
            } else {
                context.session().putObject("Pyxis.User", user);
            }
            this.recordUserSessionID(context, user);
            if (save && this.isCookieLoginPermitted(context)) {
                this.getLoginTokenManager().createAndPersistToken(context, user.getUserUsername());
            }
            this.captureSuccessfulLoginAttempt(context);
            for (SecurityListener<Context> notify : this.listeners) {
                notify.loginSuccessful(context, user);
            }
            return true;
        }
        this.captureFailedLoginAttempt(context);
        for (SecurityListener<Context> notify : this.listeners) {
            notify.loginFailed(context);
        }
        return false;
    }

    protected void recordUserSessionID(Context context, PyxisUser user) {
        this.userSessionIDs.put(user.getUserID(), context.getSession(true).getId());
    }

    @Override
    public void logout(Context context) {
        PyxisUser user = this.getUser(context);
        this.notifyListenersLogout(user, context);
        context.session().put("Pyxis.SessionCloseIndicator", 1).remove("Pyxis.User").remove("Pyxis.SessionCloseIndicator").remove("Pyxis.UsedCookieLogin").remove("Pyxis.PasswordExpirationWarned");
        if (this.settings.isInvalidateSessionAtLogout()) {
            context.session().invalidate();
        }
        if (this.logoutDeletesCookie) {
            this.removeAutomaticLoginCookie(context);
        }
    }

    protected void removeAutomaticLoginCookie(Context context) {
        if (this.loginTokenManager != null) {
            this.log.log("Deleting automatic login cookie.", 0);
            this.loginTokenManager.clearCookie(context);
        }
    }

    @Override
    public void logout(PyxisUser user) {
        this.notifyListenersLogout(user, null);
    }

    protected void notifyListenersLogout(PyxisUser user, Context context) {
        if (user != null) {
            for (SecurityListener<Context> notify : this.listeners) {
                notify.logoutSuccessful(context, user);
            }
        }
    }

    @Override
    public PyxisUser getUser(Context context) {
        if (this.storeUserAsID) {
            return this.getUser(context.session().getInt("Pyxis.User", 0));
        }
        return (PyxisUser)context.session().getObject("Pyxis.User");
    }

    @Override
    public PyxisUser getUser(Session session) {
        if (this.storeUserAsID) {
            Integer userID = (Integer)session.getAttribute("Pyxis.User");
            if (userID != null) {
                return this.getUser(userID);
            }
            return null;
        }
        return (PyxisUser)session.getAttribute("Pyxis.User");
    }

    @Override
    public boolean isLoggedIn(Context context) {
        boolean loggedIn;
        PyxisUser user = this.getUser(context);
        boolean bl = loggedIn = user != null;
        if (loggedIn && !this.allowMultipleSessions) {
            String correctSessionID = (String)this.userSessionIDs.get(user.getUserID());
            String sessionID = context.getSession(true).getId();
            if (correctSessionID != null) {
                if (!correctSessionID.equalsIgnoreCase("EXEMPT") && !sessionID.equalsIgnoreCase(correctSessionID)) {
                    context.delivery().put(MULTISESSION_VIOLATION, true);
                    context.session().clear();
                    return false;
                }
            } else {
                this.recordUserSessionID(context, user);
            }
        }
        return loggedIn;
    }

    @Override
    public boolean isAdministrator(Context context) {
        PyxisUser user = this.getUser(context);
        if (user != null) {
            return user.isAdministrator();
        }
        return false;
    }

    @Override
    public boolean isUser(Context context) {
        PyxisUser user = this.getUser(context);
        if (user != null) {
            return user.isUser();
        }
        return false;
    }

    @Override
    public boolean isGuest(Context context) {
        PyxisUser user = this.getUser(context);
        if (user != null) {
            return user.isGuest();
        }
        return false;
    }

    @Override
    public PasswordHasher getPasswordHasher() {
        return this.passwordHasher;
    }

    @Override
    public List<String> passwordValidate(PasswordProposal proposal) {
        ArrayList<String> toReturn = new ArrayList<String>(this.passwordRequirements.size());
        for (PasswordRequirement requirement : this.passwordRequirements) {
            String result = requirement.validate(proposal);
            if (result == null) continue;
            toReturn.add(result);
        }
        return toReturn;
    }

    @Override
    public List<String> passwordChange(PasswordProposal proposal) {
        List<String> validation = this.passwordValidate(proposal);
        if (validation.isEmpty()) {
            proposal.hashedPassword = this.passwordHasher.encryptPassword(proposal.password);
            proposal.user.setUserPassword(proposal.hashedPassword);
            proposal.user.setUserLastPasswordChange(new Date());
            for (SecurityListener<Context> notify : this.listeners) {
                notify.passwordChanged(proposal);
            }
        }
        return validation;
    }

    @Override
    public void saveUser(PyxisUser user) {
        this.application.getEntityUpdater().add(user);
    }

    protected synchronized Map<String, LoginAttempt> getIpToAttempts() {
        this.autoResetAttemptsIfNeeded();
        if (this.ipToAttempts == null) {
            this.ipToAttempts = new HashMap<String, LoginAttempt>();
        }
        return this.ipToAttempts;
    }

    protected void autoResetAttemptsIfNeeded() {
        if (System.currentTimeMillis() > this.nextAutoReset) {
            this.resetLoginAttempts();
            this.nextAutoReset = DateHelper.getEndOfDay().getTime().getTime();
        }
    }

    protected synchronized void resetLoginAttempts() {
        this.ipToAttempts = null;
    }

    protected void constructStandardGroups() {
        this.standardUserGroups = new ArrayList<PyxisUserGroup>(3);
        this.standardUserGroups.add(new PyxisAdministratorsGroup());
        this.standardUserGroups.add(new PyxisUsersGroup());
        this.standardUserGroups.add(new PyxisGuestsGroup());
    }

    @Override
    public PyxisUser constructUser() {
        return new BasicUser(this);
    }

    @Override
    public PyxisUserGroup constructUserGroup() {
        return new BasicUserGroup();
    }

    @Override
    public <C extends Context> void addListener(SecurityListener<C> listener) {
        this.listeners.add(listener);
    }

    @Override
    public <C extends Context> void removeListener(SecurityListener<C> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Class<PyxisUser> getUserClass() {
        return this.userClass;
    }

    @Override
    public Class<PyxisUserGroup> getUserGroupClass() {
        return this.groupClass;
    }

    protected class LoginAttempt {
        private int count = 0;
        private long resetTime = 0L;

        public void setFailState() {
            this.count = 0;
            this.resetTime = System.currentTimeMillis() + (long)BasicSecurity.this.failedResetSeconds * 1000L;
        }

        public boolean isGood() {
            return this.resetTime < System.currentTimeMillis();
        }

        public void attempt() {
            ++this.count;
            if (this.count >= BasicSecurity.this.failedAttemptLimit) {
                this.setFailState();
            }
        }
    }
}

