/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis;

import com.techempower.gemini.pyxis.BasicSecurity;
import com.techempower.gemini.pyxis.BasicUser;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.PyxisUserGroup;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.mindrot.jbcrypt.BCrypt;

public class BasicWebUser
extends BasicUser
implements HttpSessionBindingListener {
    public static final int MAX_EMAIL_LENGTH = 254;
    private String userEmail = "";
    private String userPasswordHint = "";
    private String emailVerificationTicket = "";
    private Date emailVerificationDate = null;
    private String passwordResetTicket = "";
    private Date passwordResetExpiration = null;

    public BasicWebUser(BasicSecurity<? extends PyxisUser, ? extends PyxisUserGroup> security) {
        super(security);
    }

    @Override
    public String toString() {
        return "BasicWebUser [id: " + this.getUserID() + "; un: " + this.getUserUsername() + "]";
    }

    public boolean verify(String ticket) {
        if (StringHelper.isNonEmpty(this.emailVerificationTicket) && this.emailVerificationDate == null && this.emailVerificationTicket.equals(ticket)) {
            this.emailVerificationDate = new Date();
            return true;
        }
        return StringHelper.isNonEmpty(this.emailVerificationTicket) && this.emailVerificationTicket.equals(ticket);
    }

    public boolean isPasswordResetAuthorized(String resetTicket) {
        return StringHelper.isNonEmpty(resetTicket) && this.passwordResetExpiration != null && this.passwordResetExpiration.after(new Date()) && BCrypt.checkpw((String)resetTicket, (String)this.passwordResetTicket);
    }

    public String generateNewEmailVerificationTicket() {
        this.setEmailVerificationTicket(StringHelper.getRandomAlphaNumeric(this.getEmailVerificationTicketLength()));
        return this.getEmailVerificationTicket();
    }

    public String generateNewPasswordResetTicket(int expirationDays) {
        String ticket = StringHelper.getRandomAlphaNumeric(this.getEmailVerificationTicketLength());
        this.setPasswordResetTicket(BCrypt.hashpw((String)ticket, (String)BCrypt.gensalt()));
        Calendar cal = DateHelper.getCalendarInstance();
        cal.add(6, expirationDays);
        this.setPasswordResetExpiration(cal.getTime());
        return ticket;
    }

    public int getEmailVerificationTicketLength() {
        return 15;
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        if (this.getSecurity() != null) {
            HttpSession session = event.getSession();
            try {
                Object close = session.getAttribute("Pyxis.SessionCloseIndicator");
                if (close == null) {
                    this.getSecurity().logout(this);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void setUserEmail(String email) {
        this.userEmail = email == null ? null : StringHelper.trim(StringHelper.truncate(email, 254)).toLowerCase();
    }

    public void setUserPasswordHint(String passwordHint) {
        this.userPasswordHint = passwordHint;
    }

    public String getPasswordResetTicket() {
        return this.passwordResetTicket;
    }

    public void setPasswordResetTicket(String passwordResetTicket) {
        this.passwordResetTicket = passwordResetTicket;
    }

    public Date getPasswordResetExpiration() {
        return DateHelper.copy(this.passwordResetExpiration);
    }

    public void setPasswordResetExpiration(Date passwordResetExpiration) {
        this.passwordResetExpiration = DateHelper.copy(passwordResetExpiration);
    }

    public void setEmailVerificationTicket(String emailVerificationTicket) {
        this.emailVerificationTicket = emailVerificationTicket;
    }

    public void setEmailVerificationDate(Date emailVerificationDate) {
        this.emailVerificationDate = DateHelper.copy(emailVerificationDate);
    }

    public String getEmailVerificationTicket() {
        return this.emailVerificationTicket;
    }

    public Date getEmailVerificationDate() {
        return DateHelper.copy(this.emailVerificationDate);
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getUserPasswordHint() {
        return this.userPasswordHint;
    }
}

