/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis;

import com.techempower.data.ConnectionMonitor;
import com.techempower.data.DatabaseAffinity;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.ResponseCookie;
import com.techempower.helper.DateHelper;
import com.techempower.helper.ThreadHelper;
import com.techempower.log.ComponentLog;
import com.techempower.scheduler.ScheduledEvent;
import com.techempower.scheduler.Scheduler;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.security.SecureRandom;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Objects;
import org.mindrot.jbcrypt.BCrypt;

public class LoginTokenManager
implements Configurable {
    private static final int TOKEN_DIGITS = 30;
    private static final String TOKEN_CHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DEFAULT_DATABASE_TABLE_NAME = "logintoken";
    private static final boolean DEFAULT_COOKIE_SECURE = true;
    private static final int DEFAULT_MAX_TOKENS_PER_USER = 50;
    private static final boolean DEFAULT_PURGE_EVENT_ENABLED = true;
    private static final int DEFAULT_PURGE_EVENT_MAX_TOKEN_AGE_IN_DAYS = 100;
    private static final int DEFAULT_PURGE_EVENT_INTERVAL_IN_DAYS = 5;
    private static final int DEFAULT_PURGE_EVENT_HOUR = 5;
    private static final int DEFAULT_PURGE_EVENT_MINUTE = 30;
    private String databaseTableName = "logintoken";
    private boolean cookieSecure = true;
    private int maxTokensPerUser = 50;
    private boolean purgeEventEnabled = true;
    private int purgeEventMaxTokenAgeInDays = 100;
    private int purgeEventIntervalInDays = 5;
    private int purgeEventHour = 5;
    private int purgeEventMinute = 30;
    private final GeminiApplication application;
    private final ComponentLog log;
    private final PurgeEvent purgeEvent;

    public LoginTokenManager(GeminiApplication application) {
        Objects.requireNonNull(application);
        this.application = application;
        this.log = application.getLog("auth");
        LoginTokenManager loginTokenManager = this;
        loginTokenManager.getClass();
        this.purgeEvent = loginTokenManager.new PurgeEvent();
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
        Objects.requireNonNull(props);
        this.databaseTableName = props.getProperty("LoginTokenManager.DatabaseTableName", DEFAULT_DATABASE_TABLE_NAME);
        this.cookieSecure = props.getYesNoProperty("LoginTokenManager.CookieSecure", true);
        this.maxTokensPerUser = props.getIntegerProperty("LoginTokenManager.MaxTokensPerUser", 50, 1, Integer.MAX_VALUE);
        this.purgeEventEnabled = props.getYesNoProperty("LoginTokenManager.PurgeEvent.Enabled", true);
        this.purgeEventMaxTokenAgeInDays = props.getIntegerProperty("LoginTokenManager.PurgeEvent.MaxTokenAgeInDays", 100, 0, Integer.MAX_VALUE);
        this.purgeEventIntervalInDays = props.getIntegerProperty("LoginTokenManager.PurgeEvent.IntervalInDays", 5, 1, Integer.MAX_VALUE);
        this.purgeEventHour = props.getIntegerProperty("LoginTokenManager.PurgeEvent.Hour", 5, 0, 23);
        this.purgeEventMinute = props.getIntegerProperty("LoginTokenManager.PurgeEvent.Minute", 30, 0, 59);
        this.application.getScheduler().removeEvent(this.purgeEvent);
        if (this.purgeEventEnabled) {
            this.application.getScheduler().scheduleEvent(this.purgeEvent);
        }
        this.log.log("Configured " + this, 50);
    }

    public String toString() {
        return String.format("%s{databaseTableName=%s, cookieSecure=%s, maxTokensPerUser=%s, purgeEventEnabled=%s, purgeEventMaxTokenAgeInDays=%s, purgeEventIntervalInDays=%s, purgeEventHour=%s, purgeEventMinute=%s}", this.getClass().getSimpleName(), this.databaseTableName, this.cookieSecure, this.maxTokensPerUser, this.purgeEventEnabled, this.purgeEventMaxTokenAgeInDays, this.purgeEventIntervalInDays, this.purgeEventHour, this.purgeEventMinute);
    }

    private String enquote(String tableOrColumn) {
        Objects.requireNonNull(tableOrColumn);
        String quote = this.application.getConnectorFactory().getIdentifierQuoteString();
        return String.valueOf(quote) + tableOrColumn + quote;
    }

    private String generateToken() {
        StringBuilder tokenBuilder = new StringBuilder(30);
        SecureRandom random = new SecureRandom();
        int i = 0;
        while (i < 30) {
            tokenBuilder.append(TOKEN_CHARACTERS.charAt(random.nextInt(TOKEN_CHARACTERS.length())));
            ++i;
        }
        return tokenBuilder.toString();
    }

    private String generateCookieValue(String username, String token) {
        Objects.requireNonNull(username);
        Objects.requireNonNull(token);
        return String.valueOf(username) + "|" + token;
    }

    private String generateTokenHash(String username, String token) {
        Objects.requireNonNull(username);
        Objects.requireNonNull(token);
        return BCrypt.hashpw((String)this.generateCookieValue(username, token), (String)BCrypt.gensalt());
    }

    private String generateCookieName() {
        return String.valueOf(this.application.getVersion().getProductCode()) + "-automatic-login";
    }

    private String generateTimestamp() {
        return new Timestamp(System.currentTimeMillis()).toString();
    }

    private ResponseCookie generateCookie(String cookieName, String cookieValue) {
        Objects.requireNonNull(cookieName);
        Objects.requireNonNull(cookieValue);
        ResponseCookie cookie = new ResponseCookie(cookieName, cookieValue);
        cookie.setPath(this.application.getInfrastructure().getUrl());
        if (this.cookieSecure) {
            cookie.setSecure(true);
        }
        return cookie;
    }

    private void purgeTokens(int maxTokenAgeInDays) throws SQLException {
        int staleTokensPurged = 0;
        Calendar staleDate = DateHelper.getStartOfDay();
        staleDate.add(6, -1 * maxTokenAgeInDays);
        String staleTimestamp = new Timestamp(staleDate.getTimeInMillis()).toString();
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            ConnectionMonitor monitor = this.application.getConnectorFactory().getConnectionMonitor();
            try {
                try (PreparedStatement statement = monitor.getConnection().prepareStatement("DELETE FROM " + this.enquote(this.databaseTableName) + " WHERE " + this.enquote("created") + " < ?;");){
                    statement.setString(1, staleTimestamp);
                    staleTokensPurged = statement.executeUpdate();
                }
                if (monitor != null) {
                    monitor.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (monitor != null) {
                    monitor.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        this.log.log("Purged " + staleTokensPurged + " stale tokens.", 50);
    }

    public void clearCookie(Context context) {
        Objects.requireNonNull(context);
        context.cookies().remove(this.generateCookieName());
    }

    public void createAndPersistToken(Context context, final String username) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(username);
        final String token = this.generateToken();
        ThreadHelper.submit(new Runnable(){

            @Override
            public void run() {
                Throwable e2;
                PreparedStatement statement;
                ConnectionMonitor monitor;
                Object var2_8;
                try {
                    Throwable throwable = null;
                    var2_8 = null;
                    try {
                        monitor = LoginTokenManager.this.application.getConnectorFactory().getConnectionMonitor();
                        try {
                            statement = monitor.getConnection().prepareStatement("INSERT INTO " + LoginTokenManager.this.enquote(LoginTokenManager.this.databaseTableName) + " (" + LoginTokenManager.this.enquote("username") + ", " + LoginTokenManager.this.enquote("tokenhash") + ", " + LoginTokenManager.this.enquote("created") + ")" + " VALUES (?, ?, ?);");
                            try {
                                statement.setString(1, username);
                                statement.setString(2, LoginTokenManager.this.generateTokenHash(username, token));
                                statement.setString(3, LoginTokenManager.this.generateTimestamp());
                                statement.executeUpdate();
                            }
                            finally {
                                if (statement != null) {
                                    statement.close();
                                }
                            }
                            if (monitor != null) {
                                monitor.close();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (monitor != null) {
                                monitor.close();
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e2) {
                    LoginTokenManager.this.log.log("Error while persisting new token for user: " + username, 70, e2);
                }
                if (LoginTokenManager.this.application.getConnectorFactory().getDatabaseAffinity() == DatabaseAffinity.MS_SQL_SERVER) {
                    try {
                        e2 = null;
                        var2_8 = null;
                        try {
                            monitor = LoginTokenManager.this.application.getConnectorFactory().getConnectionMonitor();
                            try {
                                statement = monitor.getConnection().prepareStatement("DELETE FROM " + LoginTokenManager.this.enquote(LoginTokenManager.this.databaseTableName) + " WHERE " + LoginTokenManager.this.enquote("username") + " = ? AND " + LoginTokenManager.this.enquote("created") + " NOT IN (SELECT TOP " + LoginTokenManager.this.maxTokensPerUser + " " + LoginTokenManager.this.enquote("created") + " FROM " + LoginTokenManager.this.enquote(LoginTokenManager.this.databaseTableName) + " ORDER BY " + LoginTokenManager.this.enquote("created") + " DESC);");
                                try {
                                    statement.setString(1, username);
                                    statement.executeUpdate();
                                }
                                finally {
                                    if (statement != null) {
                                        statement.close();
                                    }
                                }
                                if (monitor != null) {
                                    monitor.close();
                                }
                            }
                            catch (Throwable throwable) {
                                if (e2 == null) {
                                    e2 = throwable;
                                } else if (e2 != throwable) {
                                    e2.addSuppressed(throwable);
                                }
                                if (monitor != null) {
                                    monitor.close();
                                }
                                throw e2;
                            }
                        }
                        catch (Throwable throwable) {
                            if (e2 == null) {
                                e2 = throwable;
                            } else if (e2 != throwable) {
                                e2.addSuppressed(throwable);
                            }
                            throw e2;
                        }
                    }
                    catch (SQLException e3) {
                        LoginTokenManager.this.log.log("Error while trimming excess tokens for user: " + username, 70, e3);
                    }
                } else {
                    try {
                        e2 = null;
                        var2_8 = null;
                        try {
                            monitor = LoginTokenManager.this.application.getConnectorFactory().getConnectionMonitor();
                            try {
                                statement = monitor.getConnection().prepareStatement("DELETE FROM " + LoginTokenManager.this.enquote(LoginTokenManager.this.databaseTableName) + " WHERE " + LoginTokenManager.this.enquote("username") + " = ? AND " + LoginTokenManager.this.enquote("created") + " NOT IN (SELECT * FROM (SELECT " + LoginTokenManager.this.enquote("created") + " FROM " + LoginTokenManager.this.enquote(LoginTokenManager.this.databaseTableName) + " ORDER BY " + LoginTokenManager.this.enquote("created") + " DESC LIMIT ?) AS t);");
                                try {
                                    statement.setString(1, username);
                                    statement.setInt(2, LoginTokenManager.this.maxTokensPerUser);
                                    statement.executeUpdate();
                                }
                                finally {
                                    if (statement != null) {
                                        statement.close();
                                    }
                                }
                                if (monitor != null) {
                                    monitor.close();
                                }
                            }
                            catch (Throwable throwable) {
                                if (e2 == null) {
                                    e2 = throwable;
                                } else if (e2 != throwable) {
                                    e2.addSuppressed(throwable);
                                }
                                if (monitor != null) {
                                    monitor.close();
                                }
                                throw e2;
                            }
                        }
                        catch (Throwable throwable) {
                            if (e2 == null) {
                                e2 = throwable;
                            } else if (e2 != throwable) {
                                e2.addSuppressed(throwable);
                            }
                            throw e2;
                        }
                    }
                    catch (SQLException e4) {
                        LoginTokenManager.this.log.log("Error while trimming excess tokens for user: " + username, 70, e4);
                    }
                }
            }
        });
        String cookieName = this.generateCookieName();
        String cookieValue = this.generateCookieValue(username, token);
        context.cookies().put(this.generateCookie(cookieName, cookieValue));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TokenValidation validateAndUpdateToken(Context context) throws SQLException {
        Objects.requireNonNull(context);
        cookieName = this.generateCookieName();
        cookieValue = context.cookies().getValue(cookieName);
        if (cookieValue == null) {
            return TokenValidation.access$0();
        }
        pipeIndex = cookieValue.indexOf(124);
        if (pipeIndex < 0 || pipeIndex == cookieValue.length() - 1) {
            context.cookies().remove(cookieName);
            return TokenValidation.access$0();
        }
        username = cookieValue.substring(0, pipeIndex);
        var6_6 = null;
        var7_8 = null;
        try {
            monitor = this.application.getConnectorFactory().getConnectionMonitor();
            try {
                statement = monitor.getConnection().prepareStatement("SELECT " + this.enquote("id") + ", " + this.enquote("username") + ", " + this.enquote("tokenhash") + ", " + this.enquote("created") + " FROM " + this.enquote(this.databaseTableName) + " WHERE " + this.enquote("username") + " = ?;", 1003, 1008);
                statement.setString(1, username);
                resultSet = statement.executeQuery();
                finally {
                    if (!resultSet.next()) ** GOTO lbl-1000
                }
                tokenHash = resultSet.getString("tokenhash");
                if (BCrypt.checkpw((String)cookieValue, (String)tokenHash)) {
                    newToken = this.generateToken();
                    resultSet.updateString(3, this.generateTokenHash(username, newToken));
                    resultSet.updateString(4, this.generateTimestamp());
                    resultSet.updateRow();
                    newCookieValue = this.generateCookieValue(username, newToken);
                    context.cookies().put(this.generateCookie(cookieName, newCookieValue));
                    v0 = new TokenValidation(true, username);
                    return v0;
                }
lbl-1000:
                // 1 sources

                {
                    if (statement == null) ** GOTO lbl49
                    ** GOTO lbl48
                }
            }
            catch (Throwable var7_9) {
                if (var6_6 == null) {
                    var6_6 = var7_9;
                } else if (var6_6 != var7_9) {
                    var6_6.addSuppressed(var7_9);
                }
                if (monitor == null) throw var6_6;
                monitor.close();
                throw var6_6;
lbl48:
                // 1 sources

                statement.close();
lbl49:
                // 2 sources

                if (monitor != null) {
                    monitor.close();
                }
            }
        }
        catch (Throwable var7_10) {
            if (var6_6 == null) {
                var6_6 = var7_10;
                throw var6_6;
            }
            if (var6_6 == var7_10) throw var6_6;
            var6_6.addSuppressed(var7_10);
            throw var6_6;
        }
        context.cookies().remove(cookieName);
        return TokenValidation.access$0();
    }

    private final class PurgeEvent
    extends ScheduledEvent {
        private PurgeEvent() {
        }

        @Override
        public long getDefaultScheduledTime() {
            Calendar scheduledTime = DateHelper.getStartOfDay();
            scheduledTime.add(6, LoginTokenManager.this.purgeEventIntervalInDays);
            scheduledTime.set(11, LoginTokenManager.this.purgeEventHour);
            scheduledTime.set(12, LoginTokenManager.this.purgeEventMinute);
            return scheduledTime.getTimeInMillis();
        }

        @Override
        public String getName() {
            return "Login Token Purge Event";
        }

        @Override
        public boolean requiresOwnThread() {
            return true;
        }

        @Override
        public String getDescription() {
            return "Periodically removes old authentication tokens from the data store.";
        }

        @Override
        public void execute(Scheduler scheduler) {
            try {
                try {
                    LoginTokenManager.this.purgeTokens(LoginTokenManager.this.purgeEventMaxTokenAgeInDays);
                }
                catch (SQLException e) {
                    LoginTokenManager.this.log.log(String.valueOf(this.getName()) + " had an exception during scheduled execution.", 70, e);
                    scheduler.scheduleEvent((ScheduledEvent)this, this.getDefaultScheduledTime());
                }
            }
            finally {
                scheduler.scheduleEvent((ScheduledEvent)this, this.getDefaultScheduledTime());
            }
        }
    }

    public static final class TokenValidation {
        private static final TokenValidation FAILURE = new TokenValidation(false, null);
        private final boolean valid;
        private final String username;

        private TokenValidation(boolean valid, String username) {
            this.valid = valid;
            this.username = username;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getUsername() {
            return this.username;
        }

        static /* synthetic */ TokenValidation access$0() {
            return FAILURE;
        }
    }
}

