/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis.handler;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.path.MethodPathHandler;
import com.techempower.gemini.path.annotation.PathDefault;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.handler.PyxisHandlerHelper;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;

public class LogoutHandler<C extends Context>
extends MethodPathHandler<C>
implements Configurable {
    public static final String DEFAULT_PROPS_PREFIX = "LogoutHandler.";
    private final PyxisSecurity security;
    private final String propsPrefix;
    private String logoutTemplate = "auth/logout";
    private String logoutMessage = "Successfully logged out.";
    private String noUserTemplate = "auth/logout-nouser";
    private String noUserMessage = "No user is logged in.";

    public LogoutHandler(GeminiApplication app, String propsPrefix) {
        super(app);
        this.propsPrefix = propsPrefix != null ? propsPrefix : DEFAULT_PROPS_PREFIX;
        this.app().getConfigurator().addConfigurable(this);
        this.security = this.app().getSecurity();
    }

    public LogoutHandler(GeminiApplication application) {
        this(application, null);
    }

    @Override
    public void configure(EnhancedProperties props) {
        EnhancedProperties.Focus focus = PyxisHandlerHelper.getFocus(props, this.propsPrefix);
        this.logoutTemplate = focus.getProperty("LogoutTemplate", this.logoutTemplate);
        this.logoutMessage = focus.getProperty("LogoutMessage", this.logoutTemplate);
        this.noUserTemplate = focus.getProperty("NoUserTemplate", this.noUserTemplate);
        this.noUserMessage = focus.getProperty("NoUserMessage", this.noUserMessage);
    }

    protected PyxisSecurity getSecurity() {
        return this.security;
    }

    @PathDefault
    public boolean logout(Context context) {
        if (this.getSecurity().isLoggedIn(context)) {
            this.getSecurity().logout(context);
            return this.handlePostLogout();
        }
        return this.handleLogoutNoUser();
    }

    protected boolean handleLogoutNoUser() {
        ((Context)this.context()).delivery().put("message", this.noUserMessage);
        return this.template(this.noUserTemplate).render();
    }

    protected boolean handlePostLogout() {
        ((Context)this.context()).delivery().put("message", this.logoutMessage);
        return this.template(this.logoutTemplate).render();
    }
}

