/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.pyxis.handler;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormPasswordField;
import com.techempower.gemini.form.FormSubmitButton;
import com.techempower.gemini.form.PostOnlyForm;
import com.techempower.gemini.form.validator.PasswordAuthenticationValidator;
import com.techempower.gemini.form.validator.PasswordComplexityValidator;
import com.techempower.gemini.path.MethodPathHandler;
import com.techempower.gemini.path.annotation.PathDefault;
import com.techempower.gemini.path.annotation.PathSegment;
import com.techempower.gemini.prehandler.Prehandler;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.password.PasswordProposal;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;

public class PasswordExpirationHandler<C extends Context>
extends MethodPathHandler<C>
implements Prehandler,
Configurable {
    public static final String COMPONENT_CODE = "hPsE";
    public static final String DEFAULT_NO_CHANGE_NEEDED_URI = "/";
    public static final String TEMPLATE_PASSWORD_EXPIRED = "auth/password-expiration-expired";
    public static final String TEMPLATE_PASSWORD_WARNING = "auth/password-expiration-warning";
    public static final String TEMPLATE_PASSWORD_CHANGED = "auth/password-expiration-changed";
    private final PyxisSecurity security;
    private String noChangeNeededUri = "/";

    public PasswordExpirationHandler(GeminiApplication application) {
        super(application, COMPONENT_CODE);
        this.security = application.getSecurity();
    }

    @Override
    public void configure(EnhancedProperties props) {
        EnhancedProperties.Focus focus = props.focus("PasswordExpirationHandler.");
        this.noChangeNeededUri = focus.getProperty("NoChangeNeededUri", DEFAULT_NO_CHANGE_NEEDED_URI);
    }

    protected Form buildForm(PyxisUser user) {
        PostOnlyForm form = new PostOnlyForm(this.app(), "resetexpiredpw", ((Context)this.context()).getUrl());
        form.add(new FormPasswordField("Current password", "cpw", "", true, 30, 30).addValidator(new PasswordAuthenticationValidator(this.security, user)));
        form.add(new FormPasswordField("New Password", "npw", "", true, 30, 30).setConfirm(true, true).addValidator(new PasswordComplexityValidator(this.security, user)));
        form.add(new FormSubmitButton("submit", "Submit", true));
        return form;
    }

    public boolean isEnabled() {
        return this.security.getSettings().getPasswordExpirationDays() > 0;
    }

    protected PyxisSecurity getSecurity() {
        return this.security;
    }

    protected PasswordStatus getPasswordStatus(PyxisUser user) {
        return new PasswordStatus(user);
    }

    @Override
    public boolean prehandle(Context context) {
        PyxisUser user;
        String uri;
        if (this.isEnabled() && !(uri = context.getRequestUri()).startsWith(this.getBaseUri()) && (user = this.security.getUser(context)) != null) {
            PasswordStatus status = this.getPasswordStatus(user);
            if (status.expired()) {
                return context.redirect(String.valueOf(this.getBaseUri()) + "/expired");
            }
            if (status.warning() && !context.session().has("Pyxis.PasswordExpirationWarned")) {
                return context.redirect(String.valueOf(this.getBaseUri()) + "/warning");
            }
        }
        return false;
    }

    protected boolean processForm(PyxisUser user, String mustacheTemplate) {
        Form resetForm = this.buildForm(user);
        if (resetForm.hasBeenValidlySubmitted(this.context())) {
            PasswordProposal proposal = new PasswordProposal(resetForm.values().get("npw"), user.getUserUsername(), user, (Context)this.context());
            this.security.passwordChange(proposal);
            this.store().put(user);
            return this.redirectRelative("changed");
        }
        this.delivery().putObject("form", resetForm);
        return this.mustache(mustacheTemplate);
    }

    @PathSegment
    public boolean expired() {
        PyxisUser user = this.security.getUser((Context)this.context());
        if (user != null) {
            PasswordStatus status = this.getPasswordStatus(user);
            if (status.expired()) {
                this.l("Password expired for user " + user.getUserID() + DEFAULT_NO_CHANGE_NEEDED_URI + user.getUserUsername() + ".");
                return this.processForm(user, TEMPLATE_PASSWORD_EXPIRED);
            }
            if (status.warning()) {
                return this.redirectRelative("warning");
            }
        }
        return this.redirect(this.noChangeNeededUri);
    }

    @PathSegment
    public boolean warning() {
        PyxisUser user = this.security.getUser((Context)this.context());
        if (user != null) {
            PasswordStatus status = this.getPasswordStatus(user);
            if (status.expired()) {
                return this.redirectRelative("expired");
            }
            if (status.warning()) {
                this.session().put("Pyxis.PasswordExpirationWarned", true);
                this.delivery().put("days", status.daysUntilExpiration).put("daysPlural", status.daysUntilExpiration > 1).put("noChangeUri", this.noChangeNeededUri);
                return this.processForm(user, TEMPLATE_PASSWORD_WARNING);
            }
        }
        return this.redirect(this.noChangeNeededUri);
    }

    @PathDefault
    public boolean changed() {
        PyxisUser user = this.security.getUser((Context)this.context());
        if (user != null) {
            PasswordStatus status = this.getPasswordStatus(user);
            if (status.expired()) {
                return this.redirectRelative("expired");
            }
            this.delivery().put("noChangeUri", this.noChangeNeededUri);
            return this.mustache(TEMPLATE_PASSWORD_CHANGED);
        }
        return this.redirect(this.noChangeNeededUri);
    }

    protected class PasswordStatus {
        static final int OKAY = 0;
        static final int WARNING = 1;
        static final int EXPIRED = 2;
        int status;
        int daysUntilExpiration;

        protected PasswordStatus() {
        }

        public PasswordStatus(PyxisUser user) {
            long expirationTime = user.getUserLastPasswordChange().getTime() + (long)PasswordExpirationHandler.this.security.getSettings().getPasswordExpirationDays() * 86400000L;
            this.initializeByExpiration(expirationTime);
        }

        protected void initializeByExpiration(long expirationTime) {
            long now = System.currentTimeMillis();
            if (now > expirationTime) {
                this.status = 2;
            } else {
                this.daysUntilExpiration = (int)((expirationTime - now) / 86400000L);
                System.out.println("Days until expiration: " + this.daysUntilExpiration);
                this.status = this.daysUntilExpiration < PasswordExpirationHandler.this.security.getSettings().getEarlyWarningDays() ? 1 : 0;
            }
        }

        public boolean expired() {
            return this.status == 2;
        }

        public boolean warning() {
            return this.status == 1;
        }
    }
}

